/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.monitor;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceService;
import com.zkteco.zkbiosecurity.acc.service.AccDoorService;
import com.zkteco.zkbiosecurity.acc.service.AccMonitorRedirectService;
import com.zkteco.zkbiosecurity.acc.service.AccPersonService;
import com.zkteco.zkbiosecurity.acc.service.AccRTMonitorService;
import com.zkteco.zkbiosecurity.acc.utils.AccEnumUtil;
import com.zkteco.zkbiosecurity.acc.vo.AccDeviceEventItem;
import com.zkteco.zkbiosecurity.acc.vo.AccDeviceMonitorItem;
import com.zkteco.zkbiosecurity.acc.vo.AccDoorItem;
import com.zkteco.zkbiosecurity.acc.vo.AccTransactionItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Component;

@Component
public class AccMonitorRedirectServiceImpl
implements AccMonitorRedirectService {
    @Autowired
    private SimpMessagingTemplate messagingTemplate;
    @Autowired
    private AccDeviceService accDeviceService;
    @Autowired
    private AccRTMonitorService accRTMonitorService;
    @Autowired
    private AccDoorService accDoorService;
    @Autowired
    private AccPersonService accPersonService;

    public void sendAccTransaction2RTMonitor(AccTransactionItem accTransactionItem, Map<String, String> userData, AccDeviceEventItem tempDevEvent) {
        AccDoorItem accDoor = this.accDoorService.getItemById(accTransactionItem.getEventPointId());
        JSONObject ret = new JSONObject();
        JSONArray audios = new JSONArray();
        String tmpAudioPath = "";
        if (accTransactionItem.getAudioFilePath() != null) {
            audios.add((Object)accTransactionItem.getAudioFilePath());
        }
        if (!(!Objects.nonNull(accDoor) || Objects.nonNull(accDoor.getIsDisableAudio()) && accDoor.getIsDisableAudio().booleanValue())) {
            tmpAudioPath = this.getAudioPath(tempDevEvent);
        } else if (Objects.isNull(accDoor)) {
            tmpAudioPath = this.getAudioPath(tempDevEvent);
        }
        if (StringUtils.isNotBlank((CharSequence)tmpAudioPath)) {
            audios.add((Object)tmpAudioPath);
        } else if (StringUtils.isBlank((CharSequence)tmpAudioPath) && StringUtils.isBlank((CharSequence)accTransactionItem.getAudioFilePath())) {
            audios.add(null);
        }
        ret.put("audios", (Object)audios);
        JSONArray rows = new JSONArray();
        JSONObject row = new JSONObject();
        row.put("id", (Object)accTransactionItem.getUniqueKey());
        JSONObject userdata = this.buildUserDate(accTransactionItem, userData);
        if (accTransactionItem.getVidDevices() != null && accTransactionItem.getVidDevices().size() > 0) {
            row.put("vidDescription", (Object)accTransactionItem.getDescription());
            row.put("vidDevices", (Object)accTransactionItem.getVidDevices());
        }
        row.put("userdata", (Object)userdata);
        row.put("style", (Object)(accTransactionItem.getEventLevel() == 0 ? "color:green" : (accTransactionItem.getEventLevel() == 1 ? "color:#E57A14" : "color:red")));
        JSONArray data = new JSONArray();
        data.add((Object)DateUtil.dateToString((Date)accTransactionItem.getEventTime(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS));
        data.add((Object)accTransactionItem.getAreaName());
        data.add((Object)(accTransactionItem.getDevAlias() != null ? accTransactionItem.getDevAlias() + "(" + accTransactionItem.getDevSn() + ")" : ""));
        data.add((Object)accTransactionItem.getEventPointName());
        data.add((Object)accTransactionItem.getEventName());
        data.add((Object)accTransactionItem.getCardNo());
        String name = "";
        if (StringUtils.isNotBlank((CharSequence)accTransactionItem.getName())) {
            name = accTransactionItem.getName().trim();
            if (!this.accRTMonitorService.checkIsChinaLanguage() && StringUtils.isNotBlank((CharSequence)accTransactionItem.getLastName())) {
                name = (accTransactionItem.getName() + " " + accTransactionItem.getLastName()).trim();
            }
            name = "(" + name + ")";
        }
        data.add((Object)(accTransactionItem.getPin() + name));
        data.add((Object)accTransactionItem.getReaderName());
        data.add((Object)accTransactionItem.getVerifyModeName());
        data.add((Object)(accTransactionItem.getDevAlias() != null ? accTransactionItem.getDevAlias() + "##" + accTransactionItem.getDevSn() + "##" + accTransactionItem.getEventPointName() + "##" + accTransactionItem.getEventPointType() : ""));
        data.add((Object)(Objects.nonNull(accDoor) ? accDoor.getId() : ""));
        data.add((Object)(Objects.nonNull(accDoor) ? accDoor.getEnabled() : true));
        data.add((Object)accTransactionItem.getPin());
        row.put("data", (Object)data);
        rows.add((Object)row);
        ret.put("rows", (Object)rows);
        this.messagingTemplate.convertAndSend((Object)"/topic/accRTMonitor/getEventData", (Object)ret);
        this.messagingTemplate.convertAndSend((Object)"/topic/accMapMonitor/getEventData", (Object)ret);
        this.messagingTemplate.convertAndSend((Object)"/topic/dashboardRTMonitor/getEventData", (Object)ret);
    }

    private String getAudioPath(AccDeviceEventItem accDeviceEvent) {
        String audioPath = "";
        if (Objects.nonNull(accDeviceEvent)) {
            audioPath = this.accRTMonitorService.getAudioPath(accDeviceEvent.getBaseMediaFileId());
        }
        return audioPath;
    }

    public void sendDeviceDoorState2RTMonitor(ZKResultMsg resultMsg) {
        int connect;
        int i;
        JSONObject data = new JSONObject();
        JSONArray stateArray = null;
        JSONArray doorStates = new JSONArray();
        JSONArray auxInStates = new JSONArray();
        JSONArray auxOutStates = new JSONArray();
        JSONObject dev = null;
        JSONObject devState = (JSONObject)resultMsg.getData();
        stateArray = devState.getJSONArray("doorState");
        if (Objects.nonNull(stateArray) && stateArray.size() > 0) {
            for (i = 0; i < stateArray.size(); ++i) {
                JSONObject door = stateArray.getJSONObject(i);
                dev = this.putDoorDataToMonitor(door);
                doorStates.add((Object)dev);
            }
            data.put("doorStates", (Object)doorStates);
        }
        this.messagingTemplate.convertAndSend((Object)"/topic/accMapMonitor/getDoorState", (Object)data);
        stateArray = devState.getJSONArray("auxInState");
        if (Objects.nonNull(stateArray) && stateArray.size() > 0) {
            for (i = 0; i < stateArray.size(); ++i) {
                JSONObject auxIn = stateArray.getJSONObject(i);
                connect = auxIn.getIntValue("connect");
                auxIn.put("image", (Object)AccEnumUtil.AuxInImage.getValue(connect));
                auxInStates.add((Object)auxIn);
            }
            data.put("auxInStates", (Object)auxInStates);
        }
        if (Objects.nonNull(stateArray = devState.getJSONArray("auxOutState")) && stateArray.size() > 0) {
            for (i = 0; i < stateArray.size(); ++i) {
                JSONObject auxOut = stateArray.getJSONObject(i);
                connect = auxOut.getIntValue("connect");
                auxOut.put("image", (Object)AccEnumUtil.AuxOutImage.getValue(connect));
                auxOutStates.add((Object)auxOut);
            }
            data.put("auxOutStates", (Object)auxOutStates);
        }
        this.messagingTemplate.convertAndSend((Object)"/topic/accRTMonitor/getDevState", (Object)data);
    }

    private JSONObject putDoorDataToMonitor(JSONObject door) {
        JSONObject data = new JSONObject();
        int sensor = door.getIntValue("sensor");
        int relay = door.getIntValue("relay");
        int alarm = door.getIntValue("alarm");
        int connect = door.getIntValue("connect");
        short alarmLevel = door.getShortValue("alarmLevel");
        int doorState = door.getIntValue("doorState");
        boolean isNewAccess = door.getBooleanValue("isNewAccess");
        String alarmValue = AccEnumUtil.Alarm.getValue(doorState, alarmLevel, alarm);
        data.put("id", (Object)door.getString("id"));
        data.put("areaId", (Object)door.getString("areaId"));
        data.put("devAlias", (Object)door.getString("devAlias"));
        data.put("devSn", (Object)door.getString("devSn"));
        data.put("no", (Object)door.getString("no"));
        data.put("name", (Object)door.getString("name"));
        data.put("connect", (Object)connect);
        data.put("sensor", (Object)(StringUtils.isNotBlank((CharSequence)AccEnumUtil.Sensor.getValue(doorState, sensor)) ? AccEnumUtil.Sensor.getValue(doorState, sensor) : ""));
        data.put("relay", (Object)(StringUtils.isNotBlank((CharSequence)AccEnumUtil.Relay.getValue(doorState, relay)) ? AccEnumUtil.Relay.getValue(doorState, relay) : ""));
        data.put("alarm", (Object)(StringUtils.isNotBlank((CharSequence)alarmValue) ? alarmValue : ""));
        if (isNewAccess) {
            alarmLevel = 0;
        }
        data.put("image", (Object)AccEnumUtil.DoorImage.getValue(doorState, connect, alarmLevel, alarm, relay, sensor));
        data.put("lockDisplay", (Object)door.getString("lockDisplay"));
        data.put("opDisplay", (Object)(doorState == 1 || doorState == 3 ? "inline" : "none"));
        data.put("iconFolderName", (Object)door.getString("iconFolderName"));
        if (connect == 0) {
            data.put("audio", (Object)"/public/media/sound/alarm.wav");
        } else if (alarm > 0 && !door.getBoolean("isDisableAudio").booleanValue()) {
            data.put("audio", (Object)"/public/media/sound/alarm.wav");
        }
        return data;
    }

    public void sendDeviceMonitor(AccDeviceMonitorItem accDeviceMonitorItem) {
        JSONObject dxGrid = new JSONObject();
        dxGrid.put("pos", (Object)0);
        ArrayList<JSONObject> rows = new ArrayList<JSONObject>();
        JSONObject row = new JSONObject();
        String status = this.accDeviceService.getStatus(accDeviceMonitorItem.getDevSn());
        row.put("id", (Object)accDeviceMonitorItem.getId());
        JSONObject userData = new JSONObject();
        userData.put("areaId", (Object)accDeviceMonitorItem.getAreaId());
        userData.put("status", (Object)accDeviceMonitorItem.getDevStatus());
        row.put("userdata", (Object)userData);
        if ("normal".equals(accDeviceMonitorItem.getDevStatus())) {
            row.put("style", (Object)"color:green");
        } else if ("disable".equals(accDeviceMonitorItem.getDevStatus())) {
            row.put("style", (Object)"color:#E57A14");
        } else {
            row.put("style", (Object)"color:red");
        }
        JSONArray data = new JSONArray();
        data.add((Object)accDeviceMonitorItem.getDevName());
        data.add((Object)accDeviceMonitorItem.getDevSn());
        data.add((Object)accDeviceMonitorItem.getAreaName());
        data.add((Object)accDeviceMonitorItem.getOpState());
        data.add((Object)accDeviceMonitorItem.getCurState());
        data.add((Object)accDeviceMonitorItem.getCmdCount());
        data.add((Object)(accDeviceMonitorItem.getLastError().equals("") ? I18nUtil.i18nCode((String)"common_none", (Object[])new Object[0]) : accDeviceMonitorItem.getLastError()));
        data.add((Object)"0,1");
        row.put("data", (Object)data);
        rows.add(row);
        dxGrid.put("rows", rows);
        dxGrid.put("total_count", (Object)rows.size());
        this.messagingTemplate.convertAndSend((Object)"/topic/accDeviceMonitor/getDeviceEvents", (Object)dxGrid);
    }

    public JSONObject buildUserDate(AccTransactionItem accTransactionItem, Map<String, String> userData) {
        JSONObject userdata = new JSONObject();
        String photoPath = "";
        boolean isExistPerson = StringUtils.isNotBlank((CharSequence)accTransactionItem.getPin());
        if (isExistPerson) {
            photoPath = this.accPersonService.getPersPersonPhotoPathByPin(accTransactionItem.getPin());
        }
        userdata.put("photoPath", (Object)(StringUtils.isNotBlank((CharSequence)photoPath) ? photoPath : userData.get("photoPath")));
        userdata.put("status", (Object)(accTransactionItem.getEventLevel() == 0 ? "normal" : (accTransactionItem.getEventLevel() == 1 ? "warning" : "alarm")));
        userdata.put("isExistCardOp", (Object)(accTransactionItem.getEventNo() == 27 && StringUtils.isNotBlank((CharSequence)accTransactionItem.getCardNo()) && !StringUtils.isNotBlank((CharSequence)userData.get("photoPath")) ? 1 : 0));
        userdata.put("eventNo", (Object)accTransactionItem.getEventNo());
        if (StringUtils.isNotBlank((CharSequence)accTransactionItem.getVidLinkageHandle()) && !accTransactionItem.getVidLinkageHandle().startsWith("/upload")) {
            JSONObject tranJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)accTransactionItem));
            userdata.put("globalLinkageEvent", (Object)tranJson);
        }
        return userdata;
    }

    public void sendDataToLcdRtMonitoring(AccTransactionItem accTransaction, String photoPath) {
        if (StringUtils.isNotBlank((CharSequence)accTransaction.getPin())) {
            JSONObject retJson = new JSONObject();
            String personName = accTransaction.getName();
            if (StringUtils.isNotBlank((CharSequence)accTransaction.getLastName()) && !LocaleMessageSourceUtil.language.equals("zh_CN")) {
                personName = personName + (StringUtils.isNotBlank((CharSequence)accTransaction.getName()) ? " " : "") + accTransaction.getLastName().trim();
            }
            retJson.put("personName", (Object)personName);
            retJson.put("eventPointName", (Object)accTransaction.getEventPointName());
            retJson.put("eventName", (Object)accTransaction.getEventName());
            retJson.put("status", (Object)(accTransaction.getEventLevel() == 0 ? "normal" : (accTransaction.getEventLevel() == 1 ? "warning" : "alarm")));
            retJson.put("eventTime", (Object)DateUtil.dateToString((Date)accTransaction.getEventTime(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS));
            retJson.put("pin", (Object)accTransaction.getPin());
            retJson.put("readerState", (Object)accTransaction.getReaderState());
            retJson.put("cardNo", (Object)accTransaction.getCardNo());
            retJson.put("PersDepartment", (Object)accTransaction.getDeptName());
            retJson.put("areaName", (Object)accTransaction.getAreaName());
            retJson.put("photoPath", (Object)(StringUtils.isNotBlank((CharSequence)photoPath) ? photoPath : ""));
            this.messagingTemplate.convertAndSend((Object)"/topic/accLcdRTMonitor/getLcdEvent", (Object)retJson.toString());
        }
    }
}

