/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.DateType;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="ATT_RECORD t ")
@OrderBy(after="t.PERS_PERSON_PIN,t.ATT_DATE ASC")
@GridConfig
public class AttWorkAbnormalReportItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID", equalTag="=")
    @GridColumn(show=false)
    private String id;
    @Column(name="t.PERS_PERSON_PIN")
    @GridColumn(label="pers_person_pin", width="110")
    private String personPin;
    @Column(name="t.PERS_PERSON_NAME")
    @GridColumn(label="pers_person_name", width="110")
    private String personName;
    @Column(name="t.PERS_PERSON_LAST_NAME")
    @GridColumn(label="pers_person_lastName", showExpression="#language!='zh_CN'", width="110")
    private String personLastName;
    @Column(name="t.AUTH_DEPT_ID")
    private String deptId;
    @Column(name="t.AUTH_DEPT_CODE")
    @GridColumn(label="pers_dept_deptNo", width="110", show=false)
    private String deptCode;
    @Column(name="t.AUTH_DEPT_NAME")
    @GridColumn(label="pers_dept_deptName", width="110")
    private String deptName;
    @Column(name="t.ATT_DATE")
    @DateType(type="date")
    @GridColumn(label="att_statistical_attDate", width="110")
    private Date attDate;
    @Column(name="t.WEEK")
    @GridColumn(label="att_statistical_week", format="0=common_abb_sunday,1=common_abb_monday,2=common_abb_tuesday,3=common_abb_wednesday,4=common_abb_thursday,5=common_abb_friday,6=common_abb_saturday", width="110", show=false)
    private String week;
    @Column(name="t.LATE_MINUTE_TOTAL")
    @GridColumn(label="att_statistical_lateMinute", width="110", show=false)
    private Integer lateMinuteTotal;
    @GridColumn(label="att_workAbnormalReport_lateTime", width="110")
    private String lateTime;
    @Column(name="t.EARLY_MINUTE_TOTAL")
    @GridColumn(label="att_statistical_earlyMinute", width="110", show=false)
    private Integer earlyMinuteTotal;
    @GridColumn(label="att_workAbnormalReport_earlyTime", width="110")
    private String earlyTime;
    @Column(name="t.ABSENT_MINUTE")
    private Integer absentMinute;
    @GridColumn(label="att_workAbnormalReport_absentTime", width="110")
    private String absentTime;
    @Condition(value="t.ATT_DATE", equalTag=">=")
    private Date startDatetimeBegin;
    @Condition(value="t.ATT_DATE", equalTag="<=")
    private Date startDatetimeEnd;
    @Condition(value="t.AUTH_DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="(lower(t.PERS_PERSON_NAME) LIKE ''%{0}%'' OR lower(t.PERS_PERSON_LAST_NAME) LIKE ''%{0}%'')")
    private String likeName;
    @Condition(value="(t.LATE_MINUTE_TOTAL > {0} OR T.EARLY_MINUTE_TOTAL > {0} OR t.ABSENT_MINUTE > {0})")
    private Integer abnormalMoreThanZero = 0;

    public AttWorkAbnormalReportItem setId(String id) {
        this.id = id;
        return this;
    }

    public AttWorkAbnormalReportItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public AttWorkAbnormalReportItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public AttWorkAbnormalReportItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public AttWorkAbnormalReportItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public AttWorkAbnormalReportItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public AttWorkAbnormalReportItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public AttWorkAbnormalReportItem setAttDate(Date attDate) {
        this.attDate = attDate;
        return this;
    }

    public AttWorkAbnormalReportItem setWeek(String week) {
        this.week = week;
        return this;
    }

    public AttWorkAbnormalReportItem setLateMinuteTotal(Integer lateMinuteTotal) {
        this.lateMinuteTotal = lateMinuteTotal;
        return this;
    }

    public AttWorkAbnormalReportItem setLateTime(String lateTime) {
        this.lateTime = lateTime;
        return this;
    }

    public AttWorkAbnormalReportItem setEarlyMinuteTotal(Integer earlyMinuteTotal) {
        this.earlyMinuteTotal = earlyMinuteTotal;
        return this;
    }

    public AttWorkAbnormalReportItem setEarlyTime(String earlyTime) {
        this.earlyTime = earlyTime;
        return this;
    }

    public AttWorkAbnormalReportItem setAbsentMinute(Integer absentMinute) {
        this.absentMinute = absentMinute;
        return this;
    }

    public AttWorkAbnormalReportItem setAbsentTime(String absentTime) {
        this.absentTime = absentTime;
        return this;
    }

    public AttWorkAbnormalReportItem setStartDatetimeBegin(Date startDatetimeBegin) {
        this.startDatetimeBegin = startDatetimeBegin;
        return this;
    }

    public AttWorkAbnormalReportItem setStartDatetimeEnd(Date startDatetimeEnd) {
        this.startDatetimeEnd = startDatetimeEnd;
        return this;
    }

    public AttWorkAbnormalReportItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public AttWorkAbnormalReportItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public AttWorkAbnormalReportItem setAbnormalMoreThanZero(Integer abnormalMoreThanZero) {
        this.abnormalMoreThanZero = abnormalMoreThanZero;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public Date getAttDate() {
        return this.attDate;
    }

    public String getWeek() {
        return this.week;
    }

    public Integer getLateMinuteTotal() {
        return this.lateMinuteTotal;
    }

    public String getLateTime() {
        return this.lateTime;
    }

    public Integer getEarlyMinuteTotal() {
        return this.earlyMinuteTotal;
    }

    public String getEarlyTime() {
        return this.earlyTime;
    }

    public Integer getAbsentMinute() {
        return this.absentMinute;
    }

    public String getAbsentTime() {
        return this.absentTime;
    }

    public Date getStartDatetimeBegin() {
        return this.startDatetimeBegin;
    }

    public Date getStartDatetimeEnd() {
        return this.startDatetimeEnd;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public Integer getAbnormalMoreThanZero() {
        return this.abnormalMoreThanZero;
    }
}

