/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="ATT_SIGN t LEFT JOIN ATT_PERSON p ON t.PERS_PERSON_ID=p.PERS_PERSON_ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600, operates={@GridOperate(type="del", permission="att:sign:del", url="attSign.do?del&pins=(personPin)", label="common_op_del", filter="attApplyShowDel")})
public class AttSignItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.PERS_PERSON_PIN", equalTag="=")
    @GridColumn(label="att_person_pin", width="120")
    private String personPin;
    @Column(name="p.PERS_PERSON_NAME")
    @GridColumn(label="att_person_name", width="120", sort="na")
    private String personName;
    @Column(name="p.PERS_PERSON_LASTNAME")
    @GridColumn(label="att_person_lastName", showExpression="#language!='zh_CN'", width="100")
    private String personLastName;
    @GridColumn(label="att_common_deptNo", width="150", sort="na")
    private String deptCode;
    @GridColumn(label="att_common_deptName", width="150", sort="na")
    private String deptName;
    @Column(name="t.SIGN_DATETIME")
    @GridColumn(label="att_sign_signTime", width="150")
    private Date signDatetime;
    @Column(name="t.REMARK")
    @GridColumn(label="common_remark", width="150")
    private String remark;
    @Column(name="t.CREATE_TIME")
    @GridColumn(label="att_common_operateTime", width="150")
    private Date operateDatetime;
    @Column(name="t.AUTH_DEPT_ID")
    private String deptId;
    @Column(name="t.PERS_PERSON_ID")
    private String personId;
    @Condition(value="t.SIGN_DATETIME", equalTag=">=")
    private Date startTime;
    @Condition(value="t.SIGN_DATETIME", equalTag="<=")
    private Date endTime;
    @Condition(value="t.AUTH_DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.PERS_PERSON_ID", equalTag="in")
    private String inPersonId;
    @Condition(value="t.PERS_PERSON_PIN", equalTag="in")
    private String inPersonPin;
    @Condition(value="(lower(p.PERS_PERSON_NAME) LIKE ''%{0}%'' OR lower(p.PERS_PERSON_LASTNAME) LIKE ''%{0}%'')")
    private String likeName;
    @Column(name="t.BUSINESS_KEY")
    private String businessKey;
    private String applyNo;
    private String applyType;
    @Column(name="t.FLOW_STATUS", equalTag="=")
    private String flowStatus;
    @Condition(value="t.FLOW_STATUS", equalTag="in")
    private String flowStatusIn;
    private String flowNo;
    @Column(name="t.BEFORE_SIGN_RECORD")
    private String beforeSignRecord;
    @Column(name="t.AFTER_SIGN_RECORD")
    private String afterSignRecord;
    private String notifierPerIds;
    @Condition(value="t.SIGN_DATETIME", equalTag=">=")
    private Date startSignTime;
    @Condition(value="t.SIGN_DATETIME", equalTag="<=")
    private Date endSignTime;
    @Column(name="t.CREATER_NAME")
    private String creatName;

    public AttSignItem() {
    }

    public AttSignItem(Boolean equals) {
        super(equals);
    }

    public AttSignItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public Date getSignDatetime() {
        return this.signDatetime;
    }

    public String getRemark() {
        return this.remark;
    }

    public Date getOperateDatetime() {
        return this.operateDatetime;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getPersonId() {
        return this.personId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getInPersonId() {
        return this.inPersonId;
    }

    public String getInPersonPin() {
        return this.inPersonPin;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getApplyNo() {
        return this.applyNo;
    }

    public String getApplyType() {
        return this.applyType;
    }

    public String getFlowStatus() {
        return this.flowStatus;
    }

    public String getFlowStatusIn() {
        return this.flowStatusIn;
    }

    public String getFlowNo() {
        return this.flowNo;
    }

    public String getBeforeSignRecord() {
        return this.beforeSignRecord;
    }

    public String getAfterSignRecord() {
        return this.afterSignRecord;
    }

    public String getNotifierPerIds() {
        return this.notifierPerIds;
    }

    public Date getStartSignTime() {
        return this.startSignTime;
    }

    public Date getEndSignTime() {
        return this.endSignTime;
    }

    public String getCreatName() {
        return this.creatName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPersonPin(String personPin) {
        this.personPin = personPin;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }

    public void setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
    }

    public void setDeptCode(String deptCode) {
        this.deptCode = deptCode;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public void setSignDatetime(Date signDatetime) {
        this.signDatetime = signDatetime;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setOperateDatetime(Date operateDatetime) {
        this.operateDatetime = operateDatetime;
    }

    public void setDeptId(String deptId) {
        this.deptId = deptId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
    }

    public void setInPersonId(String inPersonId) {
        this.inPersonId = inPersonId;
    }

    public void setInPersonPin(String inPersonPin) {
        this.inPersonPin = inPersonPin;
    }

    public void setLikeName(String likeName) {
        this.likeName = likeName;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public void setApplyNo(String applyNo) {
        this.applyNo = applyNo;
    }

    public void setApplyType(String applyType) {
        this.applyType = applyType;
    }

    public void setFlowStatus(String flowStatus) {
        this.flowStatus = flowStatus;
    }

    public void setFlowStatusIn(String flowStatusIn) {
        this.flowStatusIn = flowStatusIn;
    }

    public void setFlowNo(String flowNo) {
        this.flowNo = flowNo;
    }

    public void setBeforeSignRecord(String beforeSignRecord) {
        this.beforeSignRecord = beforeSignRecord;
    }

    public void setAfterSignRecord(String afterSignRecord) {
        this.afterSignRecord = afterSignRecord;
    }

    public void setNotifierPerIds(String notifierPerIds) {
        this.notifierPerIds = notifierPerIds;
    }

    public void setStartSignTime(Date startSignTime) {
        this.startSignTime = startSignTime;
    }

    public void setEndSignTime(Date endSignTime) {
        this.endSignTime = endSignTime;
    }

    public void setCreatName(String creatName) {
        this.creatName = creatName;
    }
}

