/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.utils;

import com.zkteco.zkbiosecurity.att.enums.AttRuleEnum;
import java.util.HashMap;
import java.util.Map;

public abstract class AttRuleUtils {
    public static final Map<String, String> exceptionRemarkMap = new HashMap<String, String>();

    public static String assignmentRemark(String exceptionSchType, Map<String, String> attRuleDataMap) {
        String remark = exceptionRemarkMap.get(exceptionSchType);
        String[] split = remark.split("-");
        if ("i18n".equals(split[0])) {
            return split[1];
        }
        return AttRuleUtils.defaultIfBlank(attRuleDataMap.get(split[1]), "");
    }

    public static String defaultIfBlank(String str, String defaultStr) {
        return AttRuleUtils.isBlank(str) ? defaultStr : str;
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static {
        exceptionRemarkMap.put(String.valueOf("-70"), "i18n-att_statistical_remarkHoliday");
        exceptionRemarkMap.put(String.valueOf("-60"), "i18n-att_statistical_remarkClass");
        exceptionRemarkMap.put(String.valueOf("-50"), "i18n-att_statistical_remarkClass");
        exceptionRemarkMap.put(String.valueOf("-40"), "i18n-att_statistical_remarkClass");
        exceptionRemarkMap.put(String.valueOf("-10"), "i18n-att_statistical_remarkNoSch");
        exceptionRemarkMap.put(String.valueOf("0"), "i18n-att_statistical_remarkRest");
        exceptionRemarkMap.put(String.valueOf("-30"), "rule-" + AttRuleEnum.Classes.getKey());
        exceptionRemarkMap.put(String.valueOf("-20"), "rule-" + AttRuleEnum.Off.getKey());
        exceptionRemarkMap.put(String.valueOf("10"), "rule-" + AttRuleEnum.Absent.getKey());
        exceptionRemarkMap.put(String.valueOf("20"), "rule-" + AttRuleEnum.Overtime.getKey());
        exceptionRemarkMap.put(String.valueOf("30"), "rule-" + AttRuleEnum.Out.getKey());
        exceptionRemarkMap.put(String.valueOf("40"), "rule-" + AttRuleEnum.Trip.getKey());
        exceptionRemarkMap.put(String.valueOf("50"), "rule-" + AttRuleEnum.Leave.getKey());
        exceptionRemarkMap.put(String.valueOf("70"), "rule-" + AttRuleEnum.NoSignOff.getKey());
        exceptionRemarkMap.put(String.valueOf("60"), "rule-" + AttRuleEnum.NoSignIn.getKey());
        exceptionRemarkMap.put(String.valueOf("90"), "rule-" + AttRuleEnum.Early.getKey());
        exceptionRemarkMap.put(String.valueOf("80"), "rule-" + AttRuleEnum.Late.getKey());
        exceptionRemarkMap.put(String.valueOf("100"), "rule-" + AttRuleEnum.Arrive.getKey());
        exceptionRemarkMap.put(String.valueOf("110"), "rule-" + AttRuleEnum.NoCheckInIncomplete.getKey());
        exceptionRemarkMap.put(String.valueOf("120"), "rule-" + AttRuleEnum.NoCheckOutIncomplete.getKey());
    }
}

