/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisTransactionRemote;
import com.zkteco.zkbiosecurity.vis.service.VisAttributeService;
import com.zkteco.zkbiosecurity.vis.service.VisParamsService;
import com.zkteco.zkbiosecurity.vis.service.VisTransactionService;
import com.zkteco.zkbiosecurity.vis.service.VisVisitorService;
import com.zkteco.zkbiosecurity.vis.vo.VisAttributeItem;
import com.zkteco.zkbiosecurity.vis.vo.VisTransactionItem;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisTransactionController
extends ExportController
implements VisTransactionRemote {
    @Autowired
    private VisTransactionService visTransactionService;
    @Autowired
    private VisParamsService visParamsService;
    @Autowired
    private VisAttributeService visAttributeService;
    @Autowired
    private VisVisitorService visVisitorService;

    @RequiresPermissions(value={"vis:transaction"})
    public ModelAndView index() {
        return new ModelAndView("vis/transaction/visTransaction");
    }

    @RequiresPermissions(value={"vis:transaction:refresh"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            VisTransactionItem item = this.visTransactionService.getItemById(id);
            this.request.setAttribute("item", (Object)item);
            Map valueMap = this.visVisitorService.getVisitorAttributeValues(item.getVisEmpId());
            this.request.setAttribute("map1", (Object)valueMap);
        }
        String supportDevice = this.visParamsService.getVisParamByName("vis.supportDevice");
        this.request.setAttribute("supportDevice", (Object)supportDevice);
        this.request.setAttribute("showSignature", (Object)this.visTransactionService.isShowSignature());
        List attributes = this.visAttributeService.getByCondition(new VisAttributeItem());
        this.getAttribute(attributes);
        return new ModelAndView("vis/transaction/editVisTransaction");
    }

    private void getAttribute(List<VisAttributeItem> attributeItems) {
        ArrayList rows = new ArrayList();
        ArrayList<Integer> rowInts = new ArrayList<Integer>();
        HashMap<String, ArrayList<Integer>> maxTds = new HashMap<String, ArrayList<Integer>>();
        HashMap<String, VisAttributeItem> attrs = new HashMap<String, VisAttributeItem>();
        for (VisAttributeItem attributeItem : attributeItems) {
            ArrayList<Integer> colList;
            Integer row = attributeItem.getPositionX();
            Integer col = attributeItem.getPositionY();
            if (!rowInts.contains(row)) {
                rowInts.add(row);
            }
            if ((colList = (ArrayList<Integer>)maxTds.get("" + row)) == null) {
                colList = new ArrayList<Integer>();
            }
            colList.add(col);
            Collections.sort(colList);
            maxTds.put("" + row, colList);
            attrs.put("" + row + col, attributeItem);
        }
        Collections.sort(rowInts);
        CollectionUtils.collect(rowInts, (Transformer)new Transformer(){

            public Object transform(Object o) {
                return o.toString();
            }
        }, rows);
        this.request.setAttribute("attrs", attrs);
        this.request.setAttribute("tds", maxTds);
        this.request.setAttribute("trs", rows);
    }

    @RequiresPermissions(value={"vis:transaction:edit"})
    public ZKResultMsg save(VisTransactionItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.visTransactionService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"vis:transaction:refresh"})
    public DxGrid list(VisTransactionItem condition) {
        Pager pager = this.visTransactionService.getItemsAndAttrByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:transaction:del"})
    @LogRequest(module="vis_module", object="vis_leftMenu_record", opType="common_op_del", requestParams={"visEmpPins", "visitedEmpPins"}, opContent="vis_emp_pin")
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        this.visTransactionService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"vis:transaction:export"})
    @LogRequest(module="vis_module", object="vis_leftMenu_record", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        VisTransactionItem visTransactionItem = new VisTransactionItem();
        this.setConditionValue((BaseItem)visTransactionItem);
        List itemList = this.visTransactionService.getItemData(VisTransactionItem.class, (BaseItem)visTransactionItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, VisTransactionItem.class);
    }

    public void sendMail() {
        List visTransactionItemList = this.visTransactionService.getTodayTransaction();
        StringBuffer visInfoBuffer = new StringBuffer();
        visInfoBuffer.append("<style>.sendMailTable{border-top:1px solid #999;border-left:1px solid #999}.sendMailTable th{background:#EEE;min-width:100px;}.sendMailTable th,td{border-bottom:1px solid #999;border-right:1px solid #999;padding:0px 5px}</style>");
        if (LocaleMessageSourceUtil.language.equals("zh_CN")) {
            visInfoBuffer.append("<table class='sendMailTable' border='0' cellspacing='0' cellpadding='0' ><th>" + I18nUtil.i18nCode((String)"vis_emp_pin", (Object[])new Object[0]) + "</th><th>" + I18nUtil.i18nCode((String)"vis_cert_type", (Object[])new Object[0]) + "</th><th>" + I18nUtil.i18nCode((String)"vis_cert_number", (Object[])new Object[0]) + "</th><th>" + I18nUtil.i18nCode((String)"vis_common_name", (Object[])new Object[0]) + "</th><th>" + I18nUtil.i18nCode((String)"vis_record_visitedName", (Object[])new Object[0]) + "</th><th>" + I18nUtil.i18nCode((String)"vis_leftMenu_reason", (Object[])new Object[0]) + "</th><th>" + I18nUtil.i18nCode((String)"vis_emp_status", (Object[])new Object[0]) + "</th><th>" + I18nUtil.i18nCode((String)"vis_emp_enterTime", (Object[])new Object[0]) + "</th><th>" + I18nUtil.i18nCode((String)"vis_emp_entrance", (Object[])new Object[0]) + "</th><th>" + I18nUtil.i18nCode((String)"vis_emp_exitTime", (Object[])new Object[0]) + "</th><th>" + I18nUtil.i18nCode((String)"vis_emp_exitPlace", (Object[])new Object[0]) + "</th><th>" + I18nUtil.i18nCode((String)"vis_common_carriedGoodsIn", (Object[])new Object[0]) + "</th>");
        } else {
            visInfoBuffer.append("<table class='sendMailTable' border='0' cellspacing='0' cellpadding='0' ><th>" + I18nUtil.i18nCode((String)"vis_emp_pin", (Object[])new Object[0]) + "</th><th>" + I18nUtil.i18nCode((String)"vis_cert_type", (Object[])new Object[0]) + "</th><th>" + I18nUtil.i18nCode((String)"vis_cert_number", (Object[])new Object[0]) + "</th><th>" + I18nUtil.i18nCode((String)"vis_common_name", (Object[])new Object[0]) + "</th><th>" + I18nUtil.i18nCode((String)"vis_export_lastname", (Object[])new Object[0]) + "</th><th>" + I18nUtil.i18nCode((String)"vis_record_visitedName", (Object[])new Object[0]) + "</th><th>" + I18nUtil.i18nCode((String)"vis_record_visitedLastName", (Object[])new Object[0]) + "</th><th>" + I18nUtil.i18nCode((String)"vis_leftMenu_reason", (Object[])new Object[0]) + "</th><th>" + I18nUtil.i18nCode((String)"vis_emp_status", (Object[])new Object[0]) + "</th><th>" + I18nUtil.i18nCode((String)"vis_emp_enterTime", (Object[])new Object[0]) + "</th><th>" + I18nUtil.i18nCode((String)"vis_emp_entrance", (Object[])new Object[0]) + "</th><th>" + I18nUtil.i18nCode((String)"vis_emp_exitTime", (Object[])new Object[0]) + "</th><th>" + I18nUtil.i18nCode((String)"vis_emp_exitPlace", (Object[])new Object[0]) + "</th><th>" + I18nUtil.i18nCode((String)"vis_common_carriedGoodsIn", (Object[])new Object[0]) + "</th>");
        }
        for (VisTransactionItem visTransactionItem : visTransactionItemList) {
            String visitedEmpLastName;
            String visEmpPin = visTransactionItem.getVisEmpPin() != null ? visTransactionItem.getVisEmpPin() : "";
            String visEmpCertNumber = visTransactionItem.getVisEmpCertNumber() != null ? visTransactionItem.getVisEmpCertNumber() : "";
            String certCode = visTransactionItem.getVisEmpCertType();
            String visEmpCertType = certCode != null ? this.visTransactionService.getCertNameByCertCode(certCode) : "";
            String visEmpName = visTransactionItem.getVisEmpName() != null ? visTransactionItem.getVisEmpName() : "";
            String visietdEmpName = visTransactionItem.getVisitedEmpName() != null ? visTransactionItem.getVisitedEmpName() : "";
            String visitReason = visTransactionItem.getVisitReason() != null ? visTransactionItem.getVisitReason() : "";
            String visitState = "";
            visitState = visTransactionItem.getVisitState() == 0 ? I18nUtil.i18nCode((String)"vis_record_stateIn", (Object[])new Object[0]) : (visTransactionItem.getVisitState() == 1 ? I18nUtil.i18nCode((String)"vis_record_stateOut", (Object[])new Object[0]) : I18nUtil.i18nCode((String)"vis_record_stateError", (Object[])new Object[0]));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String enterTime = visTransactionItem.getEnterTime() != null ? sdf.format(visTransactionItem.getEnterTime()) : "";
            String enterPlace = visTransactionItem.getEnterPlace() != null ? visTransactionItem.getEnterPlace() : "";
            String exitTime = visTransactionItem.getExitTime() != null ? sdf.format(visTransactionItem.getExitTime()) : "";
            String exitPlace = visTransactionItem.getExitPlace() != null ? visTransactionItem.getExitPlace() : "";
            String carriedGoodsIn = visTransactionItem.getCarriedGoodsIn() != null ? visTransactionItem.getCarriedGoodsIn() : "";
            String visEmpLastName = visTransactionItem.getVisEmpLastName() != null ? visTransactionItem.getVisEmpLastName() : "";
            String string = visitedEmpLastName = visTransactionItem.getVisitedEmpLastName() != null ? visTransactionItem.getVisitedEmpLastName() : "";
            if (LocaleMessageSourceUtil.language.equals("zh_CN")) {
                visInfoBuffer.append("<tr><td>" + visEmpPin + "</td><td>" + visEmpCertType + "</td><td>" + visEmpCertNumber + "</td><td>" + visEmpName + "</td><td>" + visietdEmpName + "</td><td>" + visitReason + "</td><td>" + visitState + "</td><td>" + enterTime + "</td><td>" + enterPlace + "</td><td>" + exitTime + "</td><td>" + exitPlace + "</td><td>" + carriedGoodsIn + "</td></tr>");
                continue;
            }
            visInfoBuffer.append("<tr><td>" + visEmpPin + "</td><td>" + visEmpCertType + "</td><td>" + visEmpCertNumber + "</td><td>" + visEmpName + "</td><td>" + visEmpLastName + "</td><td>" + visietdEmpName + "</td><td>" + visitedEmpLastName + "</td><td>" + visitReason + "</td><td>" + visitState + "</td><td>" + enterTime + "</td><td>" + enterPlace + "</td><td>" + exitTime + "</td><td>" + exitPlace + "</td><td>" + carriedGoodsIn + "</td></tr>");
        }
        visInfoBuffer.append("</table>");
        String receiver = this.visTransactionService.getVisReceiver();
        if (StringUtils.isNotBlank((CharSequence)receiver) && visTransactionItemList.size() > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            for (String tempReceiver : receiver.split(",")) {
                String visInfoStr = I18nUtil.i18nCode((String)"vis_email_call", (Object[])new Object[0]) + tempReceiver.substring(0, tempReceiver.indexOf("@")) + "<p>" + I18nUtil.i18nCode((String)"vis_email_text", (Object[])new Object[0]) + "</p>" + visInfoBuffer.toString() + "<br/>" + I18nUtil.i18nCode((String)"vis_email_ending", (Object[])new Object[0]) + "<br/><p>" + sdf.format(new Date()) + "</p>";
                this.visTransactionService.sendSampleHtmlMail(tempReceiver, I18nUtil.i18nCode((String)"vis_common_visitorList", (Object[])new Object[0]), visInfoStr);
            }
        }
    }
}

