/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.vis.remote.VisRegistrationRemote;
import com.zkteco.zkbiosecurity.vis.service.VisLevelService;
import com.zkteco.zkbiosecurity.vis.service.VisParamsService;
import com.zkteco.zkbiosecurity.vis.service.VisPlaceService;
import com.zkteco.zkbiosecurity.vis.service.VisPubService;
import com.zkteco.zkbiosecurity.vis.service.VisTransactionService;
import com.zkteco.zkbiosecurity.vis.service.VisVisitedPersonService;
import com.zkteco.zkbiosecurity.vis.vo.VisPlaceItem;
import com.zkteco.zkbiosecurity.vis.vo.VisRegistrationItem;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class VisRegistrationController
extends BaseController
implements VisRegistrationRemote {
    @Autowired
    private VisTransactionService visTransactionService;
    @Autowired
    private VisLevelService visLevelService;
    @Autowired
    private VisPubService visPubService;
    @Autowired
    private VisPlaceService visPlaceService;
    @Autowired
    private VisParamsService visParamsService;
    @Autowired
    private VisVisitedPersonService visVisitedPersonService;

    public ZKResultMsg getEmpByNameOrPhoneOrDept(@RequestParam(value="condition") String condition) {
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            return this.visVisitedPersonService.getEmpByNameOrPhoneOrDept(condition);
        }
        return new ZKResultMsg();
    }

    public ZKResultMsg save(VisRegistrationItem item) {
        String bioTemplateJson = this.request.getParameter("bioTemplateJson");
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put("bioTemplateJson", bioTemplateJson);
        List visLevelIds = this.visLevelService.getVisDefaultLevel(item.getVisitedEmpDeptId(), item.getVisitedEmpId(), item.getEnterPlace());
        String levelIds = StringUtils.join((Iterable)visLevelIds, (String)",");
        item.setLevelIds(levelIds);
        if (StringUtils.isNotBlank((CharSequence)item.getHeadPortrait())) {
            item.setHeadPortrait(item.getHeadPortrait().replaceAll("[\\s*\t\n\r]", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)item.getEnterPhoto())) {
            item.setEnterPhoto(item.getEnterPhoto().replaceAll("[\\s*\t\n\r]", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)item.getCertPhoto())) {
            item.setCertPhoto(item.getCertPhoto().replaceAll("[\\s*\t\n\r]", ""));
        }
        item.setCreaterName(item.getCreaterCode());
        Map retMap = this.visTransactionService.saveVisRegistrationItem(item, attrMap);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)retMap));
    }

    public Pager list(VisRegistrationItem condition) {
        String visitStateStr = this.request.getParameter("visVisitState");
        String factor = this.request.getParameter("factor");
        String posStart = this.request.getParameter("posStart");
        int pageNo = posStart == null ? 0 : Integer.parseInt(posStart);
        Pager pager = new Pager();
        if ("0".equals(visitStateStr)) {
            condition.setFilterBeginEnterTime(DateUtil.getTodayBeginTime());
            condition.setFilterVisitState(Short.valueOf((short)1));
        } else if ("1".equals(visitStateStr)) {
            condition.setFilterBeginEnterTime(DateUtil.getTodayBeginTime());
        } else if ("2".equals(visitStateStr)) {
            condition.setFilterBeginEnterTime(DateUtil.getTodayBeginTime());
            condition.setVisitState(Short.valueOf((short)1));
        }
        pager = StringUtils.isNotBlank((CharSequence)factor) ? this.visTransactionService.getItemsByPageAndFactor((BaseItem)condition, pageNo, this.getPageSize(), factor) : this.visTransactionService.getItemsByPage((BaseItem)condition, pageNo, this.getPageSize());
        return pager;
    }

    public ZKResultMsg getRegistrationItemById(@RequestParam(value="id") String id) {
        ZKResultMsg res = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            VisRegistrationItem item = this.visTransactionService.getRegistrationItemById(id);
            item.setCertTypeName(this.visTransactionService.getCertNameByCertCode(item.getVisEmpCertType()));
            res.setData((Object)item);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public void getTodayCount() {
        try {
            this.response.setContentType("text/event-stream");
            this.response.setCharacterEncoding("UTF-8");
            PrintWriter writer = this.response.getWriter();
            String clientId = this.request.getParameter("clientId");
            this.visPubService.pubVisitorCountTouch(clientId, writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ZKResultMsg getCurrentPlace() {
        ZKResultMsg msg = new ZKResultMsg();
        String cpuData = this.request.getParameter("cpuData");
        String macData = this.request.getParameter("macData");
        VisPlaceItem visPlaceItem = null;
        if (StringUtils.isNotBlank((CharSequence)macData)) {
            String[] macDatas;
            for (String mac : macDatas = macData.split(",")) {
                visPlaceItem = this.visPlaceService.getItemByPhysicalKey(cpuData + mac);
                if (visPlaceItem == null) continue;
                msg.setData((Object)visPlaceItem);
                break;
            }
        }
        if (visPlaceItem == null) {
            msg.setRet("500");
            msg.setMsg(I18nUtil.i18nCode((String)"vis_place_currentNotRegistration", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)msg);
    }

    public ZKResultMsg getCurrentPlaceTouch() {
        ZKResultMsg msg = new ZKResultMsg();
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        String cpuData = this.request.getParameter("cpuData");
        String macData = this.request.getParameter("macData");
        VisPlaceItem visPlaceItem = null;
        if (StringUtils.isNotBlank((CharSequence)macData)) {
            String[] macDatas;
            for (String mac : macDatas = macData.split(",")) {
                visPlaceItem = this.visPlaceService.getItemByPhysicalKey(cpuData + mac);
                if (visPlaceItem == null) continue;
                retMap.put("visPlace", visPlaceItem);
                break;
            }
        }
        if (visPlaceItem == null) {
            msg.setRet("500");
            msg.setMsg(I18nUtil.i18nCode((String)"vis_place_currentNotRegistration", (Object[])new Object[0]));
        } else {
            Map licenseMap = this.visTransactionService.checkTransactionLicense();
            if (!((String)licenseMap.get("licenseState")).equals("success")) {
                if (((String)licenseMap.get("license")).equals("vis_message_maxLicenseCount")) {
                    licenseMap.put("license", I18nUtil.i18nCode((String)((String)licenseMap.get("license")), (Object[])new Object[]{licenseMap.get("errorCount"), licenseMap.get("deviceCount")}));
                } else if (((String)licenseMap.get("license")).equals("vis_message_maxCount")) {
                    licenseMap.put("license", I18nUtil.i18nCode((String)((String)licenseMap.get("license")), (Object[])new Object[]{licenseMap.get("warningCount"), licenseMap.get("deviceCount")}));
                } else {
                    String licenseMsg = I18nUtil.i18nCode((String)((String)licenseMap.get("license")), (Object[])new Object[0]);
                    licenseMap.put("license", licenseMsg);
                }
            }
            for (Map.Entry entry : licenseMap.entrySet()) {
                retMap.put((String)entry.getKey(), entry.getValue());
            }
            Map visMap = this.visParamsService.getVisParams();
            retMap.put("params", visMap);
            msg.setData(retMap);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)msg);
    }

    public ZKResultMsg getScanCode() {
        String serialNo = this.visTransactionService.getUniqCardNo();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)serialNo));
    }

    public ZKResultMsg exit(VisRegistrationItem item) {
        ZKResultMsg res = new ZKResultMsg();
        Map attrMap = null;
        item.setUpdaterName(item.getUpdaterCode());
        if (StringUtils.isNotBlank((CharSequence)item.getExitPhoto())) {
            item.setExitPhoto(item.getExitPhoto().replaceAll("[\\s*\t\n\r]", ""));
        }
        this.visTransactionService.applyVisitorExit(item, attrMap);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }
}

