/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.api.controller;

import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.vis.api.vo.VisApiRegisterItem;
import com.zkteco.zkbiosecurity.vis.service.VisPlaceService;
import com.zkteco.zkbiosecurity.vis.service.VisTransactionService;
import com.zkteco.zkbiosecurity.vis.vo.VisPlaceItem;
import com.zkteco.zkbiosecurity.vis.vo.VisRegistrationItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/visRegistration"})
@Api(tags={"VisRegistration"}, description="visitor registration")
public class VisApiRegistrationController {
    private static final Logger log = LoggerFactory.getLogger(VisApiRegistrationController.class);
    @Autowired
    private VisTransactionService visTransactionService;
    @Autowired
    private VisPlaceService visPlaceService;

    @ResponseBody
    @RequestMapping(value={"/add"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Add Visitor", notes="Add Visitor", response=ApiResultMessage.class)
    public ApiResultMessage add(@RequestBody VisApiRegisterItem apiVisRegisterItem) {
        ApiResultMessage rs = null;
        try {
            if (StringUtils.isBlank((CharSequence)apiVisRegisterItem.getPersPersonPin())) {
                return ApiResultMessage.message((int)-240, (String)I18nUtil.i18nCode((String)"vis_api_persPersonPinNotNull", (Object[])new Object[0]));
            }
            if (apiVisRegisterItem.getCertType() == null) {
                return ApiResultMessage.message((int)-241, (String)I18nUtil.i18nCode((String)"vis_api_certTypeNotNull", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)apiVisRegisterItem.getCertNum())) {
                return ApiResultMessage.message((int)-242, (String)I18nUtil.i18nCode((String)"vis_api_certNumNotNull", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)apiVisRegisterItem.getVisEmpName())) {
                return ApiResultMessage.message((int)-243, (String)I18nUtil.i18nCode((String)"vis_api_visitEmpNameNotNull", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)apiVisRegisterItem.getVisitReason())) {
                return ApiResultMessage.message((int)-246, (String)I18nUtil.i18nCode((String)"vis_api_visitReasonNotNull", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)apiVisRegisterItem.getStartTime()) || StringUtils.isBlank((CharSequence)apiVisRegisterItem.getEndTime())) {
                return ApiResultMessage.message((int)-247, (String)I18nUtil.i18nCode((String)"vis_api_visitDateNotNull", (Object[])new Object[0]));
            }
            if (apiVisRegisterItem.getVisitorCount() == null || apiVisRegisterItem.getVisitorCount() <= 0) {
                return ApiResultMessage.message((int)-258, (String)I18nUtil.i18nCode((String)"vis_api_wrongVisitorCount", (Object[])new Object[0]));
            }
            rs = this.visTransactionService.saveApiVisRegister(apiVisRegisterItem);
        }
        catch (Exception e) {
            log.error("api visRegistration/add error ", (Throwable)e);
            rs = ApiResultMessage.failedMessage((int)-1);
        }
        return rs;
    }

    @ResponseBody
    @RequestMapping(value={"/exit"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Exit Visitor", notes="Exit Visitor", response=ApiResultMessage.class)
    public ApiResultMessage exit(@RequestParam String certType, @RequestParam String certNum) {
        ApiResultMessage rs = ApiResultMessage.successMessage();
        try {
            if (StringUtils.isBlank((CharSequence)certType)) {
                return ApiResultMessage.message((int)-241, (String)I18nUtil.i18nCode((String)"vis_api_certTypeNotNull", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)certNum)) {
                return ApiResultMessage.message((int)-242, (String)I18nUtil.i18nCode((String)"vis_api_certNumNotNull", (Object[])new Object[0]));
            }
            VisRegistrationItem visRegistrationItem = new VisRegistrationItem();
            visRegistrationItem.setVisEmpCertType(certType);
            visRegistrationItem.setVisEmpCertNumber(certNum);
            visRegistrationItem.setVisitState(Short.valueOf((short)0));
            List visRegistrationItems = this.visTransactionService.getRegistrationItemByCondition(visRegistrationItem);
            if (visRegistrationItems == null || visRegistrationItems.isEmpty()) {
                return ApiResultMessage.message((int)-256, (String)I18nUtil.i18nCode((String)"vis_api_visitIsNotRegistr", (Object[])new Object[0]));
            }
            visRegistrationItem = (VisRegistrationItem)visRegistrationItems.get(0);
            if (StringUtils.isBlank((CharSequence)visRegistrationItem.getExitPlace())) {
                VisPlaceItem visPlaceItem = new VisPlaceItem();
                visPlaceItem.setInitFlag(Boolean.valueOf(true));
                visPlaceItem = (VisPlaceItem)this.visPlaceService.getByCondition(visPlaceItem).get(0);
                visRegistrationItem.setExitPlace(visPlaceItem.getId());
            }
            this.visTransactionService.applyVisitorExit(visRegistrationItem, new HashMap());
        }
        catch (Exception e) {
            log.error("api visRegistration/exit error ", (Throwable)e);
            rs = ApiResultMessage.failedMessage((int)-1);
        }
        return rs;
    }
}

