/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.init;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.auth.provider.AuthInitDataProvider;
import com.zkteco.zkbiosecurity.auth.vo.AuthAreaItem;
import com.zkteco.zkbiosecurity.auth.vo.AuthDepartmentItem;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.auth.vo.AuthUserItem;
import com.zkteco.zkbiosecurity.base.utils.VersionUtil;
import com.zkteco.zkbiosecurity.core.config.MessageSourceAutoConfiguration;
import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.core.utils.MD5Util;
import com.zkteco.zkbiosecurity.system.constants.BaseDataConstants;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryService;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryValueService;
import com.zkteco.zkbiosecurity.system.service.BaseLanguageResourceService;
import com.zkteco.zkbiosecurity.system.service.BaseLanguageService;
import com.zkteco.zkbiosecurity.system.service.BaseMailService;
import com.zkteco.zkbiosecurity.system.service.BaseMediaFileService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.service.SystemSecurityParamsService;
import com.zkteco.zkbiosecurity.system.vo.BaseDictionaryItem;
import com.zkteco.zkbiosecurity.system.vo.BaseDictionaryValueItem;
import com.zkteco.zkbiosecurity.system.vo.BaseLanguageItem;
import com.zkteco.zkbiosecurity.system.vo.BaseLanguageResourceItem;
import com.zkteco.zkbiosecurity.system.vo.BaseMediaFileItem;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
@Order(value=10)
public class SystemInit
implements CommandLineRunner {
    @Autowired
    private AuthInitDataProvider authInitDataProvider;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private BaseDictionaryService baseDictionaryService;
    @Autowired
    private BaseLanguageService baseLanguageService;
    @Autowired
    private BaseLanguageResourceService baseLanguageResourceService;
    @Autowired
    private BaseDictionaryValueService baseDictionaryValueService;
    @Autowired
    private BaseMediaFileService baseMediaFileService;
    @Autowired
    private BaseMailService baseMailService;
    @Autowired
    private SystemSecurityParamsService systemSecurityParamsService;
    @Value(value="${system.filePath:BioSecurityFile}")
    private String systemFilePath;
    @Value(value="${system.isCloud:false}")
    private Boolean isCloud;
    @Value(value="${system.devMode:false}")
    private Boolean isDev;
    @Value(value="${system.productCode:ZKBioSecurity}")
    private String productCode;
    @Value(value="${system.language:zh_CN}")
    private String language;

    public void run(String ... args) throws Exception {
        this.initFilePath();
        this.initMail();
        this.initFPServerData();
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("SystemInit");
        if (!alreadyInit) {
            this.initAuthUser();
            if (!this.isCloud.booleanValue()) {
                this.initAuthArea();
                this.initAuthDepartment();
            }
            this.initAuthPermission();
            this.initSysParam();
            this.initBaseDictionary();
            this.initBaseMediaFile();
            if (!("zh_CN".equals(this.language) || this.isCloud.booleanValue() || "ZKBioAccess".equals(this.productCode))) {
                this.initAppMenus();
            }
            if (this.isDev.booleanValue()) {
                this.initBaseLanguage();
            }
            this.initLisenseView();
            this.initUpgradeVersion();
            this.baseSysParamService.setAlreadyInitModule("SystemInit");
        }
    }

    void initLisenseView() {
        if (!"zh_CN".equals(this.language)) {
            BaseSysParamItem item1 = new BaseSysParamItem("app.version", "true", "APP License", Boolean.valueOf(true));
            this.baseSysParamService.initData(item1);
        }
        BaseSysParamItem item2 = new BaseSysParamItem("ocr.version", "true", "OCR License", Boolean.valueOf(true));
        this.baseSysParamService.initData(item2);
        BaseSysParamItem item3 = new BaseSysParamItem("persidreader.version", "true", "Persidreader License", Boolean.valueOf(true));
        this.baseSysParamService.initData(item3);
        BaseSysParamItem item4 = new BaseSysParamItem("printcard.version", "true", "Printcard License", Boolean.valueOf(true));
        this.baseSysParamService.initData(item4);
        BaseSysParamItem item5 = new BaseSysParamItem("systempers.version", "true", "Systempers License", Boolean.valueOf(true));
        this.baseSysParamService.initData(item5);
        BaseSysParamItem item6 = new BaseSysParamItem("systemdepartment.version", "true", "Systemdepartment License", Boolean.valueOf(true));
        this.baseSysParamService.initData(item6);
        BaseSysParamItem item7 = new BaseSysParamItem("systemarea.version", "true", "Systemarea License", Boolean.valueOf(true));
        this.baseSysParamService.initData(item7);
        BaseSysParamItem item8 = new BaseSysParamItem("cardcontrol.version", "true", "Cardcontrol License", Boolean.valueOf(true));
        this.baseSysParamService.initData(item8);
        BaseSysParamItem item9 = new BaseSysParamItem("api.version", "true", "API", Boolean.valueOf(true));
        this.baseSysParamService.initData(item9);
    }

    private void initFilePath() {
        File dir = new File(this.systemFilePath);
        if (!dir.exists()) {
            dir.mkdir();
        }
    }

    private void initMail() {
        this.baseMailService.initMethod();
    }

    private void initAuthUser() {
        AuthUserItem authUserItem = new AuthUserItem("admin", MD5Util.entype((String)"admin"), "admin");
        authUserItem.setPwdCreateTime(new Date());
        authUserItem.setPwdInitFlag("0");
        authUserItem.setIsActive(Boolean.valueOf(true));
        authUserItem.setIsSuperuser(Boolean.valueOf(true));
        authUserItem.setInitFlag(Boolean.valueOf(true));
        this.authInitDataProvider.initUserData(authUserItem);
    }

    public void initAuthDepartment() {
        AuthDepartmentItem department1 = new AuthDepartmentItem("1", I18nUtil.i18nCode((String)"auth_dept_initDept", (Object[])new Object[0]), Integer.valueOf(1));
        department1.setInitCode("1");
        department1 = this.authInitDataProvider.initDepartmentData(department1);
    }

    public void initAuthArea() {
        AuthAreaItem item = new AuthAreaItem("1", I18nUtil.i18nCode((String)"base_area_name", (Object[])new Object[0]), I18nUtil.i18nCode((String)"common_default", (Object[])new Object[0]), Boolean.valueOf(true));
        this.authInitDataProvider.initAreaData(item);
    }

    private void initBaseDictionary() {
        BaseDictionaryItem baseDictionaryItem = new BaseDictionaryItem("sex", I18nUtil.i18nCode((String)"common_gender", (Object[])new Object[0]), Boolean.valueOf(false), I18nUtil.i18nCode((String)"system_module", (Object[])new Object[0]));
        baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("M", "common_male", Integer.valueOf(1), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("F", "common_female", Integer.valueOf(2), baseDictionaryItem.getId()));
        baseDictionaryItem = new BaseDictionaryItem("zeroOrOne", I18nUtil.i18nCode((String)"base_opLog_opResult", (Object[])new Object[0]), Boolean.valueOf(false), I18nUtil.i18nCode((String)"system_module", (Object[])new Object[0]));
        baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("0", I18nUtil.i18nCode((String)"common_failed", (Object[])new Object[0]), Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("1", I18nUtil.i18nCode((String)"common_succeed", (Object[])new Object[0]), Integer.valueOf(1), baseDictionaryItem.getId()));
        baseDictionaryItem = new BaseDictionaryItem("trueOrFalse", "Boolean", Boolean.valueOf(false), I18nUtil.i18nCode((String)"system_module", (Object[])new Object[0]));
        baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("true", I18nUtil.i18nCode((String)"common_yes", (Object[])new Object[0]), Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("false", I18nUtil.i18nCode((String)"common_no", (Object[])new Object[0]), Integer.valueOf(1), baseDictionaryItem.getId()));
        baseDictionaryItem = new BaseDictionaryItem("certificateType", I18nUtil.i18nCode((String)"system_cert_type", (Object[])new Object[0]), Boolean.valueOf(false), I18nUtil.i18nCode((String)"system_module", (Object[])new Object[0]));
        baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
        if ("zh_CN".equals(this.language)) {
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("2", I18nUtil.i18nCode((String)"base_cert_secondId", (Object[])new Object[0]), Integer.valueOf(1), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("5", I18nUtil.i18nCode((String)"base_cert_work", (Object[])new Object[0]), Integer.valueOf(4), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("6", I18nUtil.i18nCode((String)"base_cert_cityCard", (Object[])new Object[0]), Integer.valueOf(5), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("7", I18nUtil.i18nCode((String)"base_cert_driving_license", (Object[])new Object[0]), Integer.valueOf(6), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("1000", I18nUtil.i18nCode((String)"base_cert_xm_social_security", (Object[])new Object[0]), Integer.valueOf(7), baseDictionaryItem.getId()));
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("1001", I18nUtil.i18nCode((String)"base_cert_hkAndMacau_pass", (Object[])new Object[0]), Integer.valueOf(8), baseDictionaryItem.getId()));
        } else {
            this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("1", I18nUtil.i18nCode((String)"base_cert_id", (Object[])new Object[0]), Integer.valueOf(1), baseDictionaryItem.getId()));
        }
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("3", I18nUtil.i18nCode((String)"base_cert_permit", (Object[])new Object[0]), Integer.valueOf(2), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("4", I18nUtil.i18nCode((String)"base_cert_drive", (Object[])new Object[0]), Integer.valueOf(3), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("8", I18nUtil.i18nCode((String)"common_other", (Object[])new Object[0]), Integer.valueOf(9999), baseDictionaryItem.getId()));
        baseDictionaryItem = new BaseDictionaryItem("commStatus", I18nUtil.i18nCode((String)"common_commStatus", (Object[])new Object[0]), Boolean.valueOf(false), I18nUtil.i18nCode((String)"system_module", (Object[])new Object[0]));
        baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-5000", "common_commStatus_cmdExecuting", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1300", "common_commStatus_queuingException", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1200", "common_commStatus_queuingException", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1112", "common_commStatus_hasBeanManuallyDeleted", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1111", "common_commStatus_hasBeanDeletedFromSyncData", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1100", "common_commStatus_queuingException", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1009", "common_commStatus_cmdExpired", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1007", "common_commStatus_getEventFailed", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1006", "common_commStatus_unknownCmd", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1005", "common_commStatus_executeCmdFailed", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1004", "common_commStatus_devThreadsSuspended", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1003", "common_commStatus_serviceNotStart", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1002", "common_commStatus_disable", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1001", "common_commStatus_disconnected", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-801", "common_commStatus_commandFormatError", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-731", "common_commStatus_receiveDataAnomalies", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-730", "common_commStatus_serverNoAnswer", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-728", "common_commStatus_uploadDataNumberFailed", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-726", "common_commStatus_returnHTTPError", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-725", "common_commStatus_timeoutForWait", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-722", "common_commStatus_uploadToSoftwareFailed", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-721", "common_commStatus_deviceDownload", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-720", "common_commStatus_firmwareUpgradeFailed", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-709", "common_commStatus_uploadOptionFailed", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-708", "common_commStatus_firewareNotSupportCommand", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-632", "common_commStatus_fileNameError", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-631", "common_commStatus_base64LengthError", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-630", "common_commStatus_excuteShellCommandsFailed", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-629", "common_commStatus_tableNameError", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-628", "common_commStatus_mainLoadFailed", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-621", "common_commStatus_notSupportField", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-620", "common_commStatus_sendDataFormatError", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-619", "common_commStatus_senateIsEmpty", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-618", "common_commStatus_URLMalformed", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-616", "common_commStatus_normalOpenFailed", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-615", "common_commStatus_rebootFailed", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-614", "common_commStatus_cancelAlarmFailed", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-612", "common_commStatus_saveParametersFailed", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-604", "common_commStatus_notEnoughMemory", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-603", "common_commStatus_handleInvalid", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-307", "common_commStatus_connectTimeout", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-306", "common_commStatus_hostError", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-305", "common_commStatus_socketError", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-304", "common_commStatus_invalidSocket", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-303", "common_commStatus_getProtocolTypeFailed", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-302", "common_commStatus_tcpIpVersionError", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-301", "common_commStatus_getTcpIpVerFailed", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-207", "common_commStatus_mutexTimeout", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-206", "common_commStatus_serialPortTakeUp", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-203", "common_commStatus_commInitFailed", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-202", "common_commStatus_callInterfaceFail", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-201", "common_commStatus_libFileNotExist", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-126", "common_commStatus_libFileLoadFailed", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-128", "common_commStatus_uploadCountFailed", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-127", "common_commStatus_bgAuthFailed", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-125", "common_commStatus_waitReturnTimeout", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-124", "common_commStatus_pushAgain", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-123", "common_commStatus_registryAgain", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-122", "common_commStatus_uploadDataFailed", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-121", "common_commStatus_downloadFileFailed", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-120", "common_commStatus_upgradeFirwareFailed", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-109", "common_commStatus_uploadOptFailed", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-108", "common_commStatus_invalidOptions", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-107", "common_commStatus_getTableFailed", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-106", "common_commStatus_dataOverflow", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-105", "common_commStatus_dataError", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-104", "common_commStatus_rtEventDataError", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-103", "common_commStatus_fieldSortError", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-102", "common_commStatus_fieldNumberError", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-101", "common_commStatus_conditionsThereNo", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-100", "common_commStatus_tableStructureNotExist", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-99", "common_commStatus_unknownError", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-98", "common_commStatus_regionCodeError", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-28", "common_commStatus_canNotClose", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-27", "common_commStatus_canNotFindFPUser", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-26", "common_commStatus_fpLenCannotBeZero", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-25", "common_commStatus_fileNameError", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-24", "common_commStatus_upgradeFileError", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-23", "common_commStatus_firmwareVersionOld", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-22", "common_commStatus_firmwarePlatform", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-21", "common_commStatus_noPlatformParam", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-20", "common_commStatus_dataLengthError", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-19", "common_commStatus_checksumError", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-18", "common_commStatus_storageSpaceFull", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-17", "common_commStatus_fileDoesNotExist", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-16", "common_commStatus_failedReadFile", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-15", "common_commStatus_failedWriteFile", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-14", "common_commStatus_commPwdError", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-13", "common_commStatus_cmdError", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-20", "common_commStatus_dataLengthError", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-12", "common_commStatus_cmdExecutionError", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-11", "common_commStatus_dataParamError", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-10", "common_commStatus_SDKParseError", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-9", "common_commStatus_crcCheckFailed", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-8", "common_commStatus_connNotAuthorized", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-7", "common_commStatus_cmdRepeat", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-6", "common_commStatus_commError", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-5", "common_commStatus_readDataLenError", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-4", "common_commStatus_unpackFailure", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-3", "common_commStatus_noEnoughCache", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-2", "common_commStatus_cmdTimeOut", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1", "common_commStatus_cmdSentFailure", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("0", "common_commStatus_normal", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("1000", "common_commStatus_obtainNewRecord", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("1001", "common_commStatus_areConnected", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("1002", "common_commStatus_disable", Integer.valueOf(0), baseDictionaryItem.getId()));
        baseDictionaryItem = new BaseDictionaryItem("opType", I18nUtil.i18nCode((String)"common_devOpType", (Object[])new Object[0]), Boolean.valueOf(false), I18nUtil.i18nCode((String)"system_module", (Object[])new Object[0]));
        baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("SEND_CMD", "common_devOpType_sendCmd", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("CONNECT", "common_devOpType_connect", Integer.valueOf(1), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("DISCONNECT", "common_devOpType_disconnect", Integer.valueOf(2), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("DATA UPDATE", "common_devOpType_dataUpdate", Integer.valueOf(3), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("DATA QUERY", "common_devOpType_dataQuery", Integer.valueOf(4), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("DATA DELETE", "common_devOpType_dataDelete", Integer.valueOf(5), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("DEVICE GET", "common_devOpType_deviceGet", Integer.valueOf(6), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("DEVICE SET", "common_devOpType_deviceSet", Integer.valueOf(7), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("DATA COUNT", "common_devOpType_dataCount", Integer.valueOf(8), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("CANCEL ALARM", "common_devOpType_cancelAlarm", Integer.valueOf(9), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("CONTROL NO", "common_devOpType_controlNo", Integer.valueOf(10), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("CONTROL DEVICE", "common_devOpType_controlDevice", Integer.valueOf(11), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("UPGRADE", "common_devOpType_upgrade", Integer.valueOf(12), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("GET OPTIONS", "common_devOpType_getOptions", Integer.valueOf(13), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("SET OPTIONS", "common_devOpType_setOptions", Integer.valueOf(14), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("GET_RT_LOG", "common_devOpType_getRTLog", Integer.valueOf(15), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("DOWN_NEWLOG", "common_devOpType_downNewlog", Integer.valueOf(16), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("DOWN_ALLLOG", "common_devOpType_downAlllog", Integer.valueOf(17), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("QUEUE_ERROR", "common_devOpType_queueError", Integer.valueOf(18), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("CHECK_SERVICE", "common_devOpType_checkService", Integer.valueOf(19), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("CHECK_DISK", "common_devOpType_checkDisk", Integer.valueOf(20), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("userauthorize", "common_devOpType_userauthorize", Integer.valueOf(21), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("user", "common_devOpType_user", Integer.valueOf(22), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("holiday", "common_devOpType_holiday", Integer.valueOf(23), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("timezone", "common_devOpType_timezone", Integer.valueOf(24), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("firstcard", "common_devOpType_firstcard", Integer.valueOf(25), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("multimcard", "common_devOpType_multimcard", Integer.valueOf(26), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("transaction", "common_devOpType_transaction", Integer.valueOf(27), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("inoutfun", "common_devOpType_inoutfun", Integer.valueOf(28), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("templatev10", "common_devOpType_templatev10", Integer.valueOf(29), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("losscard", "common_devOpType_losscard", Integer.valueOf(30), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("extuser", "common_devOpType_extuser", Integer.valueOf(31), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("DEV_HEARTBEAT", "common_devOpType_devHeartbeat", Integer.valueOf(32), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("mulcarduser", "common_devOpType_mulcarduser", Integer.valueOf(33), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("fvtemplate", "common_devOpType_fvtemplate", Integer.valueOf(34), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("DefaultWGFormat", "common_devOpType_defaultWGFormat", Integer.valueOf(35), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("WGFormat", "common_devOpType_custWGFormat", Integer.valueOf(36), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("ReaderWGFormat", "common_devOpType_readerWGFormat", Integer.valueOf(37), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("outrelaysetting", "common_devOpType_outrelaysetting", Integer.valueOf(38), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("DSTSetting", "common_devOpType_DSTSetting", Integer.valueOf(39), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("DiffTimezoneVS", "common_devOpType_diffTimezoneVS", Integer.valueOf(40), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("DoorVSTimezone", "common_devOpType_doorVSTimezone", Integer.valueOf(41), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("PersonalVSTimezone", "common_devOpType_personalVSTimezone", Integer.valueOf(42), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("InputIOSetting", "common_devOpType_inputIOSetting", Integer.valueOf(43), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("facev7", "common_devOpType_facev7", Integer.valueOf(44), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("identitycard", "common_devOpType_identityCard", Integer.valueOf(45), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("CMD_RETURN", "common_devOpType_cmdReturn", Integer.valueOf(46), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("biophoto", "common_devOpType_biophoto", Integer.valueOf(47), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("biodata", "common_devOpType_biodata", Integer.valueOf(48), baseDictionaryItem.getId()));
        baseDictionaryItem = new BaseDictionaryItem("systemTimeZone", I18nUtil.i18nCode((String)"system_dev_timeZone", (Object[])new Object[0]), Boolean.valueOf(false), I18nUtil.i18nCode((String)"system_module", (Object[])new Object[0]));
        baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1200", "system_utc_12", Integer.valueOf(10), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1100", "system_utc_11", Integer.valueOf(11), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-1000", "system_utc_10", Integer.valueOf(12), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-0900", "system_utc_9", Integer.valueOf(13), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-0800", "system_utc_8", Integer.valueOf(14), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-0700", "system_utc_7", Integer.valueOf(15), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-0600", "system_utc_6", Integer.valueOf(16), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-0500", "system_utc_5", Integer.valueOf(17), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-0430", "system_utc_430", Integer.valueOf(18), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-0400", "system_utc_4", Integer.valueOf(19), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-0330", "system_utc_330", Integer.valueOf(20), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-0300", "system_utc_3", Integer.valueOf(21), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-0200", "system_utc_2", Integer.valueOf(22), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-0100", "system_utc_1", Integer.valueOf(23), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("-0000", "system_utc_0", Integer.valueOf(24), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("+0100", "system_utc1", Integer.valueOf(25), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("+0200", "system_utc2", Integer.valueOf(26), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("+0300", "system_utc3", Integer.valueOf(27), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("+0330", "system_utc330", Integer.valueOf(28), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("+0400", "system_utc4", Integer.valueOf(29), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("+0430", "system_utc430", Integer.valueOf(30), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("+0500", "system_utc5", Integer.valueOf(31), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("+0530", "system_utc530", Integer.valueOf(32), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("+0545", "system_utc545", Integer.valueOf(33), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("+0600", "system_utc6", Integer.valueOf(34), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("+0630", "system_utc630", Integer.valueOf(35), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("+0700", "system_utc7", Integer.valueOf(36), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("+0800", "system_utc8", Integer.valueOf(37), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("+0900", "system_utc9", Integer.valueOf(38), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("+0930", "system_utc930", Integer.valueOf(39), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("+1000", "system_utc10", Integer.valueOf(40), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("+1100", "system_utc11", Integer.valueOf(41), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("+1200", "system_utc12", Integer.valueOf(42), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("+1300", "system_utc13", Integer.valueOf(43), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("+1400", "system_utc14", Integer.valueOf(44), baseDictionaryItem.getId()));
        baseDictionaryItem = new BaseDictionaryItem("appProType", I18nUtil.i18nCode((String)"auth_app_type", (Object[])new Object[0]), Boolean.valueOf(false), I18nUtil.i18nCode((String)"system_module", (Object[])new Object[0]));
        baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("ZKBioSecurity", "ZKBioSecurity", Integer.valueOf(1), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("EcoPro", "EcoPro", Integer.valueOf(2), baseDictionaryItem.getId()));
        baseDictionaryItem = new BaseDictionaryItem("BaseMessageType", I18nUtil.i18nCode((String)"system_message_type", (Object[])new Object[0]), Boolean.valueOf(false), I18nUtil.i18nCode((String)"system_module", (Object[])new Object[0]));
        baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("TodoMsg", "system_message_type_TodoMsg", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("NotifyMsg", "system_message_type_NotifyMsg", Integer.valueOf(1), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("VisTendency", "system_message_type_VisTendency", Integer.valueOf(2), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("WarnMsg", "system_message_type_WarnMsg", Integer.valueOf(3), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("RemindMsg", "system_message_type_RemindMsg", Integer.valueOf(4), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("BulletinBoard", "system_message_type_BulletinBoard", Integer.valueOf(5), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("SystemMsg", "system_message_type_SystemMsg", Integer.valueOf(6), baseDictionaryItem.getId()));
    }

    private void initAuthPermission() {
        AuthPermissionItem subButtonItem = null;
        AuthPermissionItem subMenuItem1 = null;
        AuthPermissionItem subMenuItem = null;
        AuthPermissionItem systemItem = null;
        systemItem = new AuthPermissionItem("System", "system_module", "system", "system", "true", Integer.valueOf(999));
        systemItem = this.authInitDataProvider.initPermissionData(systemItem);
        subMenuItem1 = new AuthPermissionItem("SystemBaseManager", "base_leftMenu_basicManagement", "system:system:manager", "menu", "true", Integer.valueOf(1));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setImg("base_basicManagement.png");
        subMenuItem1.setImgHover("base_basicManagement_over.png");
        subMenuItem1 = this.authInitDataProvider.initPermissionData(subMenuItem1);
        if (this.isDev.booleanValue()) {
            subMenuItem = new AuthPermissionItem("BaseLanguage", "base_leftMenu_i18n", "system:baseLanguage", "menu", "true", Integer.valueOf(1));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("baseLanguage.do");
            subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
            subButtonItem = new AuthPermissionItem("BaseLanguageRefresh", "common_op_refresh", "system:baseLanguage:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("BaseLanguageAdd", "common_op_new", "system:baseLanguage:edit", "button", "true", Integer.valueOf(2));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("BaseLanguageDel", "common_op_del", "system:baseLanguage:del", "button", "true", Integer.valueOf(3));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("BaseLanguageContrast", "common_op_contrast", "system:baseLanguage:contrast", "button", "true", Integer.valueOf(4));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("BaseLanguagePreview", "base_language_preview", "system:baseLanguage:preview", "button", "true", Integer.valueOf(5));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("BaseLanguageExportLanguagePack", "base_i18n_exportLanguagePack", "system:baseLanguage:downloadResource", "button", "true", Integer.valueOf(6));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("BaseLanguageLoadModuleLangResource", "common_op_edit", "system:baseLanguageResource:loadModuleLangResource", "button", "true", Integer.valueOf(7));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("BaseLanguageSaveChangedLangRes", "base_i18n_save", "system:baseLanguageResource:saveChangedLangRes", "button", "true", Integer.valueOf(8));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authInitDataProvider.initPermissionData(subButtonItem);
        }
        subMenuItem = new AuthPermissionItem("BaseOpLog", "base_leftMenu_systemLog", "system:opLog", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("baseOpLog.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        subButtonItem = new AuthPermissionItem("BaseOpLogRefresh", "common_op_refresh", "system:opLog:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("BaseOpLogExport", "common_op_export", "system:opLog:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authInitDataProvider.initPermissionData(subButtonItem);
        if (!this.isCloud.booleanValue()) {
            subMenuItem = new AuthPermissionItem("BaseDbBackup", "base_leftMenu_databaseManagement", "system:baseDbBackup", "menu", "true", Integer.valueOf(3));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("baseDbBackup.do");
            subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
            subButtonItem = new AuthPermissionItem("BaseDbBackupRefresh", "common_op_refresh", "system:baseDbBackup:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("BaseDbBackupImmeBackup", "base_db_backup", "system:baseDbBackup:immeBackup", "button", "true", Integer.valueOf(2));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authInitDataProvider.initPermissionData(subButtonItem);
            if ("ZKBioAccess".equals(this.productCode)) {
                if (!"zh_CN".equals(LocaleMessageSourceUtil.language)) {
                    subButtonItem = new AuthPermissionItem("BaseDbBackupPlanBackup", "base_db_backupPlan", "system:baseDbBackup:planBackup", "button", "true", Integer.valueOf(3));
                    subButtonItem.setParentId(subMenuItem.getId());
                    this.authInitDataProvider.initPermissionData(subButtonItem);
                }
            } else {
                subButtonItem = new AuthPermissionItem("BaseDbBackupPlanBackup", "base_db_backupPlan", "system:baseDbBackup:planBackup", "button", "true", Integer.valueOf(3));
                subButtonItem.setParentId(subMenuItem.getId());
                this.authInitDataProvider.initPermissionData(subButtonItem);
            }
            subButtonItem = new AuthPermissionItem("BaseDbBackupDel", "common_op_del", "system:baseDbBackup:del", "button", "true", Integer.valueOf(4));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("BaseDbBackupToFtp", "base_db_ftpSet", "system:baseDbBackup:getFtpSetting", "button", "true", Integer.valueOf(5));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authInitDataProvider.initPermissionData(subButtonItem);
        }
        subMenuItem = new AuthPermissionItem("AuthArea", "base_leftMenu_locale", "auth:area", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("authArea.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AuthAreaRefresh", "common_op_refresh", "auth:area:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AuthAreaAdd", "common_op_new", "auth:area:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AuthAreaEdit", "common_op_edit", "auth:area:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AuthAreaDel", "common_op_del", "auth:area:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AuthAreaImport", "common_op_import", "auth:area:import", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AuthAreaExport", "common_op_export", "auth:area:export", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authInitDataProvider.initPermissionData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AuthDepartment", "auth_dept_entity", "auth:department", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("authDepartment.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AuthDepartmentRefresh", "common_op_refresh", "auth:department:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AuthDepartmentAdd", "common_op_new", "auth:department:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AuthDepartmentEdit", "common_op_edit", "auth:department:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AuthDepartmentDel", "common_op_del", "auth:department:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AuthDepartmentExport", "common_op_export", "auth:department:export", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authInitDataProvider.initPermissionData(subButtonItem);
        if (this.isDev.booleanValue()) {
            subMenuItem = new AuthPermissionItem("BaseSysParam", "base_system_parameter", "system:sysParam", "menu", "true", Integer.valueOf(6));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("baseSysParam.do");
            subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
            subButtonItem = new AuthPermissionItem("BaseSysParamRefresh", "common_op_refresh", "system:sysParam:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authInitDataProvider.initPermissionData(subButtonItem);
        }
        subMenuItem = new AuthPermissionItem("BaseMail", "base_leftMenu_emailManagement", "system:mail", "menu", "true", Integer.valueOf(7));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("baseMail.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        subButtonItem = new AuthPermissionItem("BaseMailRefresh", "common_op_refresh", "system:mail:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("BaseMailDel", "common_op_del", "system:mail:del", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("BaseMailParamSetting", "base_mail_paramSetting", "system:mail:getMailParam", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("BaseMailExport", "common_op_export", "system:mail:export", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authInitDataProvider.initPermissionData(subButtonItem);
        if (!"ZKBioAccess".equals(this.productCode)) {
            subMenuItem = new AuthPermissionItem("BaseDictionary", "base_leftMenu_dictionary", "system:dictionary", "menu", "true", Integer.valueOf(8));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("baseDictionary.do");
            subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        }
        subMenuItem = new AuthPermissionItem("BaseDataClean", "base_leftMenu_dataClean", "system:baseDataClean", "menu", "true", Integer.valueOf(9));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("baseDataClean.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        if (!this.isCloud.booleanValue()) {
            subMenuItem = new AuthPermissionItem("BaseMediaFile", "base_leftMenu_AudioFile", "system:mediaFile", "menu", "true", Integer.valueOf(10));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("baseMediaFile.do");
            subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
            subButtonItem = new AuthPermissionItem("BaseMediaFileRefresh", "common_op_refresh", "system:mediaFile:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("BaseMediaFileAdd", "common_op_new", "system:mediaFile:add", "button", "true", Integer.valueOf(2));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("BaseMediaFileEdit", "common_op_edit", "system:mediaFile:edit", "button", "true", Integer.valueOf(3));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("BaseMediaFileDel", "common_op_del", "system:mediaFile:del", "button", "true", Integer.valueOf(4));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authInitDataProvider.initPermissionData(subButtonItem);
            if ("ZKBioSecurity".equals(this.productCode)) {
                subMenuItem = new AuthPermissionItem("SystemDataMigration", "system_data_migration", "system:dataMigration", "menu", "true", Integer.valueOf(11));
                subMenuItem.setParentId(subMenuItem1.getId());
                subMenuItem.setActionLink("systemDataMigration.do");
                subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
            }
        }
        subMenuItem = new AuthPermissionItem("BaseCertType", "pers_cert_type", "system:cerType", "menu", "true", Integer.valueOf(13));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("baseCerType.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        subButtonItem = new AuthPermissionItem("BaseCertTypeRefresh", "common_op_refresh", "system:cerType:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("BaseCertTypeAdd", "common_op_new", "system:cerType:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("BaseCertTypeEdit", "common_op_edit", "system:cerType:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("BaseCertTypeDel", "common_op_del", "system:cerType:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authInitDataProvider.initPermissionData(subButtonItem);
        if ("ZKBioSecurity".equals(this.productCode)) {
            subMenuItem = new AuthPermissionItem("BasePrintTemplate", "base_leftMenu_printTemplateManagement", "system:printTemplate", "menu", "true", Integer.valueOf(13));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("basePrintTemplate.do");
            subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
            subButtonItem = new AuthPermissionItem("BasePrintTemplateRefresh", "common_op_refresh", "system:printTemplate:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("BasePrintTemplateAdd", "common_op_new", "system:printTemplate:add", "button", "true", Integer.valueOf(2));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("BasePrintTemplateEdit", "common_op_edit", "system:printTemplate:edit", "button", "true", Integer.valueOf(3));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("BasePrintTemplateDel", "common_op_del", "system:printTemplate:del", "button", "true", Integer.valueOf(4));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("BasePrintTemplatePreview", "common_chart_preview", "system:printTemplate:preview", "button", "true", Integer.valueOf(5));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authInitDataProvider.initPermissionData(subButtonItem);
            subMenuItem = new AuthPermissionItem("SystemInfo", "system_serverInfo_serverInfo", "system:info", "menu", "true", Integer.valueOf(14));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("systemServerInfo.do");
            subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
            if ("zh_CN".equals(this.language)) {
                subMenuItem = new AuthPermissionItem("BaseAuthDataUpload", "system_baseData_upload", "system:baseAuthDataUpload", "menu", "true", Integer.valueOf(15));
                subMenuItem.setParentId(subMenuItem1.getId());
                subMenuItem.setActionLink("baseAuthDataUpload.do");
                subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
            }
            subMenuItem = new AuthPermissionItem("BaseParamSetting", "common_leftMenu_paramSet", "system:param:setting", "menu", "true", Integer.valueOf(16));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("baseParamSetting.do");
            subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        }
        subMenuItem1 = new AuthPermissionItem("AuthManager", "auth_leftMenu_authorityManage", "auth:manager", "menu", "true", Integer.valueOf(2));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setImg("auth_authorityManage.png");
        subMenuItem1.setImgHover("auth_authorityManage_over.png");
        subMenuItem1 = this.authInitDataProvider.initPermissionData(subMenuItem1);
        subMenuItem = new AuthPermissionItem("AuthUser", "auth_leftMenu_userManage", "auth:user", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("authUser.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AuthUserAdd", "common_op_new", "auth:user:add", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AuthUserEdit", "common_op_edit", "auth:user:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AuthUserDel", "common_op_del", "auth:user:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AuthUserRefresh", "common_op_refresh", "auth:user:refresh", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AuthUserImport", "common_op_import", "auth:user:import", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AuthUserExport", "common_op_export", "auth:user:export", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authInitDataProvider.initPermissionData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AuthRole", "auth_leftMenu_roleManage", "auth:role", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("authRole.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AuthRoleAdd", "common_op_new", "auth:role:add", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AuthRoleEdit", "common_op_edit", "auth:role:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AuthRoleDel", "common_op_del", "auth:role:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AuthRoleRefresh", "common_op_refresh", "auth:role:refresh", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        if (this.isDev.booleanValue()) {
            subMenuItem = new AuthPermissionItem("AuthPermissionSystem", "auth_leftMenu_systemManage", "auth:permission:system", "menu", "true", Integer.valueOf(3));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("authPermissionSystem.do?resourceType=system");
            subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
            subButtonItem = new AuthPermissionItem("AuthPermissionSystemRefresh", "common_op_refresh", "auth:permission:system:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
            subMenuItem = new AuthPermissionItem("AuthPermissionMenu", "auth_leftMenu_menuManage", "auth:permission:menu", "menu", "true", Integer.valueOf(4));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("authPermissionMenu.do?resourceType=menu");
            subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
            subButtonItem = new AuthPermissionItem("AuthPermissionMenuRefresh", "common_op_refresh", "auth:permission:menu:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("AuthPermissionMenuAdd", "common_op_new", "auth:permission:menu:add", "button", "true", Integer.valueOf(2));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("AuthPermissionMenuEdit", "common_op_edit", "auth:permission:menu:edit", "button", "true", Integer.valueOf(3));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
            subMenuItem = new AuthPermissionItem("AuthPermissionButton", "auth_leftMenu_functionManage", "auth:permission:button", "menu", "true", Integer.valueOf(5));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("authPermissionButton.do?resourceType=button");
            subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
            subButtonItem = new AuthPermissionItem("AuthPermissionButtonRefresh", "common_op_refresh", "auth:permission:button:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("AuthPermissionButtonAdd", "common_op_new", "auth:permission:button:add", "button", "true", Integer.valueOf(2));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("AuthPermissionButtonEdit", "common_op_edit", "auth:permission:button:edit", "button", "true", Integer.valueOf(3));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        }
        if (!this.isCloud.booleanValue() && !"ZKBioAccess".equals(this.productCode)) {
            subMenuItem = new AuthPermissionItem("AuthApiToken", "auth_leftMenu_thirdParty", "auth:apiToken", "menu", "true", Integer.valueOf(6));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("authApiToken.do");
            subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
            subButtonItem = new AuthPermissionItem("AuthApiTokenRefresh", "common_op_refresh", "auth:apiToken:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("AuthApiTokenAdd", "common_op_new", "auth:apiToken:add", "button", "true", Integer.valueOf(2));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("AuthApiTokenEdit", "common_op_edit", "auth:apiToken:edit", "button", "true", Integer.valueOf(3));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("AuthApiTokenDel", "common_op_del", "auth:apiToken:del", "button", "true", Integer.valueOf(4));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("AuthApiTokenBrowse", "auth_token_browseApi", "auth:apiToken:browse", "button", "true", Integer.valueOf(5));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
            subMenuItem = new AuthPermissionItem("BaseRegister", "base_client_register", "base:register", "menu", "true", Integer.valueOf(7));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("baseRegister.do");
            subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
            subButtonItem = new AuthPermissionItem("BaseRegisterRefresh", "common_op_refresh", "base:register:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("BaseRegisterAdd", "common_op_new", "base:register:add", "button", "true", Integer.valueOf(2));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("BaseRegisterReset", "common_op_reset", "base:register:reset", "button", "true", Integer.valueOf(3));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("BaseRegisterDel", "common_op_del", "base:register:del", "button", "true", Integer.valueOf(4));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("BaseRegisterQrcode", "base_registerQrcode", "base:register:qrcode", "button", "true", Integer.valueOf(5));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        }
        subMenuItem = new AuthPermissionItem("authSecurityParams", "system_leftMenu_authSecurityParams", "auth:securityParams", "menu", "true", Integer.valueOf(8));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("systemSecurityParams.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        if (this.isCloud.booleanValue()) {
            subMenuItem1 = new AuthPermissionItem("AuthCompanyManager", "auth_company_manager", "auth:company:manager", "menu", "true", Integer.valueOf(3));
            subMenuItem1.setParentId(systemItem.getId());
            subMenuItem1.setImg("base_extendManage.png");
            subMenuItem1.setImgHover("base_extendManage_over.png");
            subMenuItem1 = this.authInitDataProvider.initPermissionData(subMenuItem1);
            subMenuItem = new AuthPermissionItem("AuthCompany", "auth_company", "auth:company", "menu", "true", Integer.valueOf(1));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("authCompany.do");
            subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
            subButtonItem = new AuthPermissionItem("AuthCompanyRefresh", "common_op_refresh", "auth:company:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("AuthCompanyAudit", "auth_company_audit", "auth:company:audit", "button", "true", Integer.valueOf(2));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("AuthCompanyModifyPwd", "auth_company_modifyPwd", "auth:company:modifyPwd", "button", "true", Integer.valueOf(3));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = new AuthPermissionItem("AuthCompanyModifyPosition", "auth_company_modifyPosition", "auth:company:modifyPosition", "button", "true", Integer.valueOf(4));
            subButtonItem.setParentId(subMenuItem.getId());
            subMenuItem = new AuthPermissionItem("AuthApp", "auth_app", "auth:app", "menu", "true", Integer.valueOf(2));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("authApp.do");
            subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
            subButtonItem = new AuthPermissionItem("AuthAppRefresh", "common_op_refresh", "auth:app:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("AuthAppAdd", "common_op_add", "auth:app:add", "button", "true", Integer.valueOf(2));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
            subButtonItem = new AuthPermissionItem("AuthAppEdit", "common_op_edit", "auth:app:edit", "button", "true", Integer.valueOf(3));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
            subMenuItem = new AuthPermissionItem("SystemClientInfo", "system_systemClientInfo", "system:systemClientInfo", "menu", "true", Integer.valueOf(3));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("systemClientInfo.do");
            subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        }
    }

    public void initSysParam() {
        BaseSysParamItem item = new BaseSysParamItem("systemName", I18nUtil.i18nCode((String)"base_systemName", (Object[])new Object[0]), I18nUtil.i18nCode((String)"base_sysParam_sysName", (Object[])new Object[0]), Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("systemVersion", "4.0.0.1", I18nUtil.i18nCode((String)"base_sysParam_systemVersion", (Object[])new Object[0]), Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("databaseVersion", "4.0.0.1", I18nUtil.i18nCode((String)"base_db_version", (Object[])new Object[0]), Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("base.mailServerHost", "", I18nUtil.i18nCode((String)"base_mail_serverIp", (Object[])new Object[0]));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("base.mailServerPort", "25", I18nUtil.i18nCode((String)"base_mail_serverPort", (Object[])new Object[0]));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("base.mailUserName", "", I18nUtil.i18nCode((String)"base_mail_userName", (Object[])new Object[0]));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("base.mailPassword", "", I18nUtil.i18nCode((String)"base_mail_password", (Object[])new Object[0]));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("base.mailFromAddress", "", I18nUtil.i18nCode((String)"base_mail_userName", (Object[])new Object[0]));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("base.mailShowMailName", "", I18nUtil.i18nCode((String)"base_mail_senderName", (Object[])new Object[0]));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("base.mailSSLSelect", "", "SSL");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("base.mailTLSSelect", "", "TLS");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("system.useFingerService", "false", I18nUtil.i18nCode((String)"base_param_usingFPMatch", (Object[])new Object[0]));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("system.appSocketioUrl", "", "App Socket Url");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("system.appSocketioPort", "9091", "App Socket Port");
        this.baseSysParamService.initData(item);
        this.systemSecurityParamsService.initParams("verificationCodeOpen", "0");
        this.systemSecurityParamsService.initParams("loginErrorCont", "0");
        this.systemSecurityParamsService.initParams("lockTime", "0");
        this.systemSecurityParamsService.initParams("effectiveTime", "5");
        if ("zh_CN".equals(this.language)) {
            this.systemSecurityParamsService.initParams("initPwd", "0");
            this.systemSecurityParamsService.initParams("passwordStrengthLevel", "3");
        } else {
            this.systemSecurityParamsService.initParams("initPwd", "2");
            this.systemSecurityParamsService.initParams("passwordStrengthLevel", "1");
        }
        JSONObject values = new JSONObject();
        values.put("keptMonth", (Object)"15");
        values.put("runtime", (Object)"03:00:00");
        item = new BaseSysParamItem("systemDataCleanOpLog", values.toString(), "base_dataClean_oplog");
        this.baseSysParamService.initData(item);
        values = new JSONObject();
        values.put("keptMonth", (Object)"6");
        values.put("runtime", (Object)"02:00:00");
        values.put("imme", (Object)"1");
        values.put("cleanAction", (Object)"baseDataClean.do?immediateClean&name=AdmsDevCmd&columnName=commitTime&tip=base_dataClean_admsDevCmd");
        values.put("cleanTip", (Object)"base_dataClean_prompt_sureToClearAdmsDevCmd");
        item = new BaseSysParamItem("systemDataCleanCmdData", values.toString(), "base_dataClean_admsDevCmd");
        this.baseSysParamService.initData(item);
        values = new JSONObject();
        values.put("keptMonth", (Object)"6");
        values.put("runtime", (Object)"04:00:00");
        values.put("imme", (Object)"1");
        values.put("cleanAction", (Object)"baseDataClean.do?immediateClean&name=dbbackup&tip=base_dataClean_db");
        values.put("cleanTip", (Object)"base_dataClean_prompt_sureToClearDb");
        item = new BaseSysParamItem("systemDataCleanDbBak", values.toString(), "base_dataClean_db");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("dbLocalBackupPath", ClassUtil.getRootPath() + "/tempDBBackup/", I18nUtil.i18nCode((String)"base_db_backupPath", (Object[])new Object[0]), Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("isSecondBackup", "false", I18nUtil.i18nCode((String)"base_db_openSecondBackUp", (Object[])new Object[0]), Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("dbBackupRemote", "false", I18nUtil.i18nCode((String)"base_db_openRemoteBackUp", (Object[])new Object[0]), Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("ftpDir", "", I18nUtil.i18nCode((String)"base_db_remoteDir", (Object[])new Object[0]), Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("ftpAddr", "192.168.18.119", I18nUtil.i18nCode((String)"base_db_remoteIp", (Object[])new Object[0]), Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("ftpPort", "21", I18nUtil.i18nCode((String)"base_db_remotePort", (Object[])new Object[0]), Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("ftpUsername", "hp", I18nUtil.i18nCode((String)"base_db_remoteAccount", (Object[])new Object[0]), Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("ftpPwd", "hpadmin", I18nUtil.i18nCode((String)"base_db_remotePassword", (Object[])new Object[0]), Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("secondBackupDir", "d\\:\\\\zkteco", I18nUtil.i18nCode((String)"base_db_secondStorePath", (Object[])new Object[0]), Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("dbBackupStartTime", "2014-08-08 18:00:00", I18nUtil.i18nCode((String)"base_db_lastdbBackupTime", (Object[])new Object[0]), Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("dbBackupIntervalTime", "7", I18nUtil.i18nCode((String)"base_db_backUpTime", (Object[])new Object[0]), Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("lastdbBackupTime", "", I18nUtil.i18nCode((String)"base_db_nextdbBackupTime", (Object[])new Object[0]), Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("qrcode.publicKey", this.baseSysParamService.generateSecretKey(), "\u52a8\u6001\u4e8c\u7ef4\u7801\u79d8\u94a5", Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("qrcode.algorithm", BaseDataConstants.QRCODE_ALGORITHM_AES, "\u52a8\u6001\u4e8c\u7ef4\u7801\u7b97\u6cd5\u5e8f\u53f7", Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("qrcode.validTime", "30", "\u52a8\u6001\u4e8c\u7ef4\u7801\u6709\u6548\u65f6\u957f", Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("qrcode.type", BaseDataConstants.QRCODE_TYPE_DYNAMIC, "\u4e8c\u7ef4\u7801\u7c7b\u578b", Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
        if (this.isCloud.booleanValue()) {
            item = new BaseSysParamItem("cloud.qrcode.url", "https://portal.xmzkteco.com/portal/self.do?self&appId=", I18nUtil.i18nCode((String)"base_param_selfRegisteredAddress", (Object[])new Object[0]), Boolean.valueOf(true));
            this.baseSysParamService.initData(item);
            item = new BaseSysParamItem("cloud.cfs.fileUrl", "https://cfs.xmzkteco.com", I18nUtil.i18nCode((String)"base_param_fileServerPath", (Object[])new Object[0]), Boolean.valueOf(true));
            this.baseSysParamService.initData(item);
        }
    }

    public void initBaseMediaFile() {
        BaseMediaFileItem item = new BaseMediaFileItem(I18nUtil.i18nCode((String)"common_alarm", (Object[])new Object[0]), "public/media/sound/alarm.wav", "20KB", "wav", Boolean.valueOf(true));
        this.baseMediaFileService.initData(item);
    }

    public void initBaseLanguage() {
        Resource[] resources = MessageSourceAutoConfiguration.RESOURCES;
        HashSet<String> languageSet = new HashSet<String>();
        languageSet.add("zh_CN");
        languageSet.add("en_US");
        HashMap<String, HashSet<Resource>> moduleMap = new HashMap<String, HashSet<Resource>>();
        for (Resource resource : resources) {
            String propertiesName = resource.getFilename();
            propertiesName = propertiesName.substring(0, propertiesName.length() - 11);
            String language = propertiesName.substring(propertiesName.indexOf("_") + 1, propertiesName.length());
            languageSet.add(language);
            HashSet<Resource> resourceSet = (HashSet<Resource>)moduleMap.get(language);
            if (resourceSet == null) {
                resourceSet = new HashSet<Resource>();
            }
            resourceSet.add(resource);
            moduleMap.put(language, resourceSet);
        }
        for (String language : languageSet) {
            BaseLanguageItem baseLanguageItem = new BaseLanguageItem();
            baseLanguageItem.setCode(language);
            baseLanguageItem.setBuildInFlag(Boolean.valueOf(true));
            baseLanguageItem = this.baseLanguageService.initData(baseLanguageItem);
            Set resourceSet = (Set)moduleMap.get(language);
            for (Resource resource : resourceSet) {
                String propertiesName = resource.getFilename();
                propertiesName = propertiesName.substring(0, propertiesName.length() - 11);
                String moduleCode = propertiesName.substring(0, propertiesName.indexOf("_"));
                try {
                    this.saveResourcePro(baseLanguageItem, resource, moduleCode);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void saveResourcePro(BaseLanguageItem baseLanguageItem, Resource fileResource, String moduleCode) throws Exception {
        Properties properties = new Properties();
        properties.load(new InputStreamReader(fileResource.getInputStream(), "utf-8"));
        Set<String> keys = properties.stringPropertyNames();
        BaseLanguageResourceItem baseLanguageResourceItem = null;
        int i = 1;
        for (String key : keys) {
            baseLanguageResourceItem = new BaseLanguageResourceItem();
            baseLanguageResourceItem.setName(key);
            baseLanguageResourceItem.setContent(properties.getProperty(key));
            baseLanguageResourceItem.setModuleCode(moduleCode);
            baseLanguageResourceItem.setProOrder(Integer.valueOf(i));
            baseLanguageResourceItem.setLanguageId(baseLanguageItem.getId());
            baseLanguageResourceItem.setLanguageCode(baseLanguageItem.getCode());
            this.baseLanguageResourceService.saveItem(baseLanguageResourceItem);
            ++i;
        }
    }

    private void initAppMenus() {
        AuthPermissionItem appModuleItem = null;
        appModuleItem = new AuthPermissionItem("App", "app_module", "app", "app_system", "true", Integer.valueOf(998));
        this.authInitDataProvider.initPermissionData(appModuleItem);
    }

    private void initFPServerData() {
        this.authInitDataProvider.initFPServerData();
    }

    private void initUpgradeVersion() {
        String curVersion = VersionUtil.getReleaseGitTags((String)"system");
        if (StringUtils.isNotBlank((CharSequence)curVersion)) {
            BaseSysParamItem baseSysParamItem = this.baseSysParamService.findByParamName("SystemUpgradeVersion");
            if (StringUtils.isBlank((CharSequence)baseSysParamItem.getId())) {
                baseSysParamItem = new BaseSysParamItem("SystemUpgradeVersion", curVersion, "System Upgrade Version", Boolean.valueOf(true));
            }
            this.baseSysParamService.saveItem(baseSysParamItem);
        }
    }
}

