/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.sis.remote.SisCarUnderRemote;
import com.zkteco.zkbiosecurity.sis.service.SisCarUnderService;
import com.zkteco.zkbiosecurity.sis.vo.SisCarUnderInfoItem;
import com.zkteco.zkbiosecurity.sis.vo.SisCarUnderItem;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SisCarUnderController
extends BaseController
implements SisCarUnderRemote {
    private static final Logger log = LoggerFactory.getLogger(SisCarUnderController.class);
    @Autowired
    private SisCarUnderService sisCarUnderService;

    @RequiresPermissions(value={"sis:carUnder"})
    public ModelAndView index() {
        return new ModelAndView("sis/carUnder/sisCarUnder");
    }

    @RequiresPermissions(value={"sis:carUnder:add"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            SisCarUnderItem item = this.sisCarUnderService.findById(id);
            this.request.setAttribute("item", (Object)item);
        }
        return new ModelAndView("sis/carUnder/editSisCarUnder");
    }

    @RequiresPermissions(value={"sis:carUnder:edit"})
    public ZKResultMsg save(SisCarUnderItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.sisCarUnderService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"sis:carUnder"})
    public DxGrid list(SisCarUnderItem condition) {
        Pager pager = this.sisCarUnderService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"sis:carUnder:del"})
    public ZKResultMsg del(String ids) {
        this.sisCarUnderService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"sis:carUnder:uploadTransaction"})
    public ModelAndView uploadTransaction(String id) {
        this.request.setAttribute("id", (Object)id);
        return new ModelAndView("sis/carUnder/uploadTransaction");
    }

    public ZKResultMsg queryHistory(SisCarUnderInfoItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.sisCarUnderService.queryHistory(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }
}

