/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.sis.remote.SisCarBottomScanTransactionRemote;
import com.zkteco.zkbiosecurity.sis.service.SisCarBottomInfoService;
import com.zkteco.zkbiosecurity.sis.vo.SisCarBottomInfoItem;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SisCarBottomScanTransactionController
extends ExportController
implements SisCarBottomScanTransactionRemote {
    @Autowired
    SisCarBottomInfoService sisCarBottomInfoService;

    public ModelAndView index() {
        return new ModelAndView("sis/reports/sisCarBottomScanTransaction");
    }

    public DxGrid list(SisCarBottomInfoItem condition) {
        Pager pager = this.sisCarBottomInfoService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg getCarBottomScanList(SisCarBottomInfoItem condition) {
        Pager pager = this.sisCarBottomInfoService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)pager));
    }

    public ZKResultMsg isFileExist(String vidLinkageHandle) {
        boolean isExist = this.sisCarBottomInfoService.isFileExist(vidLinkageHandle);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)String.valueOf(isExist)));
    }

    @RequiresPermissions(value={"sis:carBottomScanTransaction:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) throws InvocationTargetException, IllegalAccessException {
        SisCarBottomInfoItem sisCarBottomInfoItem = new SisCarBottomInfoItem();
        this.setConditionValue((BaseItem)sisCarBottomInfoItem);
        List itemList = this.sisCarBottomInfoService.getItemData(SisCarBottomInfoItem.class, sisCarBottomInfoItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, SisCarBottomInfoItem.class);
    }

    @RequiresPermissions(value={"sis:carBottomScanTransaction:del"})
    public ZKResultMsg del(String ids) {
        this.sisCarBottomInfoService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getCarEventData() {
        ZKResultMsg resultMsg = new ZKResultMsg();
        JSONObject dataJson = this.sisCarBottomInfoService.getCarEventData();
        resultMsg.setData((Object)dataJson);
        return resultMsg;
    }
}

