/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.bean.ParkChargingResults;
import com.zkteco.zkbiosecurity.park.constants.ParkConstants;
import com.zkteco.zkbiosecurity.park.remote.ParkTemporaryChargeRemote;
import com.zkteco.zkbiosecurity.park.service.ParkTemporaryChargeExtendService;
import com.zkteco.zkbiosecurity.park.service.ParkTemporaryChargeService;
import com.zkteco.zkbiosecurity.park.utils.ParkI18nUtil;
import com.zkteco.zkbiosecurity.park.vo.ParkTemporaryChargeExtendItem;
import com.zkteco.zkbiosecurity.park.vo.ParkTemporaryChargeItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkTemporaryChargeController
extends BaseController
implements ParkTemporaryChargeRemote {
    @Autowired
    private ParkTemporaryChargeService parkTemporaryChargeService;
    @Autowired
    private ParkTemporaryChargeExtendService parkTemporaryChargeExtendService;

    @RequiresPermissions(value={"park:temporaryCharge"})
    public ModelAndView index() {
        return new ModelAndView("park/temporaryCharge/parkTemporaryCharge");
    }

    @RequiresPermissions(value={"park:temporaryCharge:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        ParkTemporaryChargeItem parkTemporaryChargeItem = new ParkTemporaryChargeItem();
        parkTemporaryChargeItem.setChargeMode(ParkConstants.TEMPCHARGE_BYTIME);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            parkTemporaryChargeItem = this.parkTemporaryChargeService.getItemById(id);
        }
        this.request.setAttribute("item", (Object)parkTemporaryChargeItem);
        List parkTemporaryChargeExtendList = this.parkTemporaryChargeExtendService.getTemporaryChargeExtendListForEdit(id);
        if (StringUtils.isBlank((CharSequence)id)) {
            this.request.setAttribute("parkTemporaryChargeExtendByTimeList", (Object)parkTemporaryChargeExtendList);
            this.request.setAttribute("parkTemporaryChargeExtendByCycleList", (Object)parkTemporaryChargeExtendList);
        } else if (parkTemporaryChargeItem.getChargeMode().equals(ParkConstants.TEMPCHARGE_BYTIME)) {
            this.request.setAttribute("parkTemporaryChargeExtendByTimeList", (Object)parkTemporaryChargeExtendList);
            ArrayList<ParkTemporaryChargeExtendItem> temporaryChargeExtendCyleList = new ArrayList<ParkTemporaryChargeExtendItem>();
            ParkTemporaryChargeExtendItem chargeExtCycle = new ParkTemporaryChargeExtendItem();
            temporaryChargeExtendCyleList.add(chargeExtCycle);
            this.request.setAttribute("parkTemporaryChargeExtendByCycleList", temporaryChargeExtendCyleList);
        } else {
            ArrayList<ParkTemporaryChargeExtendItem> temporaryChargeExtendTimeList = new ArrayList<ParkTemporaryChargeExtendItem>();
            ParkTemporaryChargeExtendItem chargeExtTime = new ParkTemporaryChargeExtendItem();
            temporaryChargeExtendTimeList.add(chargeExtTime);
            this.request.setAttribute("parkTemporaryChargeExtendByTimeList", temporaryChargeExtendTimeList);
            this.request.setAttribute("parkTemporaryChargeExtendByCycleList", (Object)parkTemporaryChargeExtendList);
        }
        return new ModelAndView("park/temporaryCharge/editParkTemporaryCharge");
    }

    @RequiresPermissions(value={"park:temporaryCharge:edit"})
    @LogRequest(module="park_module", object="park_temporaryCharge", opType="park_temporaryCharge_edit", requestParams={"name"}, opContent="park_temporaryCharge_name")
    public ZKResultMsg save(ParkTemporaryChargeItem item) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemtList = this.parkTemporaryChargeService.saveItem(item);
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemtList));
        String isTestSubmit = this.request.getParameter("isTestSubmit");
        if ("true".equals(isTestSubmit)) {
            res.setRet("isTestSubmit");
            res.setMsg(item.getId());
        }
        return res;
    }

    @RequiresPermissions(value={"park:temporaryCharge:refresh"})
    public DxGrid list(ParkTemporaryChargeItem codition) {
        Pager pager = this.parkTemporaryChargeService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="park_module", object="park_temporaryCharge", opType="park_temporaryCharge_del", requestParams={"names"}, opContent="park_temporaryCharge_del")
    @RequiresPermissions(value={"park:temporaryCharge:del"})
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkTemporaryChargeService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg testTemporaryCharge(String carTypeId, String checkInTime, String checkOutTime) {
        ParkChargingResults result = this.parkTemporaryChargeService.testTemporaryCharge(carTypeId, checkInTime, checkOutTime);
        return new ZKResultMsg((Object)result);
    }
}

