/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.remote.ParkReleaseReasonRemote;
import com.zkteco.zkbiosecurity.park.service.ParkReleaseReasonService;
import com.zkteco.zkbiosecurity.park.vo.ParkReleaseReasonItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkReleaseReasonController
extends BaseController
implements ParkReleaseReasonRemote {
    @Autowired
    private ParkReleaseReasonService parkReleaseReasonService;

    @RequiresPermissions(value={"park:releaseReason"})
    public ModelAndView index() {
        return new ModelAndView("park/releaseReason/parkReleaseReason");
    }

    @RequiresPermissions(value={"park:releaseReason:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.parkReleaseReasonService.getItemById(id));
        }
        return new ModelAndView("park/releaseReason/editParkReleaseReason");
    }

    @RequiresPermissions(value={"park:releaseReason:edit"})
    @LogRequest(module="park_module", object="park_releaseReason", opType="park_releaseReason_edit", requestParams={"name"}, opContent="park_releaseReason_name")
    public ZKResultMsg save(ParkReleaseReasonItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.parkReleaseReasonService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"park:releaseReason:refresh"})
    public DxGrid list(ParkReleaseReasonItem codition) {
        Pager pager = this.parkReleaseReasonService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="park_module", object="park_releaseReason", opType="park_releaseReason_del", requestParams={"names"}, opContent="park_releaseReason_del")
    @RequiresPermissions(value={"park:releaseReason:del"})
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkReleaseReasonService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getAllReleaseReason() {
        List selectItems = this.parkReleaseReasonService.getAllReleaseReason();
        return new ZKResultMsg((Object)selectItems);
    }
}

