/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.remote.ParkFixedChargeRemote;
import com.zkteco.zkbiosecurity.park.service.ParkFixedChargeService;
import com.zkteco.zkbiosecurity.park.vo.ParkFixedChargeItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkFixedChargeController
extends BaseController
implements ParkFixedChargeRemote {
    @Autowired
    private ParkFixedChargeService parkFixedChargeService;

    @RequiresPermissions(value={"park:fixedCharge"})
    public ModelAndView index() {
        return new ModelAndView("park/fixedCharge/parkFixedCharge");
    }

    @RequiresPermissions(value={"park:fixedCharge:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.parkFixedChargeService.getItemById(id));
        }
        return new ModelAndView("park/fixedCharge/editParkFixedCharge");
    }

    @RequiresPermissions(value={"park:fixedCharge:edit"})
    @LogRequest(module="park_module", object="park_fixedVehicle", opType="park_fixedVehicle_edit", requestParams={"name"}, opContent="park_fixedVehicle_name")
    public ZKResultMsg save(ParkFixedChargeItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.parkFixedChargeService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"park:fixedCharge:refresh"})
    public DxGrid list(ParkFixedChargeItem codition) {
        Pager pager = this.parkFixedChargeService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"park:fixedCharge:del"})
    @LogRequest(module="park_module", object="park_fixedVehicle", opType="park_fixedVehicle_del", requestParams={"names"}, opContent="park_fixedVehicle_del")
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkFixedChargeService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getByCarTypeId(@RequestParam(value="carTypeId") String carTypeId) {
        List selectItems = this.parkFixedChargeService.getByCarTypeId(carTypeId);
        return new ZKResultMsg((Object)selectItems);
    }

    public boolean isNotExist(@RequestParam(value="name", required=false) String name) {
        return this.parkFixedChargeService.isNotExist(name);
    }
}

