/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="POSID_WALLET t left join POSID_ACCOUNT p on p.ID = t.ACCOUNT_ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=260, winWidth=373, operates={})
public class PosIDWalletItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.NAME")
    @GridColumn(label="common_name", width="160")
    private String name;
    @Column(name="t.BALANCE")
    @GridColumn(label="posid_card_blance", width="160", columnType="custom", convert="convertFen2Yuan")
    private Integer balance;
    @Column(name="p.ID")
    @GridColumn(label="posid_leftMenu_cardManage", show=false)
    private String posAccountId;
    @Column(name="p.PERSON_PIN")
    @GridColumn(label="pers_person_pin", width="100")
    private String personPin;
    @Column(name="p.PERSON_NAME")
    @GridColumn(label="pers_person_name", width="100")
    private String personName;
    @Column(name="p.PERSON_LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="80", showExpression="#language!='zh_CN'")
    private String personLastName;
    @Column(name="p.ACCOUNT_NO")
    @GridColumn(label="posid_card_accountNum", width="120")
    private String accountNo;
    @Column(name="p.IS_VALID")
    @GridColumn(label="posid_card_isValid", format="0=common_enable,1=common_disable,")
    private Integer isValid;
    @Condition(value="t.ID", equalTag="not in")
    private String notInId;
    @Condition(value="(p.PERSON_NAME LIKE ''%{0}%'' OR p.PERSON_LAST_NAME LIKE ''%{0}%'')")
    private String likeName;
    @Condition(value="p.DEPT_ID", equalTag="in")
    private String inDeptId;

    public PosIDWalletItem() {
    }

    public PosIDWalletItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Integer getBalance() {
        return this.balance;
    }

    public String getPosAccountId() {
        return this.posAccountId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getAccountNo() {
        return this.accountNo;
    }

    public Integer getIsValid() {
        return this.isValid;
    }

    public String getNotInId() {
        return this.notInId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public PosIDWalletItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDWalletItem setName(String name) {
        this.name = name;
        return this;
    }

    public PosIDWalletItem setBalance(Integer balance) {
        this.balance = balance;
        return this;
    }

    public PosIDWalletItem setPosAccountId(String posAccountId) {
        this.posAccountId = posAccountId;
        return this;
    }

    public PosIDWalletItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PosIDWalletItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PosIDWalletItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public PosIDWalletItem setAccountNo(String accountNo) {
        this.accountNo = accountNo;
        return this;
    }

    public PosIDWalletItem setIsValid(Integer isValid) {
        this.isValid = isValid;
        return this;
    }

    public PosIDWalletItem setNotInId(String notInId) {
        this.notInId = notInId;
        return this;
    }

    public PosIDWalletItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public PosIDWalletItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public String toString() {
        return "PosIDWalletItem(id=" + this.getId() + ", name=" + this.getName() + ", balance=" + this.getBalance() + ", posAccountId=" + this.getPosAccountId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", accountNo=" + this.getAccountNo() + ", isValid=" + this.getIsValid() + ", notInId=" + this.getNotInId() + ", likeName=" + this.getLikeName() + ", inDeptId=" + this.getInDeptId() + ")";
    }
}

