/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.aop;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.service.BaseService;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.SpringContextUtil;
import com.zkteco.zkbiosecurity.core.utils.WebContextUtil;
import com.zkteco.zkbiosecurity.system.service.BaseOpLogService;
import com.zkteco.zkbiosecurity.system.vo.BaseOpLogItem;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class OpLogChangeAspect {
    @Autowired
    BaseOpLogService baseOpLogService;

    @Around(value="@annotation(logChangeRequest)")
    public Object doInterceptor(ProceedingJoinPoint pjp, LogChangeRequest logChangeRequest) throws Throwable {
        long startTime = System.currentTimeMillis();
        Object result = null;
        BaseOpLogItem log = new BaseOpLogItem();
        short opResult = 0;
        try {
            if (WebContextUtil.getCurrentRequest() != null) {
                HttpServletRequest httpServletRequest = WebContextUtil.getCurrentRequest();
                String ip = httpServletRequest.getHeader("X-Forwarded-For");
                if (StringUtils.isBlank((CharSequence)ip)) {
                    ip = httpServletRequest.getRemoteAddr();
                }
                log.setOpIp(ip);
                SecuritySubject securitySubject = this.baseOpLogService.getCurrentUser(httpServletRequest.getSession().getId());
                if (securitySubject != null) {
                    log.setOpUserId(securitySubject.getUserId());
                    log.setOpUsername(securitySubject.getUserCode());
                } else if (httpServletRequest.getRequestURI().contains("login.do")) {
                    log.setOpUsername(httpServletRequest.getParameter("username"));
                }
                log.setOpSys(I18nUtil.i18nCode((String)logChangeRequest.module(), (Object[])new Object[0]));
                log.setOpObject(I18nUtil.i18nCode((String)logChangeRequest.object(), (Object[])new Object[0]));
                log.setOpType(I18nUtil.i18nCode((String)logChangeRequest.opType(), (Object[])new Object[0]));
                log.setOpTime(new Date());
                this.setContent(log, logChangeRequest, httpServletRequest);
            }
            result = pjp.proceed();
        }
        catch (Exception e) {
            if (e instanceof ZKBusinessException) {
                String msg = I18nUtil.i18nCode((String)e.getMessage(), (Object[])new Object[0]);
                ZKBusinessException ee = (ZKBusinessException)e;
                if (Objects.nonNull(ee.getObjects())) {
                    msg = String.format(msg, ee.getObjects());
                }
                log.setContent(msg);
            } else {
                log.setContent(e.getMessage());
            }
            opResult = 1;
            log.setOpResult(Short.valueOf(opResult));
            throw e;
        }
        finally {
            log.setOpResult(Short.valueOf(opResult));
            log.setCostTime(Integer.valueOf((int)(System.currentTimeMillis() - startTime)));
            this.baseOpLogService.saveItem(log);
        }
        return result;
    }

    private void setContent(BaseOpLogItem log, LogChangeRequest logRequest, HttpServletRequest httpServletRequest) {
        try {
            Object oldItem = null;
            String id = httpServletRequest.getParameter("id");
            if (StringUtils.isNotBlank((CharSequence)id)) {
                BaseService service = (BaseService)SpringContextUtil.getBean((Class)logRequest.service());
                if (service != null) {
                    String[] condition = (String[])logRequest.vo().newInstance();
                    MethodUtils.invokeMethod((Object)condition, (String)"setId", (Object[])new Object[]{id});
                    Pager page = service.getItemsByPage((BaseItem)condition, 0, 100);
                    if (page.getData() != null && page.getData().size() > 0) {
                        oldItem = page.getData().get(0);
                    }
                }
            } else {
                oldItem = logRequest.vo().newInstance();
            }
            JSONObject map = new JSONObject();
            if (oldItem != null) {
                if (logRequest.fields().length > 0) {
                    for (String fieldName : logRequest.fields()) {
                        Field field = logRequest.vo().getField(fieldName);
                        this.compareField(field, oldItem, httpServletRequest, map);
                    }
                } else {
                    Field[] fields;
                    for (Field field : fields = logRequest.vo().getDeclaredFields()) {
                        if (Modifier.isStatic(field.getModifiers())) continue;
                        this.compareField(field, oldItem, httpServletRequest, map);
                    }
                }
            }
            log.setContent(this.formatContent(logRequest.format(), map));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String formatContent(String format, JSONObject map) {
        if (StringUtils.isNotBlank((CharSequence)format)) {
            // empty if block
        }
        return map.toJSONString();
    }

    private String compareField(Field field, Object item, HttpServletRequest httpServletRequest, JSONObject map) throws Exception {
        String ret = "";
        String dist = httpServletRequest.getParameter(field.getName());
        if (field != null && dist != null) {
            field.setAccessible(true);
            Object value = field.get(item);
            if (value == null) {
                ret = "null -> " + dist;
            } else if (value instanceof String && !value.toString().equals(dist)) {
                ret = value + " -> " + dist;
            } else if (value instanceof Integer && (Integer)value != Integer.parseInt(dist)) {
                ret = value + " -> " + dist;
            } else if (value instanceof Byte && (Byte)value != Byte.parseByte(dist)) {
                ret = value + " -> " + dist;
            } else if (value instanceof Long && (Long)value != Long.parseLong(dist)) {
                ret = value + " -> " + dist;
            } else if (value instanceof Double && (Double)value != Double.parseDouble(dist)) {
                ret = value + " -> " + dist;
            } else if (value instanceof Float && ((Float)value).floatValue() != Float.parseFloat(dist)) {
                ret = value + " -> " + dist;
            } else if (value instanceof Character && !dist.equals(value)) {
                ret = value + " -> " + dist;
            } else if (value instanceof Short && (Short)value != Short.parseShort(dist)) {
                ret = value + " -> " + dist;
            } else if (value instanceof Boolean && (Boolean)value != Boolean.parseBoolean(dist)) {
                ret = value + " -> " + dist;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)ret)) {
            GridColumn gridColumn = field.getAnnotation(GridColumn.class);
            if (gridColumn != null && StringUtils.isNotBlank((CharSequence)gridColumn.label())) {
                map.put(I18nUtil.i18nCode((String)gridColumn.label(), (Object[])new Object[0]), (Object)ret);
            } else {
                map.put(field.getName(), (Object)ret);
            }
        }
        return ret;
    }
}

