/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pos.remote.PosKeyValueRemote;
import com.zkteco.zkbiosecurity.pos.service.PosKeyValueService;
import com.zkteco.zkbiosecurity.pos.vo.PosKeyValueItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosKeyValueController
extends BaseController
implements PosKeyValueRemote {
    @Autowired
    private PosKeyValueService posKeyValueService;

    @RequiresPermissions(value={"pos:keyValue"})
    public ModelAndView index() {
        return new ModelAndView("pos/keyValue/posKeyValue");
    }

    @RequiresPermissions(value={"pos:keyValue:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.posKeyValueService.getItemById(id));
        }
        return new ModelAndView("pos/keyValue/editPosKeyValue");
    }

    @RequiresPermissions(value={"pos:keyValue:edit"})
    @LogRequest(module="pos_module", object="pos_dev_keyValue", opType="common_op_edit", requestParams={"code"}, opContent="pos_keyValue_code")
    public ZKResultMsg save(PosKeyValueItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.posKeyValueService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"pos:keyValue:refresh"})
    public DxGrid list(PosKeyValueItem codition) {
        Pager pager = this.posKeyValueService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }
}

