/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.led.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.led.remote.LedDeviceRemote;
import com.zkteco.zkbiosecurity.led.service.LedDeviceBlockService;
import com.zkteco.zkbiosecurity.led.service.LedDeviceOpService;
import com.zkteco.zkbiosecurity.led.service.LedDeviceService;
import com.zkteco.zkbiosecurity.led.service.LedLayoutModelService;
import com.zkteco.zkbiosecurity.led.vo.LedDeviceItem;
import com.zkteco.zkbiosecurity.led.vo.LedLayoutModelItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class LedDeviceController
extends BaseController
implements LedDeviceRemote {
    @Autowired
    private LedDeviceService ledDeviceService;
    @Autowired
    private LedDeviceOpService ledDeviceOpService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private LedDeviceBlockService ledDeviceBlockService;
    @Autowired
    private LedLayoutModelService ledLayoutModelService;

    @RequiresPermissions(value={"led:device"})
    public ModelAndView index() {
        return new ModelAndView("led/device/ledDevice");
    }

    @RequiresPermissions(value={"led:device:edit", "led:device:add"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        List ledLayoutModelItemList = this.ledLayoutModelService.getByCondition(new LedLayoutModelItem());
        this.request.setAttribute("ledLayoutModelList", (Object)ledLayoutModelItemList);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.ledDeviceService.getItemById(id));
            List blockItemList = this.ledDeviceBlockService.findItemByLedDeviceId(id);
            JSONArray blockLayoutJsonArray = JSONArray.parseArray((String)JSON.toJSONString((Object)blockItemList));
            this.request.setAttribute("blockLayoutJsonArray", (Object)blockLayoutJsonArray.toString());
        }
        return new ModelAndView("led/device/editLedDevice");
    }

    @RequiresPermissions(value={"led:device:edit", "led:device:add"})
    @LogRequest(module="base_module", object="docking_led_equipment", opType="common_op_edit", requestParams={"name", "ip"}, opContent="docking_led_name")
    public ZKResultMsg save(LedDeviceItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String blockLayout = this.request.getParameter("blockLayoutJson");
        String blockIdList = this.request.getParameter("blockIdList");
        String isDelData = this.request.getParameter("isDelData");
        String model = this.request.getParameter("model");
        HashMap<String, String> deviceInfoMap = new HashMap<String, String>();
        deviceInfoMap.put("blockLayout", blockLayout);
        deviceInfoMap.put("blockIdList", blockIdList);
        deviceInfoMap.put("isDelData", isDelData);
        deviceInfoMap.put("model", model);
        res = this.ledDeviceService.saveLedItem(item, deviceInfoMap);
        if ("ok".equals(res.getRet())) {
            item = (LedDeviceItem)res.getData();
            this.ledDeviceOpService.syncDataToDev(item.getId());
        }
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"led:device:refresh"})
    public DxGrid list(LedDeviceItem condition) {
        Pager pager = this.ledDeviceService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"led:device:del"})
    @LogRequest(module="base_module", object="docking_led_equipment", opType="common_op_del", requestParams={"names", "ips"}, opContent="docking_led_name")
    public ZKResultMsg del(String ids) {
        ZKResultMsg msg = new ZKResultMsg();
        boolean res = this.ledDeviceService.deleteByIds(ids);
        if (!res) {
            msg.setRet("fail");
            msg.setMsg("docking_message_deviceNotDel");
        }
        return I18nUtil.i18nMsg((ZKResultMsg)msg);
    }

    public String validIp(@RequestParam(value="ip") String ip) {
        LedDeviceItem item = this.ledDeviceService.getItemByIp(ip);
        boolean rs = item == null;
        return rs + "";
    }

    public void getLedBlockTree() {
        String blockCount = this.request.getParameter("blockCount");
        String title = this.request.getParameter("title");
        String isShowTime = this.request.getParameter("isShowTime");
        try {
            if (StringUtils.isNotBlank((CharSequence)blockCount)) {
                boolean addArea = false;
                JSONArray proTree = new JSONArray();
                JSONArray jsonArr = new JSONArray();
                JSONObject subArea = new JSONObject();
                JSONObject titleJson = new JSONObject();
                JSONObject sysTimeJson = new JSONObject();
                if (StringUtils.isNotBlank((CharSequence)title)) {
                    titleJson.put("id", (Object)"pro_title");
                    titleJson.put("text", (Object)I18nUtil.i18nCode((String)"docking_led_blockTitle", (Object[])new Object[0]));
                    titleJson.put("im0", (Object)"leaf.gif");
                    jsonArr.add((Object)titleJson);
                }
                subArea.put("item", (Object)jsonArr);
                for (int i = 1; i < Integer.parseInt(blockCount) + 1; ++i) {
                    JSONObject devJson = new JSONObject();
                    devJson.put("id", (Object)("pro_" + i));
                    devJson.put("text", (Object)(I18nUtil.i18nCode((String)"docking_led_block", (Object[])new Object[0]) + i));
                    devJson.put("im0", (Object)"leaf.gif");
                    subArea.getJSONArray("item").add((Object)devJson);
                    addArea = true;
                }
                if ("1".equals(isShowTime)) {
                    sysTimeJson.put("id", (Object)"pro_time");
                    sysTimeJson.put("text", (Object)I18nUtil.i18nCode((String)"docking_led_blockTime", (Object[])new Object[0]));
                    sysTimeJson.put("im0", (Object)"leaf.gif");
                    subArea.getJSONArray("item").add((Object)sysTimeJson);
                }
                if (addArea) {
                    subArea.put("id", (Object)"program");
                    subArea.put("text", (Object)I18nUtil.i18nCode((String)"docking_led_bloProgram", (Object[])new Object[0]));
                    subArea.put("im0", (Object)"folderOpen.gif");
                    subArea.put("im1", (Object)"folderOpen.gif");
                    subArea.put("im2", (Object)"folderOpen.gif");
                    subArea.put("open", (Object)1);
                    proTree.add((Object)subArea);
                } else if (!subArea.containsKey((Object)"item")) {
                    proTree = subArea.getJSONArray("item");
                }
                JSONObject proJson = new JSONObject();
                proJson.put("id", (Object)0);
                if (proTree.size() > 0) {
                    proJson.put("item", (Object)proTree);
                } else {
                    JSONObject parentJson = new JSONObject();
                    parentJson.put("id", (Object)"_");
                    parentJson.put("im0", (Object)"folderOpen.gif");
                    parentJson.put("text", (Object)I18nUtil.i18nCode((String)"docking_led_bloProgram", (Object[])new Object[0]));
                    proJson.put("item", (Object)new JSONArray().add((Object)parentJson));
                }
                this.response.getWriter().write(proJson.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ZKResultMsg blockLayoutTest() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String blockLayout = this.request.getParameter("blockLayout");
        if (StringUtils.isNotBlank((CharSequence)blockLayout)) {
            LedDeviceItem item = new LedDeviceItem();
            item.setIp(this.request.getParameter("ip"));
            item.setPort(this.request.getParameter("port"));
            item.setIdCode(this.request.getParameter("idCode"));
            item.setShowTime(Boolean.valueOf("1".equals(this.request.getParameter("isShowTime"))));
            item.setScreenWidth(Short.valueOf(Short.parseShort(this.request.getParameter("screenWidth"))));
            item.setScreenHeight(Short.valueOf(Short.parseShort(this.request.getParameter("screenHeight"))));
            item.setTitle(this.request.getParameter("title"));
            zkResultMsg = this.ledDeviceService.blockLayoutTest(item, blockLayout);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequiresPermissions(value={"led:device:syncAllData"})
    public ModelAndView getDevIdsBySyncData(String ids) {
        List devList = this.ledDeviceService.getItemByIds(ids);
        StringBuffer devName = new StringBuffer("");
        StringBuffer disabledDevName = new StringBuffer("");
        StringBuffer devIps = new StringBuffer("");
        LedDeviceItem dev = null;
        StringBuffer retIds = new StringBuffer();
        int len = devList.size();
        for (int i = 0; i < len; ++i) {
            dev = (LedDeviceItem)devList.get(i);
            if (dev.getEnabled().booleanValue()) {
                retIds.append(dev.getId()).append(",");
                devName.append(dev.getName() + ",");
                devIps.append(dev.getIp() + ",");
                continue;
            }
            disabledDevName.append(dev.getName() + ",");
        }
        this.request.setAttribute("devIds", retIds.length() > 0 ? retIds.substring(0, retIds.length() - 1) : null);
        this.request.setAttribute("devicesName", devName.length() > 0 ? devName.substring(0, devName.length() - 1) : null);
        this.request.setAttribute("disabledDevName", disabledDevName.length() > 0 ? disabledDevName.substring(0, disabledDevName.length() - 1) : null);
        this.request.setAttribute("devIps", devIps.length() > 0 ? devIps.substring(0, devIps.length() - 1) : null);
        return new ModelAndView("led/device/opLedSyncAllData");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"led:device:syncAllData"})
    @LogRequest(module="base_module", object="docking_led_equipment", opType="common_dev_syncAllDataToDev", requestParams={"names", "ips"}, opContent="docking_led_name")
    public ZKResultMsg syncAllData(String devIds) {
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            List devItemList = this.ledDeviceService.getItemByIds(devIds);
            int size = devItemList.size();
            for (int i = 0; i < size; ++i) {
                LedDeviceItem devItem = (LedDeviceItem)devItemList.get(i);
                int total = (int)((float)(i + 1) / (float)size * 100.0f);
                int lastTotal = (int)(((double)i + 0.3) / (double)size * 100.0);
                if (devItem.getEnabled().booleanValue() && this.ledDeviceOpService.checkController(devItem)) {
                    this.progressCache.setProcess(new ProcessBean(30, lastTotal, devItem.getName() + ":" + I18nUtil.i18nCode((String)"common_dev_syncPrompt", (Object[])new Object[0]) + "<br/>"));
                    this.ledDeviceOpService.syncDataToDev(devItem.getId());
                    this.progressCache.setProcess(new ProcessBean(100, total, devItem.getName() + ":" + I18nUtil.i18nCode((String)"common_dev_syncSuccess", (Object[])new Object[0]) + "<br/>"));
                    continue;
                }
                this.progressCache.setProcess(new ProcessBean(100, total, devItem.getName() + ":" + I18nUtil.i18nCode((String)"docking_led_syncFaile", (Object[])new Object[0]) + "<br/>"));
            }
        }
        catch (Exception e) {
            this.log.error("exception", (Throwable)e);
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
        }
        return null;
    }

    @RequiresPermissions(value={"led:device:enable"})
    @LogRequest(module="base_module", object="docking_led_equipment", opType="common_enable", requestParams={"names", "ips"}, opContent="docking_led_name")
    public ZKResultMsg setDevEnable(String ids) {
        this.ledDeviceService.enableOrDisableDev(true, ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"led:device:disable"})
    @LogRequest(module="base_module", object="docking_led_equipment", opType="common_disable", requestParams={"names", "ips"}, opContent="docking_led_name")
    public ZKResultMsg setDevDisable(String ids) {
        this.ledDeviceService.enableOrDisableDev(false, ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"led:device:reboot"})
    @LogRequest(module="base_module", object="docking_led_equipment", opType="docking_led_reboot", requestParams={"names", "ips"}, opContent="docking_led_name")
    public ZKResultMsg rebootDevice(String ids) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        StringBuffer offLine = new StringBuffer("");
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            List devItemList = this.ledDeviceService.getItemByIds(ids);
            for (LedDeviceItem devItem : devItemList) {
                if (devItem.getEnabled().booleanValue() && this.ledDeviceOpService.checkController(devItem)) {
                    this.ledDeviceOpService.restartDev(devItem);
                    continue;
                }
                offLine.append(devItem.getName() + ",");
                zkResultMsg.setRet("fail");
            }
            if ("fail".equals(zkResultMsg.getRet())) {
                offLine.append(I18nUtil.i18nCode((String)"common_dev_offlinePrompt", (Object[])new Object[0]));
                zkResultMsg.setMsg(offLine.toString());
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequiresPermissions(value={"led:device:updateIpAddr"})
    public ModelAndView getDevIPAddressInfo(@RequestParam(value="id", required=false) String id, @RequestParam(value="type") String type) {
        return this.getById(id, type);
    }

    @RequiresPermissions(value={"led:device:customData"})
    public ModelAndView getDevCustomDataInfo(@RequestParam(value="id", required=false) String id, @RequestParam(value="type") String type) {
        return this.getById(id, type);
    }

    @RequiresPermissions(value={"led:device:updateIpAddr"})
    @LogRequest(module="base_module", object="docking_led_equipment", opType="common_dev_modifyIPAddress", requestParams={"ip"}, opContent="docking_led_deviceIp")
    public ZKResultMsg updateIpAddr(LedDeviceItem item) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        LedDeviceItem oldItem = this.ledDeviceService.getItemById(item.getId());
        if (this.ledDeviceOpService.checkController(oldItem)) {
            if (!oldItem.getEnabled().booleanValue()) {
                zkResultMsg.setRet("fail");
                zkResultMsg.setMsg("docking_led_devNotOpForDisable");
            } else {
                zkResultMsg = this.ledDeviceService.updateIpAddr(item);
            }
        } else {
            zkResultMsg.setRet("fail");
            zkResultMsg.setMsg("docking_led_CommWarning");
        }
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    private ModelAndView getById(String id, String type) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.ledDeviceService.getItemById(id));
            this.request.setAttribute("editPage", (Object)true);
            if (StringUtils.isNotBlank((CharSequence)type)) {
                if ("updateIpAddr".equals(type)) {
                    return new ModelAndView("led/device/opLedUpdateIpAddr");
                }
                if ("customData".equals(type)) {
                    List ledDeviceBlocks = this.ledDeviceBlockService.findSendDateBlockByDevId(id);
                    this.request.setAttribute("ledDeviceBlocks", (Object)ledDeviceBlocks);
                    return new ModelAndView("led/device/editLedCustomData");
                }
            }
        }
        return null;
    }

    @RequiresPermissions(value={"led:device:customData"})
    @LogRequest(module="base_module", object="docking_led_equipment", opType="docking_led_customData", requestParams={"name", "ip"}, opContent="docking_led_name")
    public ZKResultMsg customData(LedDeviceItem item) {
        this.ledDeviceService.customData(item);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

