/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.client;

import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import com.zkteco.zkbiosecurity.posid.service.PosIDAccountService;
import com.zkteco.zkbiosecurity.posid.service.PosIDPayOrderService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDPayOrderItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDTransactionCardItem;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PosIDPayResult {
    @Autowired
    private PosIDAccountService posIDAccountService;
    @Autowired
    private PosIDPayOrderService posIDPayOrderService;

    public ZKResultMsg payResult(ZKMessage zkMessage) {
        Map map = zkMessage.getContent();
        String mchOrderNo = (String)map.get("mchOrderNo");
        String channelOrderNo = (String)map.get("channelOrderNo");
        PosIDPayOrderItem item = this.posIDPayOrderService.findById(mchOrderNo);
        if (null == item) {
            return ZKResultMsg.failMsg();
        }
        if (item.getStatus() == 3) {
            return ZKResultMsg.successMsg();
        }
        item.setOrderNo(channelOrderNo);
        item.setStatus(Integer.valueOf(2));
        this.posIDPayOrderService.updatePayOrderStatus(item, 0);
        PosIDTransactionCardItem posIDTransactionCardItem = this.posIDAccountService.nativeTopUp(item.getPin(), item.getAmount(), Integer.valueOf(item.getPayType() == 1 ? 2 : 3), item.getConfigureCode());
        item.setPayOrderId(posIDTransactionCardItem.getId());
        item.setStatus(Integer.valueOf(3));
        this.posIDPayOrderService.updatePayOrderStatus(item, 2);
        return ZKResultMsg.successMsg();
    }
}

