/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pos.remote.PosSplitTimeRemote;
import com.zkteco.zkbiosecurity.pos.service.PosSplitTimeService;
import com.zkteco.zkbiosecurity.pos.vo.PosSplitTimeItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosSplitTimeController
extends BaseController
implements PosSplitTimeRemote {
    @Autowired
    private PosSplitTimeService posSplitTimeService;

    @RequiresPermissions(value={"pos:splitTime"})
    public ModelAndView index() {
        return new ModelAndView("pos/splitTime/posSplitTime");
    }

    @RequiresPermissions(value={"pos:splitTime:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.posSplitTimeService.getItemById(id));
        }
        return new ModelAndView("pos/splitTime/editPosSplitTime");
    }

    @RequiresPermissions(value={"pos:splitTime:edit"})
    @LogRequest(module="pos_module", object="pos_leftMenu_splitTime", opType="common_op_new", requestParams={"name"}, opContent="pos_splitTime_name")
    public ZKResultMsg save(PosSplitTimeItem item) {
        ZKResultMsg res = new ZKResultMsg();
        boolean oldIsValid = Boolean.parseBoolean(this.request.getParameter("oldIsValid"));
        this.posSplitTimeService.saveItem(item, oldIsValid);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"pos:splitTime:refresh"})
    public DxGrid list(PosSplitTimeItem codition) {
        Pager pager = this.posSplitTimeService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"pos:splitTime:del"})
    @LogRequest(module="pos_module", object="pos_leftMenu_splitTime", opType="common_op_del", requestParams={"ids"}, opContent="pos_common_id")
    public ZKResultMsg delete(String ids) {
        this.posSplitTimeService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg checkSplitTimeseg() {
        String id = this.request.getParameter("splitTimeId");
        String startStr = this.request.getParameter("startTime");
        String endStr = this.request.getParameter("endTime");
        boolean valid = Boolean.parseBoolean(this.request.getParameter("isValid"));
        return this.posSplitTimeService.checkTimeseg(id, startStr, endStr, valid);
    }
}

