/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.util;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.SpringUtil;
import com.zkteco.zkbiosecurity.sis.service.SisTipPicService;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;

public class SicmDataUtil {
    private static final Logger logger = Logger.getLogger(SicmDataUtil.class);
    private SisTipPicService sisTipPicService = (SisTipPicService)SpringUtil.getBean(SisTipPicService.class);

    public static byte[] intToBytes(int value) {
        byte[] src = new byte[4];
        src[3] = (byte)(value >> 24 & 0xFF);
        src[2] = (byte)(value >> 16 & 0xFF);
        src[1] = (byte)(value >> 8 & 0xFF);
        src[0] = (byte)(value & 0xFF);
        return src;
    }

    public static int bytesToInt(byte[] src, int offset) {
        int value = src[offset] & 0xFF | (src[offset + 1] & 0xFF) << 8 | (src[offset + 2] & 0xFF) << 16 | (src[offset + 3] & 0xFF) << 24;
        return value;
    }

    public static int bytes2int(byte[] bytes) {
        int result = 0;
        if (bytes.length == 4) {
            int a = (bytes[0] & 0xFF) << 24;
            int b = (bytes[1] & 0xFF) << 16;
            int c = (bytes[2] & 0xFF) << 8;
            int d = bytes[3] & 0xFF;
            result = a | b | c | d;
        }
        return result;
    }

    public static int getJsonLength(JSONObject jsonData) throws UnsupportedEncodingException {
        return jsonData.toString().getBytes("UTF-8").length;
    }

    public static int getStringLength(String jsonStr) throws UnsupportedEncodingException {
        return jsonStr.getBytes("UTF-8").length;
    }

    public static byte[] byteMerger(byte[] bt1, byte[] bt2) {
        byte[] bt3 = new byte[bt1.length + bt2.length];
        System.arraycopy(bt1, 0, bt3, 0, bt1.length);
        System.arraycopy(bt2, 0, bt3, bt1.length, bt2.length);
        return bt3;
    }

    public static ByteBuffer strToByteBuffer(String data, String encode) throws UnsupportedEncodingException {
        return ByteBuffer.wrap(data.getBytes(encode));
    }

    public static ByteBuffer jsonToByteBuffer(JSONObject jsonData) throws Exception {
        byte[] jsonLength = SicmDataUtil.intToBytes(SicmDataUtil.getJsonLength(jsonData));
        byte[] jsonDataArr = jsonData.toString().getBytes("UTF-8");
        byte[] retData = SicmDataUtil.byteMerger(jsonLength, jsonDataArr);
        return ByteBuffer.wrap(retData);
    }

    public static ByteBuffer strToByteBuffer(String jsonStr) throws Exception {
        byte[] jsonLength = SicmDataUtil.intToBytes(SicmDataUtil.getStringLength(jsonStr));
        byte[] jsonDataArr = jsonStr.getBytes("UTF-8");
        byte[] retData = SicmDataUtil.byteMerger(jsonLength, jsonDataArr);
        return ByteBuffer.wrap(retData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile() {
        byte[] tempBytes = null;
        FileInputStream fs = null;
        try {
            fs = new FileInputStream("E:\\images\\photo_22.jpg");
            byte[] content = new byte[fs.available()];
            fs.read(content);
            ByteBuffer byteBuffer = ByteBuffer.wrap(content);
            tempBytes = SicmDataUtil.bufferToByteArray(byteBuffer);
            System.out.println("----byte file length:" + tempBytes.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return tempBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(String fileName) {
        byte[] tempBytes = null;
        FileInputStream fs = null;
        try {
            fs = new FileInputStream("E:\\images\\" + fileName);
            byte[] content = new byte[fs.available()];
            fs.read(content);
            ByteBuffer byteBuffer = ByteBuffer.wrap(content);
            tempBytes = SicmDataUtil.bufferToByteArray(byteBuffer);
            System.out.println("----byte file length:" + tempBytes.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return tempBytes;
    }

    public static byte[] bufferToByteArray(ByteBuffer message) {
        byte[] bytes = null;
        try {
            bytes = new byte[message.remaining()];
            message.get(bytes, 0, bytes.length);
            message.clear();
            bytes = new byte[message.capacity()];
            message.get(bytes, 0, bytes.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveFileFromBytes(byte[] b, String outputFile) {
        FilterOutputStream stream = null;
        File file = null;
        try {
            file = new File(outputFile);
            FileOutputStream fstream = new FileOutputStream(file);
            stream = new BufferedOutputStream(fstream);
            stream.write(b);
            ((BufferedOutputStream)stream).flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return true;
    }

    public static boolean createFolder(String path) {
        try {
            File file = new File(path);
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static String createFileName(String sn, String type) {
        String fileName = "";
        try {
            fileName = fileName + sn + "_" + type + "_" + System.currentTimeMillis() + ".jpg";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileName;
    }

    public static int createRadom() {
        return (int)((Math.random() * 9.0 + 1.0) * 1.0E8);
    }

    public static byte hexToByte(String inHex) {
        return (byte)Integer.parseInt(inHex, 16);
    }

    public static byte[] hexToByteArray(String inHex) {
        byte[] result;
        int hexlen = inHex.length();
        if (hexlen % 2 == 1) {
            result = new byte[++hexlen / 2];
            inHex = "0" + inHex;
        } else {
            result = new byte[hexlen / 2];
        }
        int j = 0;
        for (int i = 0; i < hexlen; i += 2) {
            result[j] = SicmDataUtil.hexToByte(inHex.substring(i, i + 2));
            ++j;
        }
        return result;
    }

    public ByteBuffer responseTipPic(String id, JSONObject dataJson, String sn) {
        ByteBuffer buf = null;
        JSONObject tipRetJson = null;
        try {
            String tipId = dataJson.getString("tip_id");
            JSONObject subJson = new JSONObject();
            subJson.put("tip_id", (Object)tipId);
            tipRetJson = this.sisTipPicService.getTipDownloadInfo(subJson);
            logger.info((Object)("------------tipRetJson:" + tipRetJson));
            if (tipRetJson != null) {
                String fileName = tipRetJson.getString("file_name");
                String filePath = tipRetJson.getString("file_path");
                String type = tipRetJson.getString("type");
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("func", (Object)"tip.download.response");
                jsonObj.put("id", (Object)id);
                JSONObject jsonObj2 = new JSONObject();
                jsonObj2.put("tip_id", (Object)tipId);
                jsonObj2.put("type", (Object)type);
                jsonObj2.put("detail", (Object)"");
                jsonObj2.put("file_name", (Object)fileName);
                jsonObj.put("data", (Object)jsonObj2);
                logger.info((Object)("------------tip.download.response:" + jsonObj.toString()));
                byte[] jsonData = jsonObj.toString().getBytes("UTF-8");
                byte[] jsonLength = SicmDataUtil.intToBytes(SicmDataUtil.getJsonLength(jsonObj));
                byte[] textData = SicmDataUtil.byteMerger(jsonLength, jsonData);
                byte[] textData2 = null;
                textData2 = SicmDataUtil.byteMerger(textData, SicmDataUtil.readFileFromLocal(filePath));
                buf = ByteBuffer.wrap(textData2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileFromLocal(String fileName) {
        byte[] tempBytes = null;
        FileInputStream fs = null;
        try {
            String filePath = FileUtil.getLocalFullPath((String)fileName);
            fs = new FileInputStream(filePath);
            byte[] content = new byte[fs.available()];
            fs.read(content);
            ByteBuffer byteBuffer = ByteBuffer.wrap(content);
            tempBytes = SicmDataUtil.bufferToByteArray(byteBuffer);
            System.out.println("----byte file length:" + tempBytes.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return tempBytes;
    }
}

