/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.distributor;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.sis.service.SisDevCmdService;
import com.zkteco.zkbiosecurity.sis.service.SisDeviceService;
import com.zkteco.zkbiosecurity.sis.service.SisGateTransactionService;
import com.zkteco.zkbiosecurity.sis.vo.SisDeviceItem;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Order(value=112000)
public class SisRTGateDevDataMonitorServer
implements CommandLineRunner {
    Logger logger = Logger.getLogger(SisRTGateDevDataMonitorServer.class);
    @Autowired
    private SisGateTransactionService sisGateTransactionService;
    @Autowired
    private SisDeviceService sisDeviceService;
    @Autowired
    private SisDevCmdService sisDevCmdService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    public static final Map<String, DealGateDevRTLogThread> rtLogDealThreadMap = new ConcurrentHashMap<String, DealGateDevRTLogThread>();
    public static final Map<String, DealGateDevQueryLogThread> queryLogDealThreadMap = new ConcurrentHashMap<String, DealGateDevQueryLogThread>();
    private final long rtLogThreadMaxFreeTime = 600000L;
    private final long queryLogThreadMaxFreeTime = 600000L;
    private final long rtLogthreadMaxNotActiveTime = 60000L;
    public volatile boolean exit = false;

    public void run(String ... strings) throws Exception {
        new CheckGateDevRTLogQuene("checkGateDevRTLog").start();
        new CheckGateDevQueryLogQuene("checkGateDevQueryLog").start();
        new GetGateDevWorkInfoThread("getGateDevWorkInfo").start();
    }

    private void findBizEnterByEventType(JSONObject rtLogJson) {
        for (String devIp : rtLogJson.keySet()) {
            JSONObject logData = rtLogJson.getJSONObject(devIp);
            switch (logData.getString("func")) {
                case "gate.id": {
                    this.sisGateTransactionService.handleQueryId(devIp, logData);
                    break;
                }
                case "work.param": {
                    this.sisGateTransactionService.handleWorkParamRTLog(devIp, logData);
                    break;
                }
                case "alarm.light": {
                    System.out.println(">>>\u9875\u9762\u83b7\u53d6\u62a5\u8b66\u706f\u72b6\u6001\u3001<<<======" + logData);
                    this.sisGateTransactionService.handleAlarmLightRTLog(devIp, logData);
                    break;
                }
                case "system.param": {
                    this.sisGateTransactionService.handleReadSystemParam(devIp, logData);
                    break;
                }
                case "zone.sencitivity": {
                    this.sisGateTransactionService.handleReadZoneSencitivity(devIp, logData);
                    break;
                }
                case "gate.model": {
                    this.logger.info((Object)(">>>\u83b7\u53d6\u7248\u672c\u53f7<<<======" + logData));
                    this.sisGateTransactionService.handleModelVersion(logData);
                    break;
                }
                case "gate.heartbeat": {
                    this.logger.info((Object)(">>>\u5fc3\u8df3\u5305<<<======" + logData));
                    this.sisDevCmdService.dealHeartbeat(devIp, logData);
                }
            }
        }
    }

    class DealGateDevQueryLogThread
    extends Thread {
        public long threadLastActiveTime = System.currentTimeMillis();

        DealGateDevQueryLogThread(String threadName) {
            super.setName(threadName);
        }

        @Override
        public void run() {
            JSONObject queryLogJson = null;
            String rtLog = null;
            queryLogDealThreadMap.put(this.getName(), this);
            long activeTime = System.currentTimeMillis();
            block2: while (true) {
                try {
                    while (true) {
                        this.threadLastActiveTime = System.currentTimeMillis();
                        rtLog = (String)SisRTGateDevDataMonitorServer.this.stringRedisTemplate.opsForList().leftPop((Object)this.getName());
                        if (rtLog != null) {
                            activeTime = System.currentTimeMillis();
                            queryLogJson = JSONObject.parseObject((String)rtLog);
                            SisRTGateDevDataMonitorServer.this.findBizEnterByEventType(queryLogJson);
                            rtLog = null;
                            queryLogJson = null;
                            continue;
                        }
                        if (System.currentTimeMillis() - activeTime > 600000L) {
                            queryLogDealThreadMap.remove(this.getName());
                            break block2;
                        }
                        Thread.sleep(200L);
                    }
                }
                catch (Exception e) {
                    SisRTGateDevDataMonitorServer.this.logger.error((Object)("Exception DealGateDevQueryLogThread : " + this.getName() + "deal queryLog error"), (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    class DealGateDevRTLogThread
    extends Thread {
        public long threadLastActiveTime = System.currentTimeMillis();

        DealGateDevRTLogThread(String threadName) {
            super.setName(threadName);
        }

        @Override
        public void run() {
            JSONObject rtLogJson = null;
            String rtLog = null;
            rtLogDealThreadMap.put(this.getName(), this);
            long activeTime = System.currentTimeMillis();
            block2: while (true) {
                try {
                    while (true) {
                        this.threadLastActiveTime = System.currentTimeMillis();
                        rtLog = (String)SisRTGateDevDataMonitorServer.this.stringRedisTemplate.opsForList().leftPop((Object)this.getName());
                        if (rtLog != null) {
                            activeTime = System.currentTimeMillis();
                            rtLogJson = JSONObject.parseObject((String)rtLog);
                            SisRTGateDevDataMonitorServer.this.findBizEnterByEventType(rtLogJson);
                            rtLog = null;
                            rtLogJson = null;
                            continue;
                        }
                        if (System.currentTimeMillis() - activeTime > 600000L) {
                            rtLogDealThreadMap.remove(this.getName());
                            break block2;
                        }
                        Thread.sleep(200L);
                    }
                }
                catch (Exception e) {
                    SisRTGateDevDataMonitorServer.this.logger.error((Object)("Exception DealRTLogThread : " + this.getName() + "deal rtLog error"), (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    class CheckGateDevQueryLogQuene
    extends Thread {
        CheckGateDevQueryLogQuene(String threadName) {
            super.setName(threadName);
        }

        @Override
        public void run() {
            DealGateDevQueryLogThread currentThread = null;
            Set activeQueneNameSet = null;
            while (!SisRTGateDevDataMonitorServer.this.exit) {
                try {
                    if (!SisRTGateDevDataMonitorServer.this.stringRedisTemplate.hasKey((Object)"SIS_GATE_QUERYLOG_QUENE_NAME_SET").booleanValue()) continue;
                    activeQueneNameSet = SisRTGateDevDataMonitorServer.this.stringRedisTemplate.opsForSet().members((Object)"SIS_GATE_QUERYLOG_QUENE_NAME_SET");
                    for (String queneName : activeQueneNameSet) {
                        currentThread = queryLogDealThreadMap.get(queneName);
                        if ((currentThread != null || !SisRTGateDevDataMonitorServer.this.stringRedisTemplate.hasKey((Object)queneName).booleanValue()) && (currentThread == null || currentThread.isAlive() && System.currentTimeMillis() - currentThread.threadLastActiveTime <= 60000L)) continue;
                        new DealGateDevQueryLogThread(queneName).start();
                    }
                    Thread.sleep(300L);
                }
                catch (Exception e) {
                    SisRTGateDevDataMonitorServer.this.exit = true;
                    SisRTGateDevDataMonitorServer.this.logger.error((Object)("Exception CheckGateDevQueryLogQuene : " + this.getName() + "deal rtLog error"), (Throwable)e);
                    e.printStackTrace();
                }
            }
        }
    }

    class CheckGateDevRTLogQuene
    extends Thread {
        CheckGateDevRTLogQuene(String threadName) {
            super.setName(threadName);
        }

        @Override
        public void run() {
            DealGateDevRTLogThread currentThread = null;
            Set activeQueneNameSet = null;
            while (true) {
                try {
                    while (true) {
                        activeQueneNameSet = SisRTGateDevDataMonitorServer.this.stringRedisTemplate.opsForSet().members((Object)"SIS_GATE_RTLOG_QUENE_NAME_SET");
                        for (String queneName : activeQueneNameSet) {
                            currentThread = rtLogDealThreadMap.get(queneName);
                            if ((currentThread != null || !SisRTGateDevDataMonitorServer.this.stringRedisTemplate.hasKey((Object)queneName).booleanValue()) && (currentThread == null || currentThread.isAlive() && System.currentTimeMillis() - currentThread.threadLastActiveTime <= 60000L)) continue;
                            new DealGateDevRTLogThread(queneName).start();
                        }
                        Thread.sleep(3000L);
                    }
                }
                catch (Exception e) {
                    SisRTGateDevDataMonitorServer.this.logger.error((Object)("Exception CheckGateDevRTLogQuene : " + this.getName() + "deal rtLog error"), (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    class GetGateDevWorkInfoThread
    extends Thread {
        GetGateDevWorkInfoThread(String threadName) {
            super.setName(threadName);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        List devList;
                        if ((devList = SisRTGateDevDataMonitorServer.this.sisDeviceService.getAllGateDevice()).size() > 0) {
                            for (SisDeviceItem dev : devList) {
                                String status = (String)SisRTGateDevDataMonitorServer.this.stringRedisTemplate.opsForValue().get((Object)("SIS_GATE_DEVICE_STATUS_" + dev.getIp()));
                                if (!StringUtils.equals((CharSequence)"0", (CharSequence)status)) continue;
                                SisRTGateDevDataMonitorServer.this.sisDevCmdService.getDeviceWorkParams(dev);
                                SisRTGateDevDataMonitorServer.this.sisDevCmdService.getAlarmLight(dev);
                            }
                            Thread.sleep(2000L);
                            continue;
                        }
                        Thread.sleep(5000L);
                    }
                }
                catch (Exception e) {
                    SisRTGateDevDataMonitorServer.this.logger.error((Object)"exception", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

