/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccZonePersonRemote;
import com.zkteco.zkbiosecurity.acc.service.AccAdvancedPersonService;
import com.zkteco.zkbiosecurity.acc.service.AccZonePersonService;
import com.zkteco.zkbiosecurity.acc.vo.AccAdvancedSelectPersonItem;
import com.zkteco.zkbiosecurity.acc.vo.AccZonePersonItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccZonePersonController
extends ExportController
implements AccZonePersonRemote {
    @Autowired
    private AccZonePersonService accZonePersonService;
    @Autowired
    private AccAdvancedPersonService accAdvancedPersonService;

    @RequiresPermissions(value={"acc:zonePerson"})
    public ModelAndView index() {
        return new ModelAndView("acc/zonePerson/accZonePerson");
    }

    @LogRequest(module="acc_module", object="acc_zonePerson", opType="acc_zonePerson_edit", requestParams={"id"}, opContent="acc_zonePerson_id")
    public ZKResultMsg save(AccZonePersonItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.accZonePersonService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:zonePerson:refresh"})
    public DxGrid list(AccZonePersonItem codition) {
        if (StringUtils.isNotBlank((CharSequence)codition.getZoneId()) && codition.getZoneId().equals("total")) {
            codition.setZoneId(null);
        }
        Pager pager = this.accZonePersonService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:zonePerson:delPerson"})
    @LogRequest(module="acc_module", object="acc_leftMenu_whoIsInside", opType="pers_common_delPerson", requestParams={"personPins"}, opContent="pers_person_pin")
    public ZKResultMsg delPerson(String personPins) {
        this.accZonePersonService.delPerson(personPins);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:zonePerson:addPerson"})
    @LogRequest(module="acc_module", object="acc_leftMenu_whoIsInside", opType="pers_common_addPerson", requestParams={"personPins"}, opContent="pers_person_pin")
    public ZKResultMsg addPerson(String accZoneId, String accReaderId, String accPersonIds, String personWithDeptIds) {
        this.accZonePersonService.addPerson(accZoneId, accReaderId, accPersonIds, personWithDeptIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public DxGrid selectPersonlist(AccAdvancedSelectPersonItem condition) {
        Pager pager = new Pager();
        if (condition.getType().equals("noSelected")) {
            condition.setLinkId("ACC_ZONEPERSON");
            condition.setModelType("ACC_ZONEPERSON");
            pager = this.accAdvancedPersonService.getNoExistPerson(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"acc:zonePerson:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) throws InvocationTargetException, IllegalAccessException {
        AccZonePersonItem accZonePersonItem = new AccZonePersonItem();
        this.setConditionValue((BaseItem)accZonePersonItem);
        if ("total".equals(accZonePersonItem.getZoneId())) {
            accZonePersonItem.setZoneId(null);
        }
        List itemList = this.accZonePersonService.getItemData(AccZonePersonItem.class, (BaseItem)accZonePersonItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, AccZonePersonItem.class);
    }
}

