/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccReaderZoneRemote;
import com.zkteco.zkbiosecurity.acc.service.AccReaderZoneService;
import com.zkteco.zkbiosecurity.acc.vo.AccReaderZoneItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccReaderZoneController
extends BaseController
implements AccReaderZoneRemote {
    @Autowired
    private AccReaderZoneService accReaderZoneService;

    @RequiresPermissions(value={"acc:readerZone"})
    public ModelAndView index() {
        return new ModelAndView("acc/readerZone/accReaderZone");
    }

    @RequiresPermissions(value={"acc:readerZone:edit", "acc:readerZone:add"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.accReaderZoneService.getItemById(id));
        }
        return new ModelAndView("acc/readerZone/editAccReaderZone");
    }

    @RequiresPermissions(value={"acc:readerZone:edit", "acc:readerZone:add"})
    public ZKResultMsg save(AccReaderZoneItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.accReaderZoneService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:readerZone:refresh"})
    public DxGrid list(AccReaderZoneItem codition) {
        Pager pager = this.accReaderZoneService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:readerZone:del"})
    @LogRequest(module="acc_module", object="acc_leftMenu_readerDefine", opType="common_op_del", requestParams={"readerName"}, opContent="acc_readerDefine_readerName")
    public ZKResultMsg del(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        this.accReaderZoneService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg getAccReaderList(String id) {
        List items = this.accReaderZoneService.getAccReaderList(this.request.getSession().getId(), id);
        return new ZKResultMsg((Object)items);
    }

    @RequiresPermissions(value={"acc:readerZone:addReaders"})
    @LogRequest(module="acc_module", object="acc_leftMenu_readerDefine", opType="common_op_batchNew", requestParams={"readerName"}, opContent="acc_readerDefine_readerName")
    public ZKResultMsg addReaders(String accReaderIds, String accZoneFromId, String accZoneToId) {
        ZKResultMsg res = new ZKResultMsg();
        this.accReaderZoneService.addReaders(accReaderIds, accZoneFromId, accZoneToId);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public TreeItem getReaderByZoneId(String zoneId) {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = null;
        TreeItem pItem = new TreeItem("0");
        if (StringUtils.isNotBlank((CharSequence)zoneId)) {
            AccReaderZoneItem accReaderZoneItem = new AccReaderZoneItem();
            accReaderZoneItem.setAccZoneToId(zoneId);
            List accReaderZoneItems = this.accReaderZoneService.getByCondition(accReaderZoneItem);
            if (!accReaderZoneItems.isEmpty()) {
                for (AccReaderZoneItem readerZoneItem : accReaderZoneItems) {
                    item = new TreeItem();
                    item.setId(readerZoneItem.getReaderId());
                    item.setText(readerZoneItem.getReaderName());
                    item.setParent(pItem);
                    items.add(item);
                }
            }
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public ZKResultMsg getAccDoorByZone() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String zoneId = this.request.getParameter("zoneId");
        if (StringUtils.isNotBlank((CharSequence)zoneId)) {
            zkResultMsg = this.accReaderZoneService.getDoorNameByZoneId(zoneId);
        }
        return zkResultMsg;
    }

    public ZKResultMsg checkDevIssueVerify(String zoneId, String opType) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        String ids = this.accReaderZoneService.checkDevIssueVerify(zoneId, opType);
        if (ids.length() > 0) {
            resultMsg.setRet("fail");
        }
        resultMsg.setData((Object)ids);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"acc:readerZone:addReaders"})
    public ModelAndView addReadersZones() {
        return new ModelAndView("acc/readerZone/editAccReadersZone");
    }
}

