/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.park.constants.ParkConstants;
import com.zkteco.zkbiosecurity.park.remote.ParkRecordinSideRemote;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordinService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordinSideService;
import com.zkteco.zkbiosecurity.park.vo.ParkRecordinSideItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryValueService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkRecordinSideController
extends ExportController
implements ParkRecordinSideRemote {
    @Autowired
    private ParkRecordinSideService parkRecordinSideService;
    @Autowired
    private BaseDictionaryValueService baseDictionaryValueService;
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired
    private ParkRecordinService parkRecordinService;

    @RequiresPermissions(value={"park:recordinSide"})
    public ModelAndView index() {
        StringBuffer showColumns = new StringBuffer("!remark");
        if ("lprCamera".equals(this.parkParamsService.getRunMode())) {
            showColumns.append(",cardNumber");
        }
        this.request.setAttribute("showColumns", (Object)showColumns);
        return new ModelAndView("park/recordinSide/parkRecordinSide");
    }

    public DxGrid list(ParkRecordinSideItem codition) {
        Pager pager = this.parkRecordinSideService.getItemsByPage((BaseItem)this.setRecordinCondition(codition), this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="park_module", object="park_leftMenu_recordinReport", opType="common_op_export", opContent="common_op_export")
    @RequiresPermissions(value={"park:recordinSide:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        ParkRecordinSideItem parkRecordinSideItem = this.setRecordinCondition(new ParkRecordinSideItem());
        this.setConditionValue((BaseItem)parkRecordinSideItem);
        List parkRecordinSideItemList = this.parkRecordinSideService.getItemsDataBySql(parkRecordinSideItem, this.getBeginIndex(), this.getEndIndex());
        HashMap<String, Map> map = new HashMap<String, Map>();
        map.put("channelState", this.baseDictionaryValueService.getDictionaryValuesMap("parkChannelState"));
        map.put("eventType", this.baseDictionaryValueService.getDictionaryValuesMap("parkEventType"));
        map.put("photoPathIn", this.parkRecordinService.converPhotoMap());
        this.excelExport(parkRecordinSideItemList, ParkRecordinSideItem.class, map);
    }

    private ParkRecordinSideItem setRecordinCondition(ParkRecordinSideItem parkRecordinSideItem) {
        parkRecordinSideItem.setChannelStateNot(ParkConstants.CHANNEL_STATE_CENT_PAY);
        parkRecordinSideItem.setStatusNot(Short.valueOf((short)0));
        parkRecordinSideItem.setEventTypeNotIn(ParkConstants.EVENT_ONLINE_CHARGE + "," + ParkConstants.EVENT_ONLINE_WXPAY + "," + ParkConstants.EVENT_ONLINE_ALIPAY);
        return parkRecordinSideItem;
    }

    @RequiresPermissions(value={"park:recordinSide:photo"})
    public ZKResultMsg getPhotoByRecordinSideId(String recordinSideId) {
        String photo = this.parkRecordinSideService.getPhotoByRecordinSideId(recordinSideId);
        return new ZKResultMsg((Object)photo);
    }
}

