/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.posid.remote.PosIDSystemParamRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDDeviceService;
import com.zkteco.zkbiosecurity.posid.service.PosIDSystemParamService;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDSystemParamController
extends BaseController
implements PosIDSystemParamRemote {
    @Autowired
    private PosIDSystemParamService posIDSystemParamService;
    @Autowired
    private PosIDDeviceService posIDDeviceService;

    @RequiresPermissions(value={"posid:systemParam"})
    public ModelAndView index() {
        Map posParams = this.posIDSystemParamService.getPosParams();
        if (posParams.containsKey("posid.highLimit")) {
            posParams.put("posid.highLimit", String.valueOf(Integer.parseInt((String)posParams.get("posid.highLimit")) / 100));
        }
        if (posParams.containsKey("posid.thresholdValue")) {
            posParams.put("posid.thresholdValue", String.valueOf(Integer.parseInt((String)posParams.get("posid.thresholdValue")) / 100));
        }
        if (posParams.containsKey("posid.memberAccount")) {
            posParams.put("posid.memberAccount", String.valueOf(Integer.parseInt((String)posParams.get("posid.memberAccount")) / 100));
        }
        if (posParams.containsKey("posid.consumeMaxMoney")) {
            posParams.put("posid.consumeMaxMoney", String.valueOf(Integer.parseInt((String)posParams.get("posid.consumeMaxMoney")) / 100));
        }
        this.request.setAttribute("posParams", (Object)posParams);
        return new ModelAndView("posid/systemParam/posIDSystemParam");
    }

    @RequiresPermissions(value={"posid:systemParam:edit"})
    @LogRequest(module="posid_module", object="posid_systemParam", opType="common_leftMenu_paramSet", opContent="common_leftMenu_paramSet")
    public ZKResultMsg save(@RequestParam Map<String, String> params) {
        ZKResultMsg res = new ZKResultMsg();
        if (params.containsKey("posid.highLimit")) {
            params.put("posid.highLimit", String.valueOf(Integer.parseInt(params.get("posid.highLimit")) * 100));
        }
        if (params.containsKey("posid.thresholdValue")) {
            params.put("posid.thresholdValue", String.valueOf(Integer.parseInt(params.get("posid.thresholdValue")) * 100));
        }
        if (params.containsKey("posid.memberAccount")) {
            params.put("posid.memberAccount", String.valueOf(Integer.parseInt(params.get("posid.memberAccount")) * 100));
        }
        if (params.containsKey("posid.consumeMaxMoney")) {
            params.put("posid.consumeMaxMoney", String.valueOf(Integer.parseInt(params.get("posid.consumeMaxMoney")) * 100));
        }
        this.posIDSystemParamService.saveItem(params);
        this.posIDDeviceService.putSystemParamToFaceDevice();
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"posid:systemParam"})
    public ZKResultMsg getParams() {
        ZKResultMsg res = new ZKResultMsg((Object)this.posIDSystemParamService.getPosParams());
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public boolean isEnableShow() {
        boolean offlineMode = !Boolean.parseBoolean((String)this.posIDSystemParamService.getPosParams().get("posid.offlineMode"));
        return offlineMode;
    }
}

