/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.posid.remote.PosIDOuterTransactionRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDOuterTransactionDetailService;
import com.zkteco.zkbiosecurity.posid.service.PosIDOuterTransactionService;
import com.zkteco.zkbiosecurity.posid.service.PosIDSystemParamService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDOuterTransactionDetailItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDOuterTransactionExportItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDOuterTransactionItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDOuterTransactionController
extends ExportController
implements PosIDOuterTransactionRemote {
    @Autowired
    private PosIDOuterTransactionService posIDOuterTransactionService;
    @Autowired
    private PosIDSystemParamService posIDSystemParamService;
    @Autowired
    private PosIDOuterTransactionDetailService posIDOuterTransactionDetailService;

    @RequiresPermissions(value={"posid:outerTransaction"})
    public ModelAndView index() {
        return new ModelAndView("posid/outerTransaction/posIDOuterTransaction");
    }

    @RequiresPermissions(value={"posid:outerTransaction:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.posIDOuterTransactionService.getItemById(id));
        }
        return new ModelAndView("posid/outerTransaction/editPosIDOuterTransaction");
    }

    @RequiresPermissions(value={"posid:outerTransaction:edit"})
    @LogRequest(module="posid_module", object="posid_transaction", opType="common_op_new", requestParams={"personPin"}, opContent="posid_card_personNum")
    public ZKResultMsg save(PosIDOuterTransactionItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.posIDOuterTransactionService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"posid:outerTransaction:refresh"})
    public DxGrid list(PosIDOuterTransactionItem codition) {
        Pager pager = this.posIDOuterTransactionService.loadPagerByAuthFilter(codition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"posid:outerTransaction:del"})
    @LogRequest(module="posid_module", object="posid_transaction", opType="common_op_del", requestParams={"ids"}, opContent="posid_common_id")
    public ZKResultMsg delete(String ids) {
        this.posIDOuterTransactionService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ModelAndView showDetailIndex(String transactionId) {
        HashMap<String, String> param = new HashMap<String, String>();
        Integer cardModel = this.posIDSystemParamService.getDoubleCash();
        param.put("transactionId", transactionId);
        return new ModelAndView("posid/outerTransaction/posIDOuterTransactionDetail", param);
    }

    public DxGrid showDetailList(String transactionId) {
        PosIDOuterTransactionDetailItem posIDOuterTransactionDetailItem = new PosIDOuterTransactionDetailItem();
        posIDOuterTransactionDetailItem.setOutertransactionId(transactionId);
        Pager pager = this.posIDOuterTransactionDetailService.getItemsByPage((BaseItem)posIDOuterTransactionDetailItem, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, posIDOuterTransactionDetailItem.getClass());
    }

    @RequiresPermissions(value={"posid:outerTransaction:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) throws IllegalAccessException, InvocationTargetException {
        PosIDOuterTransactionItem posIDOuterTransactionItem = new PosIDOuterTransactionItem();
        this.setConditionValue((BaseItem)posIDOuterTransactionItem);
        List posIDOuterTransactionExportItemList = this.posIDOuterTransactionService.loadListByAuthFilter(posIDOuterTransactionItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        if (posIDOuterTransactionExportItemList.size() > 0) {
            PosIDOuterTransactionExportItem sumItem = new PosIDOuterTransactionExportItem();
            Double sumMoney = 0.0;
            for (PosIDOuterTransactionExportItem item : posIDOuterTransactionExportItemList) {
                if (item.getTypeName() == 9) continue;
                sumMoney = BigDecimal.valueOf(item.getMoney()).add(BigDecimal.valueOf(sumMoney)).setScale(2, 4).doubleValue();
            }
            sumItem.setId("-1");
            sumItem.setWxAlipay(I18nUtil.i18nCode((String)"posid_countTable_total", (Object[])new Object[0]));
            sumItem.setMoney(sumMoney);
            posIDOuterTransactionExportItemList.add(sumItem);
        }
        this.excelExport(posIDOuterTransactionExportItemList, PosIDOuterTransactionExportItem.class);
    }
}

