/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.Surrogate;
import sun.nio.cs.ext.ExtendedCharsets;

public class ISCII91
extends Charset
implements HistoricallyNamedCharset {
    private static final char NUKTA_CHAR = '\u093c';
    private static final char HALANT_CHAR = '\u094d';
    private static final byte NO_CHAR = -1;
    private static final char[] directMapTable = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u0901', '\u0902', '\u0903', '\u0905', '\u0906', '\u0907', '\u0908', '\u0909', '\u090a', '\u090b', '\u090e', '\u090f', '\u0910', '\u090d', '\u0912', '\u0913', '\u0914', '\u0911', '\u0915', '\u0916', '\u0917', '\u0918', '\u0919', '\u091a', '\u091b', '\u091c', '\u091d', '\u091e', '\u091f', '\u0920', '\u0921', '\u0922', '\u0923', '\u0924', '\u0925', '\u0926', '\u0927', '\u0928', '\u0929', '\u092a', '\u092b', '\u092c', '\u092d', '\u092e', '\u092f', '\u095f', '\u0930', '\u0931', '\u0932', '\u0933', '\u0934', '\u0935', '\u0936', '\u0937', '\u0938', '\u0939', '\u200d', '\u093e', '\u093f', '\u0940', '\u0941', '\u0942', '\u0943', '\u0946', '\u0947', '\u0948', '\u0945', '\u094a', '\u094b', '\u094c', '\u0949', '\u094d', '\u093c', '\u0964', '\uffff', '\uffff', '\uffff', '\uffff', '\ufffd', '\ufffd', '\u0966', '\u0967', '\u0968', '\u0969', '\u096a', '\u096b', '\u096c', '\u096d', '\u096e', '\u096f', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff'};
    private static final byte[] encoderMappingTable = new byte[]{-1, -1, -95, -1, -94, -1, -93, -1, -1, -1, -92, -1, -91, -1, -90, -1, -89, -1, -88, -1, -87, -1, -86, -1, -90, -23, -82, -1, -85, -1, -84, -1, -83, -1, -78, -1, -81, -1, -80, -1, -79, -1, -77, -1, -76, -1, -75, -1, -74, -1, -73, -1, -72, -1, -71, -1, -70, -1, -69, -1, -68, -1, -67, -1, -66, -1, -65, -1, -64, -1, -63, -1, -62, -1, -61, -1, -60, -1, -59, -1, -58, -1, -57, -1, -56, -1, -55, -1, -54, -1, -53, -1, -52, -1, -51, -1, -49, -1, -48, -1, -47, -1, -46, -1, -45, -1, -44, -1, -43, -1, -42, -1, -41, -1, -40, -1, -1, -1, -1, -1, -23, -1, -22, -23, -38, -1, -37, -1, -36, -1, -35, -1, -34, -1, -33, -1, -33, -23, -29, -1, -32, -1, -31, -1, -30, -1, -25, -1, -28, -1, -27, -1, -26, -1, -24, -1, -1, -1, -1, -1, -95, -23, -16, -75, -16, -72, -2, -1, -2, -1, -1, -1, -1, -1, -1, -1, -77, -23, -76, -23, -75, -23, -70, -23, -65, -23, -64, -23, -55, -23, -50, -1, -86, -23, -89, -23, -37, -23, -36, -23, -22, -1, -22, -22, -15, -1, -14, -1, -13, -1, -12, -1, -11, -1, -10, -1, -9, -1, -8, -1, -7, -1, -6, -1, -16, -65, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    public ISCII91() {
        super("x-ISCII91", ExtendedCharsets.aliasesFor("x-ISCII91"));
    }

    @Override
    public String historicalName() {
        return "ISCII91";
    }

    @Override
    public boolean contains(Charset cs) {
        return cs.name().equals("US-ASCII") || cs instanceof ISCII91;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends CharsetEncoder {
        private static final byte NO_CHAR = -1;
        private final Surrogate.Parser sgp = new Surrogate.Parser();

        private Encoder(Charset cs) {
            super(cs, 2.0f, 2.0f);
        }

        @Override
        public boolean canEncode(char ch) {
            return ch >= '\u0900' && ch <= '\u097f' && encoderMappingTable[2 * (ch - 2304)] != -1 || ch == '\u200d' || ch == '\u200c' || ch <= '\u007f';
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeArrayLoop(CharBuffer src, ByteBuffer dst) {
            char[] sa = src.array();
            int sp = src.arrayOffset() + src.position();
            int sl = src.arrayOffset() + src.limit();
            assert (sp <= sl);
            sp = sp <= sl ? sp : sl;
            byte[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            assert (dp <= dl);
            dp = dp <= dl ? dp : dl;
            boolean outputSize = false;
            try {
                while (sp < sl) {
                    int index = Integer.MIN_VALUE;
                    char inputChar = sa[sp];
                    if (inputChar >= '\u0000' && inputChar <= '\u007f') {
                        if (dl - dp < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        da[dp++] = (byte)inputChar;
                        ++sp;
                        continue;
                    }
                    if (inputChar == '\u200c') {
                        inputChar = '\u094d';
                    } else if (inputChar == '\u200d') {
                        inputChar = '\u093c';
                    }
                    if (inputChar >= '\u0900' && inputChar <= '\u097f') {
                        index = (inputChar - 2304) * 2;
                    }
                    if (Character.isSurrogate(inputChar)) {
                        if (this.sgp.parse(inputChar, sa, sp, sl) < 0) {
                            CoderResult coderResult = this.sgp.error();
                            return coderResult;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    if (index == Integer.MIN_VALUE || encoderMappingTable[index] == -1) {
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (encoderMappingTable[index + 1] == -1) {
                        if (dl - dp < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        da[dp++] = encoderMappingTable[index];
                    } else {
                        if (dl - dp < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        da[dp++] = encoderMappingTable[index];
                        da[dp++] = encoderMappingTable[index + 1];
                    }
                    ++sp;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeBufferLoop(CharBuffer src, ByteBuffer dst) {
            int mark = src.position();
            try {
                while (src.hasRemaining()) {
                    int index = Integer.MIN_VALUE;
                    char inputChar = src.get();
                    if (inputChar >= '\u0000' && inputChar <= '\u007f') {
                        if (dst.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        dst.put((byte)inputChar);
                        ++mark;
                        continue;
                    }
                    if (inputChar == '\u200c') {
                        inputChar = '\u094d';
                    } else if (inputChar == '\u200d') {
                        inputChar = '\u093c';
                    }
                    if (inputChar >= '\u0900' && inputChar <= '\u097f') {
                        index = (inputChar - 2304) * 2;
                    }
                    if (Character.isSurrogate(inputChar)) {
                        if (this.sgp.parse(inputChar, src) < 0) {
                            CoderResult coderResult = this.sgp.error();
                            return coderResult;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    if (index == Integer.MIN_VALUE || encoderMappingTable[index] == -1) {
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (encoderMappingTable[index + 1] == -1) {
                        if (dst.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        dst.put(encoderMappingTable[index]);
                    } else {
                        if (dst.remaining() < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        dst.put(encoderMappingTable[index]);
                        dst.put(encoderMappingTable[index + 1]);
                    }
                    ++mark;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.encodeArrayLoop(src, dst);
            }
            return this.encodeBufferLoop(src, dst);
        }
    }

    private static class Decoder
    extends CharsetDecoder {
        private static final char ZWNJ_CHAR = '\u200c';
        private static final char ZWJ_CHAR = '\u200d';
        private static final char INVALID_CHAR = '\uffff';
        private char contextChar = (char)65535;
        private boolean needFlushing = false;

        private Decoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        @Override
        protected CoderResult implFlush(CharBuffer out) {
            if (this.needFlushing) {
                if (out.remaining() < 1) {
                    return CoderResult.OVERFLOW;
                }
                out.put(this.contextChar);
            }
            this.contextChar = (char)65535;
            this.needFlushing = false;
            return CoderResult.UNDERFLOW;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeArrayLoop(ByteBuffer src, CharBuffer dst) {
            byte[] sa = src.array();
            int sp = src.arrayOffset() + src.position();
            int sl = src.arrayOffset() + src.limit();
            assert (sp <= sl);
            sp = sp <= sl ? sp : sl;
            char[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            assert (dp <= dl);
            dp = dp <= dl ? dp : dl;
            try {
                block27: while (sp < sl) {
                    int index = sa[sp];
                    index = index < 0 ? index + 255 : index;
                    char currentChar = directMapTable[index];
                    if (this.contextChar == '\ufffd') {
                        if (dl - dp < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        da[dp++] = 65533;
                        this.contextChar = (char)65535;
                        this.needFlushing = false;
                        ++sp;
                        continue;
                    }
                    block8 : switch (currentChar) {
                        case '\u0901': 
                        case '\u0907': 
                        case '\u0908': 
                        case '\u090b': 
                        case '\u093f': 
                        case '\u0940': 
                        case '\u0943': 
                        case '\u0964': {
                            if (this.needFlushing) {
                                if (dl - dp < 1) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                da[dp++] = this.contextChar;
                                this.contextChar = currentChar;
                                ++sp;
                                continue block27;
                            }
                            this.contextChar = currentChar;
                            this.needFlushing = true;
                            ++sp;
                            continue block27;
                        }
                        case '\u093c': {
                            if (dl - dp < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            switch (this.contextChar) {
                                case '\u0901': {
                                    da[dp++] = 2384;
                                    break block8;
                                }
                                case '\u0907': {
                                    da[dp++] = 2316;
                                    break block8;
                                }
                                case '\u0908': {
                                    da[dp++] = 2401;
                                    break block8;
                                }
                                case '\u090b': {
                                    da[dp++] = 2400;
                                    break block8;
                                }
                                case '\u093f': {
                                    da[dp++] = 2402;
                                    break block8;
                                }
                                case '\u0940': {
                                    da[dp++] = 2403;
                                    break block8;
                                }
                                case '\u0943': {
                                    da[dp++] = 2372;
                                    break block8;
                                }
                                case '\u0964': {
                                    da[dp++] = 2365;
                                    break block8;
                                }
                                case '\u094d': {
                                    if (this.needFlushing) {
                                        da[dp++] = this.contextChar;
                                        this.contextChar = currentChar;
                                        ++sp;
                                        continue block27;
                                    }
                                    da[dp++] = 8205;
                                    break block8;
                                }
                            }
                            if (this.needFlushing) {
                                da[dp++] = this.contextChar;
                                this.contextChar = currentChar;
                                ++sp;
                                continue block27;
                            }
                            da[dp++] = 2364;
                            break;
                        }
                        case '\u094d': {
                            if (dl - dp < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            if (this.needFlushing) {
                                da[dp++] = this.contextChar;
                                this.contextChar = currentChar;
                                ++sp;
                                continue block27;
                            }
                            if (this.contextChar == '\u094d') {
                                da[dp++] = 8204;
                                break;
                            }
                            da[dp++] = 2381;
                            break;
                        }
                        case '\uffff': {
                            if (this.needFlushing) {
                                if (dl - dp < 1) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                da[dp++] = this.contextChar;
                                this.contextChar = currentChar;
                                ++sp;
                                continue block27;
                            }
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                        default: {
                            if (dl - dp < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            if (this.needFlushing) {
                                da[dp++] = this.contextChar;
                                this.contextChar = currentChar;
                                ++sp;
                                continue block27;
                            }
                            da[dp++] = currentChar;
                        }
                    }
                    this.contextChar = currentChar;
                    this.needFlushing = false;
                    ++sp;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeBufferLoop(ByteBuffer src, CharBuffer dst) {
            int mark = src.position();
            try {
                block27: while (src.hasRemaining()) {
                    int index = src.get();
                    index = index < 0 ? index + 255 : index;
                    char currentChar = directMapTable[index];
                    if (this.contextChar == '\ufffd') {
                        if (dst.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        dst.put('\ufffd');
                        this.contextChar = (char)65535;
                        this.needFlushing = false;
                        ++mark;
                        continue;
                    }
                    block8 : switch (currentChar) {
                        case '\u0901': 
                        case '\u0907': 
                        case '\u0908': 
                        case '\u090b': 
                        case '\u093f': 
                        case '\u0940': 
                        case '\u0943': 
                        case '\u0964': {
                            if (this.needFlushing) {
                                if (dst.remaining() < 1) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                dst.put(this.contextChar);
                                this.contextChar = currentChar;
                                ++mark;
                                continue block27;
                            }
                            this.contextChar = currentChar;
                            this.needFlushing = true;
                            ++mark;
                            continue block27;
                        }
                        case '\u093c': {
                            if (dst.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            switch (this.contextChar) {
                                case '\u0901': {
                                    dst.put('\u0950');
                                    break block8;
                                }
                                case '\u0907': {
                                    dst.put('\u090c');
                                    break block8;
                                }
                                case '\u0908': {
                                    dst.put('\u0961');
                                    break block8;
                                }
                                case '\u090b': {
                                    dst.put('\u0960');
                                    break block8;
                                }
                                case '\u093f': {
                                    dst.put('\u0962');
                                    break block8;
                                }
                                case '\u0940': {
                                    dst.put('\u0963');
                                    break block8;
                                }
                                case '\u0943': {
                                    dst.put('\u0944');
                                    break block8;
                                }
                                case '\u0964': {
                                    dst.put('\u093d');
                                    break block8;
                                }
                                case '\u094d': {
                                    if (this.needFlushing) {
                                        dst.put(this.contextChar);
                                        this.contextChar = currentChar;
                                        ++mark;
                                        continue block27;
                                    }
                                    dst.put('\u200d');
                                    break block8;
                                }
                            }
                            if (this.needFlushing) {
                                dst.put(this.contextChar);
                                this.contextChar = currentChar;
                                ++mark;
                                continue block27;
                            }
                            dst.put('\u093c');
                            break;
                        }
                        case '\u094d': {
                            if (dst.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            if (this.needFlushing) {
                                dst.put(this.contextChar);
                                this.contextChar = currentChar;
                                ++mark;
                                continue block27;
                            }
                            if (this.contextChar == '\u094d') {
                                dst.put('\u200c');
                                break;
                            }
                            dst.put('\u094d');
                            break;
                        }
                        case '\uffff': {
                            if (this.needFlushing) {
                                if (dst.remaining() < 1) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                dst.put(this.contextChar);
                                this.contextChar = currentChar;
                                ++mark;
                                continue block27;
                            }
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                        default: {
                            if (dst.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            if (this.needFlushing) {
                                dst.put(this.contextChar);
                                this.contextChar = currentChar;
                                ++mark;
                                continue block27;
                            }
                            dst.put(currentChar);
                        }
                    }
                    this.contextChar = currentChar;
                    this.needFlushing = false;
                    ++mark;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.decodeArrayLoop(src, dst);
            }
            return this.decodeBufferLoop(src, dst);
        }
    }
}

