/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.controller;

import com.google.common.collect.Lists;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.psg.remote.PsgDSTimeRemote;
import com.zkteco.zkbiosecurity.psg.service.PsgDSTimeService;
import com.zkteco.zkbiosecurity.psg.service.PsgDeviceService;
import com.zkteco.zkbiosecurity.psg.vo.PsgDSTimeItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgDeviceItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PsgDSTimeController
extends BaseController
implements PsgDSTimeRemote {
    @Autowired
    private PsgDSTimeService psgDSTimeService;
    @Autowired
    private PsgDeviceService psgDeviceService;
    @Autowired
    private ProgressCache progressCache;

    @RequiresPermissions(value={"psg:dSTime"})
    public ModelAndView index() {
        return new ModelAndView("psg/dSTime/psgDSTime");
    }

    @RequiresPermissions(value={"psg:dSTime:add", "psg:dSTime:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("tempPsgDSTime", (Object)this.psgDSTimeService.getItemById(id));
        }
        return new ModelAndView("psg/dSTime/editPsgDSTime");
    }

    @RequiresPermissions(value={"psg:dSTime:add", "psg:dSTime:edit"})
    @LogRequest(module="psg_module", object="psg_leftMenu_dSTime", opType="common_op_edit", requestParams={"name"}, opContent="common_dsTime_name")
    public ZKResultMsg save(PsgDSTimeItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.psgDSTimeService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"psg:dSTime:refresh"})
    public DxGrid list(PsgDSTimeItem condition) {
        Pager pager = this.psgDSTimeService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"psg:dSTime:del"})
    @LogRequest(module="psg_module", object="psg_leftMenu_dSTime", opType="common_op_del", requestParams={"name"}, opContent="common_dsTime_name")
    public ZKResultMsg del(String ids) {
        PsgDSTimeItem initDSTime;
        ZKResultMsg resultMsg = new ZKResultMsg();
        ArrayList<String> idList = new ArrayList<String>(Arrays.asList(ids.split(",")));
        if (idList.contains((initDSTime = this.psgDSTimeService.getItemByInitFlag()).getId())) {
            resultMsg.setRet("500");
            resultMsg.setMsg("common_prompt_initDataCanNotDel");
        } else if (this.psgDeviceService.getCountByDSTimeId(ids) > 0) {
            resultMsg.setRet("500");
            resultMsg.setMsg("common_dsTime_delete");
        } else {
            this.psgDSTimeService.deleteByIds(ids);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg getDSTimeList() {
        ArrayList selectItemList = Lists.newArrayList();
        List psgDSTimeItemList = this.psgDSTimeService.getByCondition(new PsgDSTimeItem());
        psgDSTimeItemList.stream().forEach(dstime -> selectItemList.add(new SelectItem((Object)dstime.getName(), dstime.getId())));
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)selectItemList));
    }

    public boolean isExistName(String name) {
        return this.psgDSTimeService.isExistName(name);
    }

    @RequiresPermissions(value={"psg:dSTime:setDSTime"})
    public ModelAndView getById(String id) {
        this.request.setAttribute("id", (Object)id);
        return new ModelAndView("psg/dSTime/opPsgSetDSTime");
    }

    @RequiresPermissions(value={"psg:dSTime:setDSTime"})
    public ZKResultMsg setDSTime(String dSTimeId, String devIds) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>");
        List psgDeviceItemList = this.psgDeviceService.getItemByIds(devIds);
        for (int i = 0; i < psgDeviceItemList.size(); ++i) {
            String devAlias = this.psgDSTimeService.setDSTime(dSTimeId, ((PsgDeviceItem)psgDeviceItemList.get(i)).getId());
            this.progressCache.setProcess(new ProcessBean(100, (int)((float)(i + 1) / (float)psgDeviceItemList.size() * 100.0f), devAlias + ":" + I18nUtil.i18nCode((String)"common_dev_cmdSendSucceed", (Object[])new Object[0]) + "<br/>"));
        }
        this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }
}

