/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.patrol.init;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.base.utils.VersionUtil;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=90)
public class PatrolInit
implements CommandLineRunner {
    @Autowired
    private AuthPermissionService authPermissionService;
    @Autowired
    private BaseSysParamService baseSysParamService;

    public void run(String ... args) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("Patrol");
        if (!alreadyInit) {
            this.initAuthPermission();
            this.initPatrolParams();
            this.initUpgradeVersion();
            this.baseSysParamService.setAlreadyInitModule("Patrol");
        }
    }

    private void initAuthPermission() {
        AuthPermissionItem systemItem = new AuthPermissionItem("Patrol", "patrol_module", "patrol", "system", "true", Integer.valueOf(9));
        systemItem = this.authPermissionService.initData(systemItem);
        AuthPermissionItem subMenuItem1 = new AuthPermissionItem("PatrolRouteMonitor", "patrol_leftMenu_patrolRouteMonitor", "patrol:route:monitor", "menu", "true", Integer.valueOf(2));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("skip.do?page=patrol_monitor_patrolRTMonitor");
        subMenuItem1.setImg("patrol_monitoring_route.png");
        subMenuItem1.setImgHover("patrol_monitoring_route_over.png");
        subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
        AuthPermissionItem subMenuItem = new AuthPermissionItem("PatrolRTMonitor", "patrol_leftMenu_patrolRTMonitor", "patrol:route:rtMonitor", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("skip.do?page=patrol_monitor_patrolRTMonitor");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subMenuItem1 = new AuthPermissionItem("PatrolBasicManagement", "base_leftMenu_basicManagement", "patrol:basic:management", "menu", "true", Integer.valueOf(3));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("patrolDevice.do");
        subMenuItem1.setImg("comm_setParam.png");
        subMenuItem1.setImgHover("comm_setParam_over.png");
        subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
        subMenuItem = new AuthPermissionItem("PatrolDevice", "patrol_device", "patrol:device", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("patrolDevice.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        AuthPermissionItem subButtonItem = new AuthPermissionItem("PatrolDeviceAdd", "common_op_new", "patrol:device:add", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PatrolDeviceRefresh", "common_op_refresh", "patrol:device:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PatrolDeviceDel", "common_op_del", "patrol:device:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PatrolPoint", "patrol_point", "patrol:point", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("patrolPoint.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PatrolPointAdd", "common_op_new", "patrol:point:add", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PatrolPointRefresh", "common_op_refresh", "patrol:point:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PatrolPointDel", "common_op_del", "patrol:point:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PatrolPointEdit", "common_op_edit", "patrol:point:edit", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PatrolParams", "common_leftMenu_paramSet", "patrol:params", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("patrolParams.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PatrolParamsEdit", "common_op_edit", "patrol:params:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem1 = new AuthPermissionItem("PatrolManagement", "patrol_leftMenu_patrolManagement", "patrol:management", "menu", "true", Integer.valueOf(4));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("patrolPlan.do");
        subMenuItem1.setImg("patrol_management.png");
        subMenuItem1.setImgHover("patrol_management_over.png");
        subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
        subMenuItem = new AuthPermissionItem("PatrolPlan", "patrol_leftMenu_patrolPlan", "patrol:plan", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("patrolPlan.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PatrolPlanAdd", "common_op_new", "patrol:plan:add", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PatrolPlanRefresh", "common_op_refresh", "patrol:plan:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PatrolPlanDel", "common_op_del", "patrol:plan:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PatrolPlanEdit", "common_op_edit", "patrol:plan:edit", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PatrolGroup", "patrol_group", "patrol:group", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("patrolGroup.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PatrolGroupAdd", "common_op_new", "patrol:group:add", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PatrolGroupEdit", "common_op_edit", "patrol:group:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PatrolGroupRefresh", "common_op_refresh", "patrol:group:refresh", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PatrolGroupDel", "common_op_del", "patrol:group:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PatrolGroupRefreshPerson", "common_op_refresh", "patrol:group:refreshPerson", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PatrolGroupAddPerson", "pers_common_addPerson", "patrol:group:addPerson", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PatrolGroupDelPerson", "pers_common_delPerson", "patrol:group:delPerson", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PatrolRoute", "patrol_leftMenu_patrolRoute", "patrol:route", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("patrolRoute.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PatrolRouteAdd", "common_op_new", "patrol:route:add", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PatrolRouteRefresh", "common_op_refresh", "patrol:route:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PatrolRouteEnabled", "common_enable", "patrol:route:enable", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PatrolRouteDisabled", "common_disable", "patrol:route:disable", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PatrolRouteDel", "common_op_del", "patrol:route:del", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PatrolRouteEdit", "common_op_edit", "patrol:route:edit", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem1 = new AuthPermissionItem("PatrolTransactionManagement", "common_leftMenu_reports", "patrol:transaction:management", "menu", "true", Integer.valueOf(5));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("patrolTransaction.do");
        subMenuItem1.setImg("comm_reports.png");
        subMenuItem1.setImgHover("comm_reports_over.png");
        subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
        subMenuItem = new AuthPermissionItem("PatrolTransaction", "common_leftMenu_transaction", "patrol:transaction", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("patrolTransaction.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PatrolTransactionRefresh", "common_op_refresh", "patrol:transaction:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PatrolTransactionExport", "common_op_export", "patrol:transaction:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PatrolTransactionToday", "patrol_leftMenu_patrolTransToday", "patrol:transaction:today", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("patrolTransactionToday.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PatrolTransactionTodayRefresh", "common_op_refresh", "patrol:transactionToday:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PatrolTransactionTodayExport", "common_op_export", "patrol:transactionToday:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PatrolRouteTotal", "patrol_leftMenu_patrolRouteStatistics", "patrol:route:total", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("patrolRouteTotal.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PatrolRouteTotalRefresh", "common_op_refresh", "patrol:routeTotal:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PatrolRouteTotalExport", "common_op_export", "patrol:routeTotal:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PatrolPersonTotal", "patrol_leftMenu_PatrolOfficersStatistics", "patrol:person:total", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("patrolPersonTotal.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PatrolPersonTotalRefresh", "common_op_refresh", "patrol:personTotal:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PatrolPersonTotalExport", "common_op_export", "patrol:personTotal:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
    }

    public void initPatrolParams() {
        BaseSysParamItem item = new BaseSysParamItem("patrol.dashboard.show", "true", "\u662f\u5426\u5c4f\u853d\u5de5\u4f5c\u9762\u677f\u9875\u9762\uff0c\u76f4\u63a5\u8fdb\u5165\u7b2c\u4e00\u4e2a\u7cfb\u7edf\u83dc\u5355");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("patrol.deviceModule", "acc", "\u5b9a\u4e49\u5de1\u66f4\u8bbe\u5907\u53ef\u4ee5\u4ece\u54ea\u4e9b\u6a21\u5757\u4e2d\u83b7\u53d6");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("patrol.intervalExpression", "0 0/30 * * * ?", "\u8def\u7ebf/\u5de1\u66f4\u4eba\u5458\u7edf\u8ba1\u65f6\u95f4");
        this.baseSysParamService.initData(item);
        JSONObject values = new JSONObject();
        values.put("keptMonth", (Object)"15");
        values.put("runtime", (Object)"01:00:00");
        item = new BaseSysParamItem("patrolReportDataClean", values.toString(), "base_dataClean_patrolTrans");
        this.baseSysParamService.initData(item);
    }

    private void initUpgradeVersion() {
        String curVersion = VersionUtil.getReleaseGitTags((String)"patrol");
        if (StringUtils.isNotBlank((CharSequence)curVersion)) {
            BaseSysParamItem baseSysParamItem = this.baseSysParamService.findByParamName("PatrolUpgradeVersion");
            if (StringUtils.isBlank((CharSequence)baseSysParamItem.getId())) {
                baseSysParamItem = new BaseSysParamItem("PatrolUpgradeVersion", curVersion, "Patrol Upgrade Version", Boolean.valueOf(true));
            }
            this.baseSysParamService.saveItem(baseSysParamItem);
        }
    }
}

