/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.init;

import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.base.utils.VersionUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.park.service.ParkCarTypeService;
import com.zkteco.zkbiosecurity.park.service.ParkTemporaryChargeService;
import com.zkteco.zkbiosecurity.park.vo.ParkCarTypeItem;
import com.zkteco.zkbiosecurity.park.vo.ParkTemporaryChargeExtendItem;
import com.zkteco.zkbiosecurity.park.vo.ParkTemporaryChargeItem;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=80)
public class ParkInit
implements CommandLineRunner {
    @Value(value="${system.isCloud:false}")
    private Boolean isCloud;
    @Value(value="${system.language}")
    private String language;
    @Autowired
    private AuthPermissionService authPermissionService;
    @Autowired
    private ParkCarTypeService parkCarTypeService;
    @Autowired
    private ParkTemporaryChargeService parkTemporaryChargeService;
    @Autowired
    private BaseSysParamService baseSysParamService;

    public void run(String ... args) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("ParkInit");
        if (!alreadyInit) {
            this.initAuthPermission();
            this.initCarType();
            this.initTemporaryCharge();
            if (!"zh_CN".equals(this.language) && !this.isCloud.booleanValue()) {
                this.initAppMenus();
            }
            this.initUpgradeVersion();
            this.baseSysParamService.setAlreadyInitModule("ParkInit");
        }
    }

    private void initAuthPermission() {
        AuthPermissionItem systemItem = new AuthPermissionItem("Park", "park_module", "park", "system", "true", Integer.valueOf(8));
        systemItem = this.authPermissionService.initData(systemItem);
        AuthPermissionItem supMenuItem = new AuthPermissionItem("ParkBasicManage", "base_leftMenu_basicManagement", "park:basic:manage", "menu", "true", Integer.valueOf(2));
        supMenuItem.setParentId(systemItem.getId());
        supMenuItem.setActionLink("parkParams.do");
        supMenuItem.setImg("park_parkingLot_manage.png");
        supMenuItem.setImgHover("park_parkingLot_manage_over.png");
        supMenuItem = this.authPermissionService.saveItem(supMenuItem);
        AuthPermissionItem subMenuItem = new AuthPermissionItem("ParkParams", "park_params", "park:params", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkParams.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        AuthPermissionItem subButtonItem = new AuthPermissionItem("ParkParamsEdit", "park_params_edit", "park:params:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("ParkOffineSet", "park_parkingLotSet_offlineSetting", "park:offineSet", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkOffineSet.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subMenuItem = new AuthPermissionItem("ParkDevice", "park_device", "park:device", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkDevice.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkDeviceRefresh", "park_device_refresh", "park:device:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkDeviceAdd", "park_device_add", "park:device:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkDeviceDel", "park_device_del", "park:device:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkDeviceEdit", "park_device_edit", "park:device:edit", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkDeviceSearch", "common_dev_searchDev", "park:device:search", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkDeviceDisable", "common_disable", "park:device:disable", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkDeviceEnable", "common_enable", "park:device:enable", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkDeviceSynTime", "park_device_syncTime", "park:device:synTime", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkDeviceGetParameter", "common_dev_getDevOpt", "park:device:getParameter", "button", "true", Integer.valueOf(9));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkDeviceGetVersion", "park_device_getVersion", "park:device:getVersion", "button", "true", Integer.valueOf(10));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("ParkParkingArea", "park_parkingArea", "park:parkingArea", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkParkingArea.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkParkingAreaRefresh", "park_parkingArea_refresh", "park:parkingArea:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkParkingAreaAdd", "park_parkingArea_add", "park:parkingArea:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkParkingAreaDel", "park_parkingArea_del", "park:parkingArea:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkParkingAreaEdit", "park_parkingArea_edit", "park:parkingArea:edit", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkParkingSpaceAdd", "park_parkingSpace_add", "park:parkingSpace:add", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkParkingSpaceDel", "park_parkingSpace_del", "park:parkingSpace:del", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkParkingSpaceRefresh", "park_parkingSpace_refresh", "park:parkingSpace:refresh", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("ParkEntranceArea", "park_entranceArea", "park:entranceArea", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkEntranceArea.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkEntranceAreaRefresh", "park_entranceArea_refresh", "park:entranceArea:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkEntranceAreaAdd", "park_entranceArea_add", "park:entranceArea:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkEntranceAreaDel", "park_entranceArea_del", "park:entranceArea:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkEntranceAreaEdit", "park_entranceArea_edit", "park:entranceArea:edit", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("ParkPavilio", "park_pavilio", "park:pavilio", "menu", "true", Integer.valueOf(6));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkPavilio.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkPavilioRefresh", "park_pavilio_refresh", "park:pavilio:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkPavilioAdd", "park_pavilio_add", "park:pavilio:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkPavilioDel", "park_pavilio_del", "park:pavilio:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkPavilioEdit", "park_pavilio_edit", "park:pavilio:edit", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkPavilioReset", "park_pavilio_reset", "park:pavilio:reset", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("ParkChannel", "park_channel", "park:channel", "menu", "true", Integer.valueOf(7));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkChannel.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkChannelRefresh", "park_channel_refresh", "park:channel:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkChannelAdd", "park_channel_add", "park:channel:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkChannelDel", "park_channel_del", "park:channel:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkChannelEdit", "park_channel_edit", "park:channel:edit", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkChannelUnmannedQR", "park_channel_unmannedQR", "park:channel:showUnmannedQR", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("ParkCarType", "park_carType", "park:carType", "menu", "true", Integer.valueOf(9));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkCarType.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkCarTypeRefresh", "park_carType_refresh", "park:carType:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkCarTypeAdd", "park_carType_add", "park:carType:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkCarTypeEdit", "park_carType_edit", "park:carType:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkCarTypeDel", "park_carType_del", "park:carType:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("ParkShiftDefinition", "park_leftMenu_shiftSetting", "park:shiftDefinition", "menu", "true", Integer.valueOf(10));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkShiftDefinition.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkShiftDefinitionRefresh", "park_shift_refresh", "park:shiftDefinition:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkShiftDefinitionAdd", "park_shift_add", "park:shiftDefinition:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkShiftDefinitionDel", "park_shift_del", "park:shiftDefinition:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkShiftDefinitionEdit", "park_shift_edit", "park:shiftDefinition:edit", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("ParkReleaseReason", "park_releaseReason", "park:releaseReason", "menu", "true", Integer.valueOf(11));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkReleaseReason.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkReleaseReasonRefresh", "park_releaseReason_refresh", "park:releaseReason:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkReleaseReasonAdd", "park_releaseReason_add", "park:releaseReason:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkReleaseReasonDel", "park_releaseReason_del", "park:releaseReason:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkReleaseReasonEdit", "park_releaseReason_edit", "park:releaseReason:edit", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        if (LocaleMessageSourceUtil.language.equals("zh_CN")) {
            subMenuItem = new AuthPermissionItem("ParkProvince", "park_province", "park:province", "menu", "true", Integer.valueOf(12));
            subMenuItem.setParentId(supMenuItem.getId());
            subMenuItem.setActionLink("parkProvince.do");
            subMenuItem = this.authPermissionService.saveItem(subMenuItem);
            subButtonItem = new AuthPermissionItem("ParkProvinceRefresh", "common_op_refresh", "park:province:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.saveItem(subButtonItem);
            subButtonItem = new AuthPermissionItem("ParkProvinceAdd", "common_op_new", "park:province:add", "button", "true", Integer.valueOf(2));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.saveItem(subButtonItem);
            subButtonItem = new AuthPermissionItem("ParkProvinceDel", "common_op_edit", "park:province:del", "button", "true", Integer.valueOf(3));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.saveItem(subButtonItem);
            subButtonItem = new AuthPermissionItem("ParkProvinceEdit", "common_op_del", "park:province:edit", "button", "true", Integer.valueOf(4));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.saveItem(subButtonItem);
            subMenuItem = new AuthPermissionItem("ParkThirdParty", "park_thirdParty_setting", "park:thirdParty", "menu", "true", Integer.valueOf(13));
            subMenuItem.setParentId(supMenuItem.getId());
            subMenuItem.setActionLink("parkThirdParty.do");
            subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        } else {
            subMenuItem = new AuthPermissionItem("ParkPay", "park_parkingLotSet_paySetting", "park:pay", "menu", "true", Integer.valueOf(13));
            subMenuItem.setParentId(supMenuItem.getId());
            subMenuItem.setActionLink("parkPay.do");
            subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        }
        subMenuItem = new AuthPermissionItem("ParkDisplayDevice", "park_displayDevice", "park:displayDevice", "menu", "true", Integer.valueOf(14));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkDisplayDevice.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkDisplayDeviceRefresh", "common_op_refresh", "park:displayDevice:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkDisplayDeviceAdd", "common_op_new", "park:displayDevice:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkDisplayDeviceDel", "common_op_edit", "park:displayDevice:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkDisplayDeviceEdit", "common_op_del", "park:displayDevice:edit", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        supMenuItem = new AuthPermissionItem("ParkChangeManage", "park_leftMenu_chargeManage", "park:change:manage", "menu", "true", Integer.valueOf(3));
        supMenuItem.setParentId(systemItem.getId());
        supMenuItem.setActionLink("parkFixedCharge.do");
        supMenuItem.setImg("park_charge_set.png");
        supMenuItem.setImgHover("park_charge_set_over.png");
        supMenuItem = this.authPermissionService.saveItem(supMenuItem);
        subMenuItem = new AuthPermissionItem("ParkFixedCharge", "park_fixedVehicle", "park:fixedCharge", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkFixedCharge.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkFixedChargeRefresh", "park_fixedVehicle_refresh", "park:fixedCharge:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkFixedChargeAdd", "park_fixedVehicle_add", "park:fixedCharge:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkFixedChargeDel", "park_fixedVehicle_del", "park:fixedCharge:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkFixedChargeEdit", "park_fixedVehicle_edit", "park:fixedCharge:edit", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("ParkTemporaryCharge", "park_temporaryCharge", "park:temporaryCharge", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkTemporaryCharge.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkTemporaryChargeRefresh", "park_temporaryCharge_refresh", "park:temporaryCharge:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkTemporaryChargeAdd", "park_temporaryCharge_add", "park:temporaryCharge:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkTemporaryChargeDel", "park_temporaryCharge_del", "park:temporaryCharge:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkTemporaryChargeEdit", "park_temporaryCharge_edit", "park:temporaryCharge:edit", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("ParkOvertimeCharge", "park_overtimeCharge", "park:overtimeCharge", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkOvertimeCharge.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkOvertimeChargeRefresh", "common_op_refresh", "park:overtimeCharge:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkOvertimeChargeAdd", "common_op_new", "park:overtimeCharge:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkOvertimeChargeDel", "common_op_del", "park:overtimeCharge:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkOvertimeChargeEdit", "common_op_edit", "park:overtimeCharge:edit", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("ParkDiscountStrategy", "park_discountStrategy", "park:discountStrategy", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkDiscountStrategy.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkDiscountStrategyRefresh", "park_discountStrategy_refresh", "park:discountStrategy:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkDiscountStrategyAdd", "park_discountStrategy_add", "park:discountStrategy:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkDiscountStrategyDel", "park_discountStrategy_del", "park:discountStrategy:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkDiscountStrategyEdit", "park_discountStrategy_edit", "park:discountStrategy:edit", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("ParkShop", "park_leftMenu_shopManage", "park:shop", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkShop.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkShopRefresh", "park_shop_refresh", "park:shop:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkShopAdd", "park_shop_add", "park:shop:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkShopDel", "park_shop_del", "park:shop:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkShopEdit", "park_shop_edit", "park:shop:edit", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("ParkFinancialStatements", "park_leftMenu_financialStatements", "park:financialStatements", "menu", "true", Integer.valueOf(6));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkFinancialStatements.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkFinancialStatementsRefresh", "common_op_refresh", "park:financialStatements:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkFinancialStatementsEdit", "park_leftMenu_financialStatements", "park:financialStatements:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        supMenuItem = new AuthPermissionItem("ParkVehicleManage", "park_leftMenu_vehicleManage", "park:vehicle:manage", "menu", "true", Integer.valueOf(4));
        supMenuItem.setParentId(systemItem.getId());
        supMenuItem.setActionLink("parkCarNumber.do");
        supMenuItem.setImg("park_auth_manage.png");
        supMenuItem.setImgHover("park_auth_manage_over.png");
        supMenuItem = this.authPermissionService.saveItem(supMenuItem);
        subMenuItem = new AuthPermissionItem("ParkCarNumber", "park_leftMenu_registCarNumber", "park:carNumber", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkCarNumber.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkCarNumberRefresh", "park_carNumber_refresh", "park:carNumber:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkCarNumberAdd", "park_carNumber_add", "park:carNumber:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkCarNumberDel", "park_carNumber_del", "park:carNumber:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkCarNumberEdit", "park_carNumber_edit", "park:carNumber:edit", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkCarNumberExportTemp", "park_carNumber_exportTemp", "park:carNumber:exportTemp", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkCarNumberImport", "park_carNumber_import", "park:carNumber:import", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        AuthPermissionItem supMenuItemPers = this.authPermissionService.getItemByCode("PersPerson");
        if (null != supMenuItem) {
            subButtonItem = new AuthPermissionItem("PersPersonParkEdit", "pers_person_parkSet", "pers:person:parkEdit", "button", "true", Integer.valueOf(103));
            subButtonItem.setParentId(supMenuItemPers.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
        }
        subMenuItem = new AuthPermissionItem("ParkAuthorize", "park_leftMenu_authorizeManage", "park:authorize", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkAuthorize.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkAuthorizeRefresh", "park_authorize_refresh", "park:authorize:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkAuthorizeAdd", "park_authorize_add", "park:authorize:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkAuthorizeBatchAdd", "park_authorize_batchAuthorize", "park:authorize:batchAuthorize", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkAuthorizeTempAdd", "park_authorize_temporaryCaAdd", "park:authorize:tempAdd", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkAuthorizeSyncAuth", "park_authorize_syncAuthorize", "park:authorize:syncAuth", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkAuthorizeDel", "park_authorize_del", "park:authorize:del", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkAuthorizeEdit", "park_authorize_edit", "park:authorize:edit", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("ParkAuthorizeDelay", "park_carDelay", "park:authorizeDelay", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkAuthorizeDelay.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkAuthorizeDelayRefresh", "park_carDelay_refresh", "park:authorizeDelay:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkAuthorizeDelayEdit", "park_carDelay", "park:authorizeDelay:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkAuthorizeDelayDel", "park_authorize_del", "park:authorizeDelay:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("ParkBlackWhite", "park_leftMenu_blackWhiteManage", "park:blackWhite", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkBlackWhite.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkBlackWhiteRefresh", "park_blackWhite_refresh", "park:blackWhite:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkBlackWhiteAdd", "park_blackWhite_add", "park:blackWhite:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkBlackWhiteDel", "park_blackWhite_del", "park:blackWhite:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkBlackWhiteEdit", "park_blackWhite_edit", "park:blackWhite:edit", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkBlackWhiteSyncWhite", "park_blackWhite_syncWhite", "park:blackWhite:syncWhite", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkBlackWhiteSyncBlack", "park_blackWhite_syncBlack", "park:blackWhite:syncBlack", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        supMenuItem = new AuthPermissionItem("ParkReport", "park_leftMenu_reportManage", "park:report", "menu", "true", Integer.valueOf(5));
        supMenuItem.setParentId(systemItem.getId());
        supMenuItem.setActionLink("parkDeviceOpRecord.do");
        supMenuItem.setImg("park_report.png");
        supMenuItem.setImgHover("park_report_over.png");
        supMenuItem = this.authPermissionService.saveItem(supMenuItem);
        subMenuItem = new AuthPermissionItem("ParkRecordin", "park_leftMenu_floorVehicleReport", "park:recordin", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkRecordin.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkRecordinPhoto", "park_common_photo_in", "park:recordin:photo", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkRecordinRemove", "park_terminalManagement_eveOut", "park:recordin:remove", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkRecordinExport", "common_op_export", "park:recordin:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkRecordinManual", "park_recordin_carNumberManual", "park:recordin:parkManual", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("ParkRecordinSide", "park_leftMenu_recordinReport", "park:recordinSide", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkRecordinSide.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkRecordinSidePhoto", "park_common_photo_in", "park:recordinSide:photo", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkRecordinSideExport", "common_op_export", "park:recordinSide:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("ParkRecordoutReport", "park_leftMenu_recordoutReport", "park:recordout", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkRecordout.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkRecordoutReportPhoto", "park_common_photo_out", "park:recordout:photo", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("ParkRecordoutReportExport", "common_op_export", "park:recordout:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("ParkParkingMeter", "park_leftMenu_chargeDetail", "park:parkingMeter", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkParkingMeter.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkParkingMeterExport", "common_op_export", "park:parkingMeter:export", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("ParkRecordinStayTimeout", "park_leftMenu_stayTimeout", "park:stayTimeout", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkRecordin.do?stayTimeout");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkRecordinStayTimeoutRemove", "park_terminalManagement_eveOut", "park:StayTimeout:remove", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("ParkTransaction", "park_transaction", "park:transaction", "menu", "true", Integer.valueOf(6));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkTransaction.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkTransactionExport", "common_op_export", "park:transaction:export", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("ParkLevelRecord", "park_leftMenu_authReport", "park:levelRecord", "menu", "true", Integer.valueOf(7));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkLevelRecord.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkLevelRecordExport", "common_op_export", "park:levelRecord:export", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("ParkDeviceOpRecord", "park_deviceOpRecord", "park:deviceOpRecord", "menu", "true", Integer.valueOf(8));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkDeviceOpRecord.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkDeviceOpRecordDel", "park_deviceOpRecord_del", "park:deviceOpRecord:del", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("ParkWorkRecord", "park_leftMenu_shiftRecord", "park:workRecord", "menu", "true", Integer.valueOf(9));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkWorkRecord.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkWorkRecordExport", "common_op_export", "park:workRecord:export", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("ParkDailyReport", "park_leftMenu_dailyReport", "park:dailyReport", "menu", "true", Integer.valueOf(10));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkDailyReport.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkDailyReportExport", "common_op_export", "park:dailyReport:export", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("ParkMonthlyReport", "park_leftMenu_monthlyReport", "park:monthlyReport", "menu", "true", Integer.valueOf(11));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkMonthlyReport.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("ParkMonthlyReportExport", "common_op_export", "park:monthlyReport:export", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        supMenuItem = new AuthPermissionItem("ParkRealTimeMonitor", "park_leftMenu_rtMonitor", "park:realTime:manage", "menu", "true", Integer.valueOf(6));
        supMenuItem.setParentId(systemItem.getId());
        supMenuItem.setActionLink("parkTerminalManage.do");
        supMenuItem.setImg("park_terminal_manage.png");
        supMenuItem.setImgHover("park_terminal_manage_over.png");
        supMenuItem = this.authPermissionService.saveItem(supMenuItem);
        subMenuItem = new AuthPermissionItem("ParkTerminalManage", "park_leftMenu_pavilioMonitor", "park:terminalManage", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkTerminalManage.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subMenuItem = new AuthPermissionItem("ParkMonitorRoom", "park_leftMenu_totalMonitor", "park:monitorRoom", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(supMenuItem.getId());
        subMenuItem.setActionLink("parkMonitorRoom.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
    }

    private void initAppMenus() {
        AuthPermissionItem appMenuItem = null;
        AuthPermissionItem appButtonItem = null;
        AuthPermissionItem appModuleItem = this.authPermissionService.getItemByCode("App");
        if (null == appModuleItem) {
            appModuleItem = new AuthPermissionItem("App", "app_module", "app", "app_system", "true", Integer.valueOf(998));
            this.authPermissionService.initData(appModuleItem);
        }
        appMenuItem = new AuthPermissionItem("AppPark", "app_park", "app:APPpark", "app_menu", "true", Integer.valueOf(4));
        appMenuItem.setParentId(appModuleItem.getId());
        this.authPermissionService.initData(appMenuItem);
        appButtonItem = new AuthPermissionItem("AppParkCardNum", "app_park_cardnum", "app:APPparkCardNum", "app_button", "true", Integer.valueOf(1));
        appButtonItem.setParentId(appMenuItem.getId());
        this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("AppParkFixDelay", "app_park_fixdelay", "app:APPparkFixDelay", "app_button", "true", Integer.valueOf(2));
        appButtonItem.setParentId(appMenuItem.getId());
        this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("AppParkPavilio", "app_park_pavilio", "app:APPparkPavilio", "app_button", "true", Integer.valueOf(3));
        appButtonItem.setParentId(appMenuItem.getId());
        this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("AppParkChannel", "app_park_channel", "app:APPparkChannel", "app_button", "true", Integer.valueOf(4));
        appButtonItem.setParentId(appMenuItem.getId());
        this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("AppParkInCar", "app_park_incar", "app:APPparkInCar", "app_button", "true", Integer.valueOf(5));
        appButtonItem.setParentId(appMenuItem.getId());
        this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("AppParkChargeDetail", "app_park_chargedetail", "app:APPparkChargeDetail", "app_button", "true", Integer.valueOf(6));
        appButtonItem.setParentId(appMenuItem.getId());
        this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("AppParkCarSet", "app_park_carset", "app:APPparkCarSet", "app_button", "true", Integer.valueOf(7));
        appButtonItem.setParentId(appMenuItem.getId());
        this.authPermissionService.initData(appButtonItem);
    }

    private void initCarType() {
        ParkCarTypeItem carTypeItem = new ParkCarTypeItem();
        carTypeItem.setInitFlag(Boolean.valueOf(true));
        List carTypeList = this.parkCarTypeService.getByCondition(carTypeItem);
        if (carTypeList.size() == 0) {
            this.parkCarTypeService.initData(new ParkCarTypeItem(Short.valueOf((short)2), I18nUtil.i18nCode((String)"park_carType_type_temporaryCarA", (Object[])new Object[0]), Short.valueOf((short)0), Boolean.valueOf(true), "tempA"));
            this.parkCarTypeService.initData(new ParkCarTypeItem(Short.valueOf((short)2), I18nUtil.i18nCode((String)"park_carType_type_temporaryCarB", (Object[])new Object[0]), Short.valueOf((short)0), Boolean.valueOf(true), "tempB"));
            this.parkCarTypeService.initData(new ParkCarTypeItem(Short.valueOf((short)2), I18nUtil.i18nCode((String)"park_carType_type_temporaryCarC", (Object[])new Object[0]), Short.valueOf((short)0), Boolean.valueOf(true), "tempC"));
            this.parkCarTypeService.initData(new ParkCarTypeItem(Short.valueOf((short)2), I18nUtil.i18nCode((String)"park_carType_type_temporaryCarD", (Object[])new Object[0]), Short.valueOf((short)0), Boolean.valueOf(true), "tempD"));
            this.parkCarTypeService.initData(new ParkCarTypeItem(Short.valueOf((short)1), I18nUtil.i18nCode((String)"park_carType_type_fixedCarA", (Object[])new Object[0]), Short.valueOf((short)0), Boolean.valueOf(true), "monthA"));
            this.parkCarTypeService.initData(new ParkCarTypeItem(Short.valueOf((short)1), I18nUtil.i18nCode((String)"park_carType_type_fixedCarB", (Object[])new Object[0]), Short.valueOf((short)0), Boolean.valueOf(true), "monthB"));
            this.parkCarTypeService.initData(new ParkCarTypeItem(Short.valueOf((short)1), I18nUtil.i18nCode((String)"park_carType_type_fixedCarC", (Object[])new Object[0]), Short.valueOf((short)0), Boolean.valueOf(true), "monthC"));
            this.parkCarTypeService.initData(new ParkCarTypeItem(Short.valueOf((short)1), I18nUtil.i18nCode((String)"park_carType_type_fixedCarD", (Object[])new Object[0]), Short.valueOf((short)0), Boolean.valueOf(true), "monthD"));
        }
    }

    private void initTemporaryCharge() {
        ParkTemporaryChargeItem parkTemporaryChargeItem = new ParkTemporaryChargeItem();
        parkTemporaryChargeItem.setInitFlag(Boolean.valueOf(true));
        List parkTemporaryChargeItemList = this.parkTemporaryChargeService.getByCondition(parkTemporaryChargeItem);
        if (parkTemporaryChargeItemList.size() == 0) {
            ParkCarTypeItem parkCarTypeItem = this.parkCarTypeService.getTempACarType();
            parkTemporaryChargeItem.setCarTypeId(parkCarTypeItem.getId());
            parkTemporaryChargeItem.setBestraddleTime(Short.valueOf((short)0));
            parkTemporaryChargeItem.setChargeMode(Short.valueOf((short)1));
            parkTemporaryChargeItem.setEnableScrollingBilling(Short.valueOf((short)0));
            parkTemporaryChargeItem.setFreeMinutes(Short.valueOf((short)0));
            parkTemporaryChargeItem.setIncludingFlag(Short.valueOf((short)0));
            parkTemporaryChargeItem.setMaxfeePreday(Double.valueOf(0.0));
            parkTemporaryChargeItem.setName(I18nUtil.i18nCode((String)"park_carType_type_temporaryCarA", (Object[])new Object[0]));
            parkTemporaryChargeItem.setNaturalDays(Short.valueOf((short)2));
            ArrayList<ParkTemporaryChargeExtendItem> parkTemporaryChargeExtendByTime = new ArrayList<ParkTemporaryChargeExtendItem>();
            ParkTemporaryChargeExtendItem parkTemporaryChargeExtendItem = new ParkTemporaryChargeExtendItem(null, null, Short.valueOf((short)1), Double.valueOf(0.0), Short.valueOf((short)0), null, null, null, Short.valueOf((short)15), Double.valueOf(0.0), "00:00:00", "00:00:00", Short.valueOf((short)1));
            parkTemporaryChargeExtendByTime.add(parkTemporaryChargeExtendItem);
            parkTemporaryChargeItem.setParkTemporaryChargeExtendByTime(parkTemporaryChargeExtendByTime);
            this.parkTemporaryChargeService.saveItem(parkTemporaryChargeItem);
        }
    }

    private void initUpgradeVersion() {
        BaseSysParamItem baseSysParamItem;
        String curVersion = VersionUtil.getReleaseGitTags((String)"park");
        if (StringUtils.isNotBlank((CharSequence)curVersion) && StringUtils.isBlank((CharSequence)(baseSysParamItem = this.baseSysParamService.findByParamName("ParkUpgradeVersion")).getId())) {
            baseSysParamItem = new BaseSysParamItem("ParkUpgradeVersion", curVersion, "Park Upgrade Version", Boolean.valueOf(true));
            this.baseSysParamService.saveItem(baseSysParamItem);
        }
    }
}

