/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.system.remote.BaseBioVerifyRemote;
import com.zkteco.zkbiosecurity.system.service.BaseFingerComparisonService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.client.RestTemplate;

@Controller
public class BaseBioVerifyController
extends BaseController
implements BaseBioVerifyRemote {
    private static final String SERVER_IP = "localhost";
    private static final int SERVER_PORT = 18001;
    private static final String ZKFingerInfo = "http://%s:%d/zkfinger/info";
    private static final String ZKFingerVerify = "http://%s:%d/zkfinger/verify";
    private static final String ZKFingerClear = "http://%s:%d/zkfinger/clear";
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private BaseFingerComparisonService baseFingerComparisonService;

    public ZKResultMsg fpComparison(@RequestParam(value="verifyTemplate") String verifyTemplate, @RequestParam(value="templates") String templates) {
        String msgStr = "";
        boolean isExist = false;
        String[] templateArray = null;
        if (!StringUtils.isBlank((CharSequence)templates)) {
            if (templates.contains("[") && templates.contains("]")) {
                Pattern pattern = Pattern.compile("\\[\"(.*?)\"\\]");
                Matcher matcher = pattern.matcher(templates);
                templates = matcher.group(1);
            }
            templateArray = templates.split(",");
        }
        String ret = "";
        if (this.useFingerService()) {
            String connRet = this.getUriInfo(ZKFingerInfo);
            if (templateArray.length > 0) {
                if (connRet != null && !"".equals(connRet.trim())) {
                    for (int i = 0; i < templateArray.length; ++i) {
                        JSONObject retJson;
                        ret = this.getUriInfo(ZKFingerVerify);
                        if ("".equals(ret) || !(retJson = JSONObject.parseObject((String)ret)).containsKey((Object)"score") || retJson.getString("score").equals("0")) continue;
                        isExist = true;
                        break;
                    }
                } else {
                    msgStr = "noFingerServer";
                }
            }
        } else {
            this.log.info("-----------------------------   fpComparison in : ");
            this.baseFingerComparisonService.NativeToSetThreshold(10, 10);
            for (int i = 0; i < templateArray.length; ++i) {
                String temp = templateArray[i].toString().replace("\"", "");
                boolean verifyRet = this.baseFingerComparisonService.NativeToProcess(temp, verifyTemplate);
                if (!verifyRet) continue;
                isExist = true;
                break;
            }
        }
        this.log.info("-----------------------------   fpComparison ret: " + isExist);
        if (isExist) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)msgStr));
    }

    private String getUriInfo(String format) {
        String uri = String.format(format, SERVER_IP, 18001);
        String ret = (String)this.restTemplate.getForObject(uri, String.class, new Object[0]);
        this.log.info(ret);
        return ret;
    }

    private String postUriInfo(String format, byte[] buffer) {
        String uri = String.format(format, SERVER_IP, 18001);
        String ret = (String)this.restTemplate.postForObject(uri, (Object)buffer, String.class, new Object[0]);
        this.log.info("-----------------------------   postUriInfo : " + ret);
        return ret;
    }

    private boolean useFingerService() {
        return Boolean.valueOf(this.baseSysParamService.getValByName("system.useFingerService"));
    }

    public String getFingerServiceConn() {
        String retStr = "400";
        try {
            String connRet = this.getUriInfo(ZKFingerInfo);
            this.log.debug("-----------connRet:" + connRet);
            if (connRet != null && !"".equals(connRet.trim())) {
                retStr = "ok";
            }
        }
        catch (Exception e) {
            throw new ZKBusinessException((Throwable)e);
        }
        return retStr;
    }

    public String clearFPTemplate() {
        String retStr = "";
        try {
            String ret = this.getUriInfo(ZKFingerClear);
            JSONObject retJson = JSONObject.parseObject((String)ret);
            if (retJson.containsKey((Object)"count")) {
                retStr = "ok";
            }
        }
        catch (Exception e) {
            throw new ZKBusinessException((Throwable)e);
        }
        return retStr;
    }
}

