/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.model;

import com.zkteco.zkbiosecurity.auth.model.AuthPermission;
import com.zkteco.zkbiosecurity.auth.model.AuthUser;
import com.zkteco.zkbiosecurity.core.model.BaseModel;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;

@Entity
@Table(name="AUTH_ROLE", indexes={@Index(name="AUTH_ROLE_CRT_TIME_IDX", columnList="CREATE_TIME"), @Index(name="AUTH_ROLE_UPT_TIME_IDX", columnList="UPDATE_TIME")})
public class AuthRole
extends BaseModel
implements Serializable {
    private static final long serialVersionUID = 8505388362129998593L;
    @Column(name="CODE", length=200, nullable=false, unique=true)
    private String code;
    @Column(name="NAME", length=30, nullable=false, unique=true)
    private String name;
    @Column(name="REMARK", length=50)
    private String remark;
    @ManyToMany(targetEntity=AuthUser.class)
    @JoinTable(name="AUTH_USER_ROLE", joinColumns={@JoinColumn(name="AUTH_ROLE_ID", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="AUTH_USER_ID", referencedColumnName="ID")})
    private Set<AuthUser> users = new HashSet<AuthUser>();
    @ManyToMany(targetEntity=AuthPermission.class, fetch=FetchType.LAZY)
    @JoinTable(name="AUTH_ROLE_PERMISSION", joinColumns={@JoinColumn(name="AUTH_ROLE_ID", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="AUTH_PERMISSION_ID", referencedColumnName="ID")})
    private Set<AuthPermission> authPermissions = new HashSet<AuthPermission>();

    public AuthRole() {
    }

    public AuthRole(String name, String remark) {
        this.name = name;
        this.remark = remark;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getRemark() {
        return this.remark;
    }

    public Set<AuthUser> getUsers() {
        return this.users;
    }

    public Set<AuthPermission> getAuthPermissions() {
        return this.authPermissions;
    }

    public AuthRole setCode(String code) {
        this.code = code;
        return this;
    }

    public AuthRole setName(String name) {
        this.name = name;
        return this;
    }

    public AuthRole setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public AuthRole setUsers(Set<AuthUser> users) {
        this.users = users;
        return this;
    }

    public AuthRole setAuthPermissions(Set<AuthPermission> authPermissions) {
        this.authPermissions = authPermissions;
        return this;
    }
}

