/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.model;

import com.zkteco.zkbiosecurity.auth.model.AuthUser;
import com.zkteco.zkbiosecurity.core.model.BaseModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="AUTH_DEPARTMENT", indexes={@Index(name="AUTH_DEPARTMENT_CRT_IDX", columnList="CREATE_TIME"), @Index(name="AUTH_DEPARTMENT_UPT_IDX", columnList="UPDATE_TIME")})
public class AuthDepartment
extends BaseModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="NAME", length=100, nullable=false)
    private String name;
    @Column(name="CODE", length=30, nullable=false)
    private String code;
    @Column(name="SORT")
    private Integer sortNo;
    @Column(name="INIT_CODE", length=30)
    private String initCode;
    @ManyToOne
    @JoinColumn(name="PARENT_ID")
    private AuthDepartment parent;
    @OneToMany(mappedBy="parent")
    private List<AuthDepartment> children = new ArrayList<AuthDepartment>();
    @ManyToMany(targetEntity=AuthUser.class)
    @JoinTable(name="AUTH_USER_DEPT", joinColumns={@JoinColumn(name="AUTH_DEPT_ID", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="AUTH_USER_ID", referencedColumnName="ID")})
    private Set<AuthUser> users = new HashSet<AuthUser>();

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public Integer getSortNo() {
        return this.sortNo;
    }

    public String getInitCode() {
        return this.initCode;
    }

    public AuthDepartment getParent() {
        return this.parent;
    }

    public List<AuthDepartment> getChildren() {
        return this.children;
    }

    public Set<AuthUser> getUsers() {
        return this.users;
    }

    public AuthDepartment setName(String name) {
        this.name = name;
        return this;
    }

    public AuthDepartment setCode(String code) {
        this.code = code;
        return this;
    }

    public AuthDepartment setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
        return this;
    }

    public AuthDepartment setInitCode(String initCode) {
        this.initCode = initCode;
        return this;
    }

    public AuthDepartment setParent(AuthDepartment parent) {
        this.parent = parent;
        return this;
    }

    public AuthDepartment setChildren(List<AuthDepartment> children) {
        this.children = children;
        return this;
    }

    public AuthDepartment setUsers(Set<AuthUser> users) {
        this.users = users;
        return this;
    }
}

