/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.client.utils;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.ImgEncodeUtil;
import com.zkteco.zkbiosecurity.core.utils.SpringUtil;
import com.zkteco.zkbiosecurity.park.bean.ParkWeChatCharge;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.ObjectUtils;

public class ParkClientCommonUtil {
    public static boolean isNotNull(Object obj) {
        return !ParkClientCommonUtil.isNull(obj);
    }

    public static boolean isNull(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Map && ((Map)obj).isEmpty()) {
            return true;
        }
        if (obj instanceof JSONObject && ((JSONObject)obj).isEmpty()) {
            return true;
        }
        if (obj instanceof Long && (Long)obj == 0L) {
            return true;
        }
        if (obj instanceof List && ((List)obj).isEmpty()) {
            return true;
        }
        if (obj instanceof Collection && ((Collection)obj).isEmpty()) {
            return true;
        }
        return obj instanceof String && ((String)obj).isEmpty();
    }

    public static Map convertObjToMap(Object obj) {
        HashMap<String, Object> reMap = new HashMap<String, Object>();
        if (obj == null) {
            return null;
        }
        Field[] fields = obj.getClass().getDeclaredFields();
        try {
            for (int i = 0; i < fields.length; ++i) {
                try {
                    Field f = obj.getClass().getDeclaredField(fields[i].getName());
                    f.setAccessible(true);
                    Object o = f.get(obj);
                    reMap.put(fields[i].getName(), o);
                    continue;
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return reMap;
    }

    public static String getSystemFilePath() {
        ParkParamsService parkParamsService = (ParkParamsService)SpringUtil.getBean(ParkParamsService.class);
        return parkParamsService.getPhotoSavePath() + "\\";
    }

    public static String createZoomImage(String photoPath) {
        String newPhotoPath = photoPath;
        if (ParkClientCommonUtil.isNotNull(photoPath) && ParkClientCommonUtil.fileExists(photoPath)) {
            String basePath = ParkClientCommonUtil.getSystemFilePath();
            String fullPath = basePath + photoPath.substring(0, photoPath.lastIndexOf("\\"));
            String photoName = photoPath.substring(photoPath.lastIndexOf("\\") + 1);
            String newPhotoName = photoName.substring(0, photoName.length() - 4) + "_s.jpg";
            File file = new File(new File(fullPath), photoName);
            File thumbFile = new File(new File(fullPath), newPhotoName);
            ImgEncodeUtil.createZoomImage((File)file, (File)thumbFile, (int)550, (int)309);
            newPhotoPath = fullPath + "\\" + newPhotoName;
        }
        return newPhotoPath;
    }

    public static boolean fileExists(String relativePath) {
        String basePath = ParkClientCommonUtil.getSystemFilePath();
        String fullPath = basePath + relativePath;
        File file = new File(fullPath);
        return file.exists();
    }

    public static void getCarTypeByEvent(Short eventType, ParkWeChatCharge weChatCharge) {
        String chargeType = "tempCharge";
        String authType = "temp";
        switch (eventType) {
            case 2: {
                authType = "fix";
                chargeType = "invalid";
                break;
            }
            case 4: {
                chargeType = "timeOut";
                break;
            }
            case 7: {
                authType = "fix";
                break;
            }
        }
        weChatCharge.setIsAuth(authType);
        weChatCharge.setChargeType(chargeType);
    }

    public static String getParkingTime(Date checkinTime, Date checkOutTime) {
        Long parkingTimestamp = checkOutTime.getTime() - checkinTime.getTime();
        Long dayNumber = 86400000L;
        Long hourNumber = 3600000L;
        Long minuteNumber = 60000L;
        Long secondNumber = 1000L;
        Long dayLong = parkingTimestamp / dayNumber;
        Long hourLong = parkingTimestamp % dayNumber / hourNumber;
        Long minuteLong = parkingTimestamp % dayNumber % hourNumber / minuteNumber;
        Long secondLong = parkingTimestamp % dayNumber % hourNumber % minuteNumber / secondNumber;
        String dayString = "0".equals(dayLong.toString()) ? "" : dayLong.toString() + I18nUtil.i18nCode((String)"common_days", (Object[])new Object[0]) + " ";
        return dayString + hourLong.toString() + I18nUtil.i18nCode((String)"common_hours", (Object[])new Object[0]) + " " + minuteLong.toString() + I18nUtil.i18nCode((String)"common_minutes", (Object[])new Object[0]) + " " + secondLong.toString() + I18nUtil.i18nCode((String)"common_second", (Object[])new Object[0]);
    }

    public static String getDatePhotoPath() {
        return DateUtil.dateToString((Date)new Date(), (String)DateUtil.DateStyle.YYYY_MM_DD.getValue());
    }

    public static String getStringValue(Map<String, Object> map, String key) {
        Object obj;
        String value = null;
        if (map.containsKey(key) && !ObjectUtils.isEmpty((Object)(obj = map.get(key)))) {
            value = obj.toString();
        }
        return value;
    }

    public static int getIntValue(Map<String, Object> map, String key) {
        Object obj;
        Integer value = null;
        if (map.containsKey(key) && !ObjectUtils.isEmpty((Object)(obj = map.get(key)))) {
            value = (int)((Integer)obj);
        }
        return value;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
    }
}

