/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ManifestDigester {
    public static final String MF_MAIN_ATTRS = "Manifest-Main-Attributes";
    private byte[] rawBytes;
    private HashMap<String, Entry> entries;

    private boolean findSection(int offset, Position pos) {
        int len = this.rawBytes.length;
        int last = offset;
        boolean allBlank = true;
        pos.endOfFirstLine = -1;
        block4: for (int i = offset; i < len; ++i) {
            byte b = this.rawBytes[i];
            switch (b) {
                case 13: {
                    if (pos.endOfFirstLine == -1) {
                        pos.endOfFirstLine = i - 1;
                    }
                    if (i < len && this.rawBytes[i + 1] == 10) {
                        ++i;
                    }
                }
                case 10: {
                    if (pos.endOfFirstLine == -1) {
                        pos.endOfFirstLine = i - 1;
                    }
                    if (allBlank || i == len - 1) {
                        pos.endOfSection = i == len - 1 ? i : last;
                        pos.startOfNext = i + 1;
                        return true;
                    }
                    last = i;
                    allBlank = true;
                    continue block4;
                }
                default: {
                    allBlank = false;
                }
            }
        }
        return false;
    }

    public ManifestDigester(byte[] bytes) {
        this.rawBytes = bytes;
        this.entries = new HashMap();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Position pos = new Position();
        if (!this.findSection(0, pos)) {
            return;
        }
        this.entries.put(MF_MAIN_ATTRS, new Entry().addSection(new Section(0, pos.endOfSection + 1, pos.startOfNext, this.rawBytes)));
        int start = pos.startOfNext;
        while (this.findSection(start, pos)) {
            int len = pos.endOfFirstLine - start + 1;
            int sectionLen = pos.endOfSection - start + 1;
            int sectionLenWithBlank = pos.startOfNext - start;
            if (len > 6 && this.isNameAttr(bytes, start)) {
                StringBuilder nameBuf = new StringBuilder(sectionLen);
                try {
                    nameBuf.append(new String(bytes, start + 6, len - 6, "UTF8"));
                    int i = start + len;
                    if (i - start < sectionLen) {
                        i = bytes[i] == 13 ? (i += 2) : ++i;
                    }
                    while (i - start < sectionLen && bytes[i++] == 32) {
                        int wrapStart = i;
                        while (i - start < sectionLen && bytes[i++] != 10) {
                        }
                        if (bytes[i - 1] != 10) {
                            return;
                        }
                        int wrapLen = bytes[i - 2] == 13 ? i - wrapStart - 2 : i - wrapStart - 1;
                        nameBuf.append(new String(bytes, wrapStart, wrapLen, "UTF8"));
                    }
                    Entry e = this.entries.get(nameBuf.toString());
                    if (e == null) {
                        this.entries.put(nameBuf.toString(), new Entry().addSection(new Section(start, sectionLen, sectionLenWithBlank, this.rawBytes)));
                    } else {
                        e.addSection(new Section(start, sectionLen, sectionLenWithBlank, this.rawBytes));
                    }
                }
                catch (UnsupportedEncodingException uee) {
                    throw new IllegalStateException("UTF8 not available on platform");
                }
            }
            start = pos.startOfNext;
        }
    }

    private boolean isNameAttr(byte[] bytes, int start) {
        return !(bytes[start] != 78 && bytes[start] != 110 || bytes[start + 1] != 97 && bytes[start + 1] != 65 || bytes[start + 2] != 109 && bytes[start + 2] != 77 || bytes[start + 3] != 101 && bytes[start + 3] != 69 || bytes[start + 4] != 58 || bytes[start + 5] != 32);
    }

    public Entry get(String name, boolean oldStyle) {
        Entry e = this.entries.get(name);
        if (e != null) {
            e.oldStyle = oldStyle;
        }
        return e;
    }

    public byte[] manifestDigest(MessageDigest md) {
        md.reset();
        md.update(this.rawBytes, 0, this.rawBytes.length);
        return md.digest();
    }

    private static class Section {
        int offset;
        int length;
        int lengthWithBlankLine;
        byte[] rawBytes;

        public Section(int offset, int length, int lengthWithBlankLine, byte[] rawBytes) {
            this.offset = offset;
            this.length = length;
            this.lengthWithBlankLine = lengthWithBlankLine;
            this.rawBytes = rawBytes;
        }

        private static void doOldStyle(MessageDigest md, byte[] bytes, int offset, int length) {
            int i;
            int start = offset;
            int max = offset + length;
            int prev = -1;
            for (i = offset; i < max; ++i) {
                if (bytes[i] == 13 && prev == 32) {
                    md.update(bytes, start, i - start - 1);
                    start = i;
                }
                prev = bytes[i];
            }
            md.update(bytes, start, i - start);
        }
    }

    public static class Entry {
        private List<Section> sections = new ArrayList<Section>();
        boolean oldStyle;

        private Entry addSection(Section sec) {
            this.sections.add(sec);
            return this;
        }

        public byte[] digest(MessageDigest md) {
            md.reset();
            for (Section sec : this.sections) {
                if (this.oldStyle) {
                    Section.doOldStyle(md, sec.rawBytes, sec.offset, sec.lengthWithBlankLine);
                    continue;
                }
                md.update(sec.rawBytes, sec.offset, sec.lengthWithBlankLine);
            }
            return md.digest();
        }

        public byte[] digestWorkaround(MessageDigest md) {
            md.reset();
            for (Section sec : this.sections) {
                md.update(sec.rawBytes, sec.offset, sec.length);
            }
            return md.digest();
        }
    }

    static class Position {
        int endOfFirstLine;
        int endOfSection;
        int startOfNext;

        Position() {
        }
    }
}

