/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.ktab;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.security.action.GetPropertyAction;
import sun.security.krb5.Config;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.crypto.EType;
import sun.security.krb5.internal.ktab.KeyTabConstants;
import sun.security.krb5.internal.ktab.KeyTabEntry;
import sun.security.krb5.internal.ktab.KeyTabInputStream;
import sun.security.krb5.internal.ktab.KeyTabOutputStream;

public class KeyTab
implements KeyTabConstants {
    private static final boolean DEBUG = Krb5.DEBUG;
    private static String defaultTabName = null;
    private static Map<String, KeyTab> map = new HashMap<String, KeyTab>();
    private boolean isMissing = false;
    private boolean isValid = true;
    private final String tabName;
    private long lastModified;
    private int kt_vno = 1282;
    private Vector<KeyTabEntry> entries = new Vector();

    private KeyTab(String filename) {
        this.tabName = filename;
        try {
            this.lastModified = new File(this.tabName).lastModified();
            try (KeyTabInputStream kis = new KeyTabInputStream(new FileInputStream(filename));){
                this.load(kis);
            }
        }
        catch (FileNotFoundException e) {
            this.entries.clear();
            this.isMissing = true;
        }
        catch (Exception ioe) {
            this.entries.clear();
            this.isValid = false;
        }
    }

    private static synchronized KeyTab getInstance0(String s) {
        long lm = new File(s).lastModified();
        KeyTab old = map.get(s);
        if (old != null && old.isValid() && old.lastModified == lm) {
            return old;
        }
        KeyTab ktab = new KeyTab(s);
        if (ktab.isValid()) {
            map.put(s, ktab);
            return ktab;
        }
        if (old != null) {
            return old;
        }
        return ktab;
    }

    public static KeyTab getInstance(String s) {
        if (s == null) {
            return KeyTab.getInstance();
        }
        return KeyTab.getInstance0(KeyTab.normalize(s));
    }

    public static KeyTab getInstance(File file) {
        if (file == null) {
            return KeyTab.getInstance();
        }
        return KeyTab.getInstance0(file.getPath());
    }

    public static KeyTab getInstance() {
        return KeyTab.getInstance(KeyTab.getDefaultTabName());
    }

    public boolean isMissing() {
        return this.isMissing;
    }

    public boolean isValid() {
        return this.isValid;
    }

    private static String getDefaultTabName() {
        if (defaultTabName != null) {
            return defaultTabName;
        }
        String kname = null;
        try {
            String keytab_names = Config.getInstance().get("libdefaults", "default_keytab_name");
            if (keytab_names != null) {
                StringTokenizer st = new StringTokenizer(keytab_names, " ");
                while (st.hasMoreTokens() && !new File(kname = KeyTab.normalize(st.nextToken())).exists()) {
                }
            }
        }
        catch (KrbException e) {
            kname = null;
        }
        if (kname == null) {
            String user_home = AccessController.doPrivileged(new GetPropertyAction("user.home"));
            if (user_home == null) {
                user_home = AccessController.doPrivileged(new GetPropertyAction("user.dir"));
            }
            kname = user_home + File.separator + "krb5.keytab";
        }
        defaultTabName = kname;
        return kname;
    }

    public static String normalize(String name) {
        String kname = name.length() >= 5 && name.substring(0, 5).equalsIgnoreCase("FILE:") ? name.substring(5) : (name.length() >= 9 && name.substring(0, 9).equalsIgnoreCase("ANY:FILE:") ? name.substring(9) : (name.length() >= 7 && name.substring(0, 7).equalsIgnoreCase("SRVTAB:") ? name.substring(7) : name));
        return kname;
    }

    private void load(KeyTabInputStream kis) throws IOException, RealmException {
        this.entries.clear();
        this.kt_vno = kis.readVersion();
        if (this.kt_vno == 1281) {
            kis.setNativeByteOrder();
        }
        int entryLength = 0;
        while (kis.available() > 0) {
            entryLength = kis.readEntryLength();
            KeyTabEntry entry = kis.readEntry(entryLength, this.kt_vno);
            if (DEBUG) {
                System.out.println(">>> KeyTab: load() entry length: " + entryLength + "; type: " + (entry != null ? entry.keyType : 0));
            }
            if (entry == null) continue;
            this.entries.addElement(entry);
        }
    }

    public PrincipalName getOneName() {
        int size = this.entries.size();
        return size > 0 ? this.entries.elementAt((int)(size - 1)).service : null;
    }

    public EncryptionKey[] readServiceKeys(PrincipalName service) {
        int size = this.entries.size();
        ArrayList<EncryptionKey> keys = new ArrayList<EncryptionKey>(size);
        if (DEBUG) {
            System.out.println("Looking for keys for: " + service);
        }
        for (int i = size - 1; i >= 0; --i) {
            KeyTabEntry entry = this.entries.elementAt(i);
            if (!entry.service.match(service)) continue;
            if (EType.isSupported(entry.keyType)) {
                EncryptionKey key = new EncryptionKey(entry.keyblock, entry.keyType, new Integer(entry.keyVersion));
                keys.add(key);
                if (!DEBUG) continue;
                System.out.println("Added key: " + entry.keyType + "version: " + entry.keyVersion);
                continue;
            }
            if (!DEBUG) continue;
            System.out.println("Found unsupported keytype (" + entry.keyType + ") for " + service);
        }
        size = keys.size();
        EncryptionKey[] retVal = keys.toArray(new EncryptionKey[size]);
        Arrays.sort(retVal, new Comparator<EncryptionKey>(){

            @Override
            public int compare(EncryptionKey o1, EncryptionKey o2) {
                return o2.getKeyVersionNumber() - o1.getKeyVersionNumber();
            }
        });
        return retVal;
    }

    public boolean findServiceEntry(PrincipalName service) {
        for (int i = 0; i < this.entries.size(); ++i) {
            KeyTabEntry entry = this.entries.elementAt(i);
            if (!entry.service.match(service)) continue;
            if (EType.isSupported(entry.keyType)) {
                return true;
            }
            if (!DEBUG) continue;
            System.out.println("Found unsupported keytype (" + entry.keyType + ") for " + service);
        }
        return false;
    }

    public String tabName() {
        return this.tabName;
    }

    public void addEntry(PrincipalName service, char[] psswd, int kvno, boolean append) throws KrbException {
        this.addEntry(service, service.getSalt(), psswd, kvno, append);
    }

    public void addEntry(PrincipalName service, String salt, char[] psswd, int kvno, boolean append) throws KrbException {
        int i;
        EncryptionKey[] encKeys = EncryptionKey.acquireSecretKeys(psswd, salt);
        int maxKvno = 0;
        for (i = this.entries.size() - 1; i >= 0; --i) {
            KeyTabEntry e = this.entries.get(i);
            if (!e.service.match(service)) continue;
            if (e.keyVersion > maxKvno) {
                maxKvno = e.keyVersion;
            }
            if (append && e.keyVersion != kvno) continue;
            this.entries.removeElementAt(i);
        }
        if (kvno == -1) {
            kvno = maxKvno + 1;
        }
        for (i = 0; encKeys != null && i < encKeys.length; ++i) {
            int keyType = encKeys[i].getEType();
            byte[] keyValue = encKeys[i].getBytes();
            KeyTabEntry newEntry = new KeyTabEntry(service, service.getRealm(), new KerberosTime(System.currentTimeMillis()), kvno, keyType, keyValue);
            this.entries.addElement(newEntry);
        }
    }

    public KeyTabEntry[] getEntries() {
        KeyTabEntry[] kentries = new KeyTabEntry[this.entries.size()];
        for (int i = 0; i < kentries.length; ++i) {
            kentries[i] = this.entries.elementAt(i);
        }
        return kentries;
    }

    public static synchronized KeyTab create() throws IOException, RealmException {
        String dname = KeyTab.getDefaultTabName();
        return KeyTab.create(dname);
    }

    public static synchronized KeyTab create(String name) throws IOException, RealmException {
        try (KeyTabOutputStream kos = new KeyTabOutputStream(new FileOutputStream(name));){
            kos.writeVersion(1282);
        }
        return new KeyTab(name);
    }

    public synchronized void save() throws IOException {
        try (KeyTabOutputStream kos = new KeyTabOutputStream(new FileOutputStream(this.tabName));){
            kos.writeVersion(this.kt_vno);
            for (int i = 0; i < this.entries.size(); ++i) {
                kos.writeEntry(this.entries.elementAt(i));
            }
        }
    }

    public int deleteEntries(PrincipalName service, int etype, int kvno) {
        int n;
        KeyTabEntry e;
        int i;
        int count = 0;
        HashMap<Integer, Integer> highest = new HashMap<Integer, Integer>();
        for (i = this.entries.size() - 1; i >= 0; --i) {
            e = this.entries.get(i);
            if (!service.match(e.getService()) || etype != -1 && e.keyType != etype) continue;
            if (kvno == -2) {
                if (highest.containsKey(e.keyType)) {
                    n = (Integer)highest.get(e.keyType);
                    if (e.keyVersion <= n) continue;
                    highest.put(e.keyType, e.keyVersion);
                    continue;
                }
                highest.put(e.keyType, e.keyVersion);
                continue;
            }
            if (kvno != -1 && e.keyVersion != kvno) continue;
            this.entries.removeElementAt(i);
            ++count;
        }
        if (kvno == -2) {
            for (i = this.entries.size() - 1; i >= 0; --i) {
                e = this.entries.get(i);
                if (!service.match(e.getService()) || etype != -1 && e.keyType != etype || e.keyVersion == (n = ((Integer)highest.get(e.keyType)).intValue())) continue;
                this.entries.removeElementAt(i);
                ++count;
            }
        }
        return count;
    }

    public synchronized void createVersion(File file) throws IOException {
        try (KeyTabOutputStream kos = new KeyTabOutputStream(new FileOutputStream(file));){
            kos.write16(1282);
        }
    }
}

