/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.InterruptedByTimeoutException;
import java.nio.channels.ShutdownChannelGroupException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import sun.misc.Unsafe;
import sun.nio.ch.AsynchronousChannelGroupImpl;
import sun.nio.ch.AsynchronousSocketChannelImpl;
import sun.nio.ch.CompletedFuture;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Invoker;
import sun.nio.ch.Iocp;
import sun.nio.ch.Net;
import sun.nio.ch.PendingFuture;
import sun.nio.ch.PendingIoCache;
import sun.nio.ch.Util;

class WindowsAsynchronousSocketChannelImpl
extends AsynchronousSocketChannelImpl
implements Iocp.OverlappedChannel {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static int addressSize = unsafe.addressSize();
    private static final int SIZEOF_WSABUF = WindowsAsynchronousSocketChannelImpl.dependsArch(8, 16);
    private static final int OFFSETOF_LEN = 0;
    private static final int OFFSETOF_BUF = WindowsAsynchronousSocketChannelImpl.dependsArch(4, 8);
    private static final int MAX_WSABUF = 16;
    private static final int SIZEOF_WSABUFARRAY = 16 * SIZEOF_WSABUF;
    final long handle;
    private final Iocp iocp;
    private final int completionKey;
    private final PendingIoCache ioCache;
    private final long readBufferArray;
    private final long writeBufferArray;

    private static int dependsArch(int value32, int value64) {
        return addressSize == 4 ? value32 : value64;
    }

    WindowsAsynchronousSocketChannelImpl(Iocp iocp, boolean failIfGroupShutdown) throws IOException {
        super(iocp);
        long h = IOUtil.fdVal(this.fd);
        int key = 0;
        try {
            key = iocp.associate(this, h);
        }
        catch (ShutdownChannelGroupException x) {
            if (failIfGroupShutdown) {
                WindowsAsynchronousSocketChannelImpl.closesocket0(h);
                throw x;
            }
        }
        catch (IOException x) {
            WindowsAsynchronousSocketChannelImpl.closesocket0(h);
            throw x;
        }
        this.handle = h;
        this.iocp = iocp;
        this.completionKey = key;
        this.ioCache = new PendingIoCache();
        this.readBufferArray = unsafe.allocateMemory(SIZEOF_WSABUFARRAY);
        this.writeBufferArray = unsafe.allocateMemory(SIZEOF_WSABUFARRAY);
    }

    WindowsAsynchronousSocketChannelImpl(Iocp iocp) throws IOException {
        this(iocp, true);
    }

    @Override
    public AsynchronousChannelGroupImpl group() {
        return this.iocp;
    }

    @Override
    public <V, A> PendingFuture<V, A> getByOverlapped(long overlapped) {
        return this.ioCache.remove(overlapped);
    }

    long handle() {
        return this.handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setConnected(InetSocketAddress localAddress, InetSocketAddress remoteAddress) {
        Object object = this.stateLock;
        synchronized (object) {
            this.state = 2;
            this.localAddress = localAddress;
            this.remoteAddress = remoteAddress;
        }
    }

    @Override
    void implClose() throws IOException {
        WindowsAsynchronousSocketChannelImpl.closesocket0(this.handle);
        this.ioCache.close();
        unsafe.freeMemory(this.readBufferArray);
        unsafe.freeMemory(this.writeBufferArray);
        if (this.completionKey != 0) {
            this.iocp.disassociate(this.completionKey);
        }
    }

    @Override
    public void onCancel(PendingFuture<?, ?> task) {
        if (task.getContext() instanceof ConnectTask) {
            this.killConnect();
        }
        if (task.getContext() instanceof ReadTask) {
            this.killReading();
        }
        if (task.getContext() instanceof WriteTask) {
            this.killWriting();
        }
    }

    private void doPrivilegedBind(final SocketAddress sa) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    WindowsAsynchronousSocketChannelImpl.this.bind(sa);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <A> Future<Void> implConnect(SocketAddress remote, A attachment, CompletionHandler<Void, ? super A> handler) {
        if (!this.isOpen()) {
            ClosedChannelException exc = new ClosedChannelException();
            if (handler == null) {
                return CompletedFuture.withFailure(exc);
            }
            Invoker.invoke(this, handler, attachment, null, exc);
            return null;
        }
        InetSocketAddress isa = Net.checkAddress(remote);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkConnect(isa.getAddress().getHostAddress(), isa.getPort());
        }
        IOException bindException = null;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                throw new AlreadyConnectedException();
            }
            if (this.state == 1) {
                throw new ConnectionPendingException();
            }
            if (this.localAddress == null) {
                try {
                    InetSocketAddress any = new InetSocketAddress(0);
                    if (sm == null) {
                        this.bind(any);
                    } else {
                        this.doPrivilegedBind(any);
                    }
                }
                catch (IOException x) {
                    bindException = x;
                }
            }
            if (bindException == null) {
                this.state = 1;
            }
        }
        if (bindException != null) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (handler == null) {
                return CompletedFuture.withFailure(bindException);
            }
            Invoker.invoke(this, handler, attachment, null, bindException);
            return null;
        }
        PendingFuture<Void, A> result = new PendingFuture<Void, A>(this, handler, attachment);
        ConnectTask<A> task = new ConnectTask<A>(isa, result);
        result.setContext(task);
        if (Iocp.supportsThreadAgnosticIo()) {
            task.run();
        } else {
            Invoker.invokeOnThreadInThreadPool(this, task);
        }
        return result;
    }

    @Override
    <V extends Number, A> Future<V> implRead(boolean isScatteringRead, ByteBuffer dst, ByteBuffer[] dsts, long timeout, TimeUnit unit, A attachment, CompletionHandler<V, ? super A> handler) {
        PendingFuture<V, A> result = new PendingFuture<V, A>(this, handler, attachment);
        ByteBuffer[] bufs = isScatteringRead ? dsts : new ByteBuffer[]{dst};
        final ReadTask<V, A> readTask = new ReadTask<V, A>(bufs, isScatteringRead, result);
        result.setContext(readTask);
        if (timeout > 0L) {
            Future<?> timeoutTask = this.iocp.schedule(new Runnable(){

                @Override
                public void run() {
                    readTask.timeout();
                }
            }, timeout, unit);
            result.setTimeoutTask(timeoutTask);
        }
        if (Iocp.supportsThreadAgnosticIo()) {
            readTask.run();
        } else {
            Invoker.invokeOnThreadInThreadPool(this, readTask);
        }
        return result;
    }

    @Override
    <V extends Number, A> Future<V> implWrite(boolean gatheringWrite, ByteBuffer src, ByteBuffer[] srcs, long timeout, TimeUnit unit, A attachment, CompletionHandler<V, ? super A> handler) {
        PendingFuture<V, A> result = new PendingFuture<V, A>(this, handler, attachment);
        ByteBuffer[] bufs = gatheringWrite ? srcs : new ByteBuffer[]{src};
        final WriteTask<V, A> writeTask = new WriteTask<V, A>(bufs, gatheringWrite, result);
        result.setContext(writeTask);
        if (timeout > 0L) {
            Future<?> timeoutTask = this.iocp.schedule(new Runnable(){

                @Override
                public void run() {
                    writeTask.timeout();
                }
            }, timeout, unit);
            result.setTimeoutTask(timeoutTask);
        }
        if (Iocp.supportsThreadAgnosticIo()) {
            writeTask.run();
        } else {
            Invoker.invokeOnThreadInThreadPool(this, writeTask);
        }
        return result;
    }

    private static native void initIDs();

    private static native int connect0(long var0, boolean var2, InetAddress var3, int var4, long var5) throws IOException;

    private static native void updateConnectContext(long var0) throws IOException;

    private static native int read0(long var0, int var2, long var3, long var5) throws IOException;

    private static native int write0(long var0, int var2, long var3, long var5) throws IOException;

    private static native void shutdown0(long var0, int var2) throws IOException;

    private static native void closesocket0(long var0) throws IOException;

    static {
        IOUtil.load();
        WindowsAsynchronousSocketChannelImpl.initIDs();
    }

    private class WriteTask<V, A>
    implements Runnable,
    Iocp.ResultHandler {
        private final ByteBuffer[] bufs;
        private final int numBufs;
        private final boolean gatheringWrite;
        private final PendingFuture<V, A> result;
        private ByteBuffer[] shadow;

        WriteTask(ByteBuffer[] bufs, boolean gatheringWrite, PendingFuture<V, A> result) {
            this.bufs = bufs;
            this.numBufs = bufs.length > 16 ? 16 : bufs.length;
            this.gatheringWrite = gatheringWrite;
            this.result = result;
        }

        void prepareBuffers() {
            this.shadow = new ByteBuffer[this.numBufs];
            long address = WindowsAsynchronousSocketChannelImpl.this.writeBufferArray;
            for (int i = 0; i < this.numBufs; ++i) {
                long a;
                int rem;
                ByteBuffer src = this.bufs[i];
                int pos = src.position();
                int lim = src.limit();
                assert (pos <= lim);
                int n = rem = pos <= lim ? lim - pos : 0;
                if (!(src instanceof DirectBuffer)) {
                    ByteBuffer bb = Util.getTemporaryDirectBuffer(rem);
                    bb.put(src);
                    bb.flip();
                    src.position(pos);
                    this.shadow[i] = bb;
                    a = ((DirectBuffer)((Object)bb)).address();
                } else {
                    this.shadow[i] = src;
                    a = ((DirectBuffer)((Object)src)).address() + (long)pos;
                }
                unsafe.putAddress(address + (long)OFFSETOF_BUF, a);
                unsafe.putInt(address + 0L, rem);
                address += (long)SIZEOF_WSABUF;
            }
        }

        void updateBuffers(int bytesWritten) {
            for (int i = 0; i < this.numBufs; ++i) {
                int newPosition;
                int lim;
                int len;
                ByteBuffer nextBuffer = this.bufs[i];
                int pos = nextBuffer.position();
                int n = len = pos <= (lim = nextBuffer.limit()) ? lim - pos : lim;
                if (bytesWritten >= len) {
                    bytesWritten -= len;
                    newPosition = pos + len;
                    try {
                        nextBuffer.position(newPosition);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    continue;
                }
                if (bytesWritten <= 0) break;
                assert ((long)(pos + bytesWritten) < Integer.MAX_VALUE);
                newPosition = pos + bytesWritten;
                try {
                    nextBuffer.position(newPosition);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                break;
            }
        }

        void releaseBuffers() {
            for (int i = 0; i < this.numBufs; ++i) {
                if (this.bufs[i] instanceof DirectBuffer) continue;
                Util.releaseTemporaryDirectBuffer(this.shadow[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int n;
            boolean shutdown;
            boolean pending;
            boolean prepared;
            long overlapped;
            block15: {
                block16: {
                    block17: {
                        overlapped = 0L;
                        prepared = false;
                        pending = false;
                        shutdown = false;
                        WindowsAsynchronousSocketChannelImpl.this.begin();
                        this.prepareBuffers();
                        prepared = true;
                        overlapped = WindowsAsynchronousSocketChannelImpl.this.ioCache.add(this.result);
                        n = WindowsAsynchronousSocketChannelImpl.write0(WindowsAsynchronousSocketChannelImpl.this.handle, this.numBufs, WindowsAsynchronousSocketChannelImpl.this.writeBufferArray, overlapped);
                        if (n != -2) break block15;
                        pending = true;
                        if (pending) break block16;
                        if (overlapped == 0L) break block17;
                        WindowsAsynchronousSocketChannelImpl.this.ioCache.remove(overlapped);
                    }
                    if (prepared) {
                        this.releaseBuffers();
                    }
                }
                WindowsAsynchronousSocketChannelImpl.this.end();
                return;
            }
            try {
                try {
                    if (n == -1) {
                        shutdown = true;
                        throw new ClosedChannelException();
                    }
                    throw new InternalError("Write completed immediately");
                }
                catch (Throwable x2) {
                    IOException x2;
                    WindowsAsynchronousSocketChannelImpl.this.enableWriting();
                    if (!shutdown && x2 instanceof ClosedChannelException) {
                        x2 = new AsynchronousCloseException();
                    }
                    if (!(x2 instanceof IOException)) {
                        x2 = new IOException(x2);
                    }
                    this.result.setFailure(x2);
                    if (!pending) {
                        if (overlapped != 0L) {
                            WindowsAsynchronousSocketChannelImpl.this.ioCache.remove(overlapped);
                        }
                        if (prepared) {
                            this.releaseBuffers();
                        }
                    }
                    WindowsAsynchronousSocketChannelImpl.this.end();
                }
            }
            catch (Throwable throwable) {
                if (!pending) {
                    if (overlapped != 0L) {
                        WindowsAsynchronousSocketChannelImpl.this.ioCache.remove(overlapped);
                    }
                    if (prepared) {
                        this.releaseBuffers();
                    }
                }
                WindowsAsynchronousSocketChannelImpl.this.end();
                throw throwable;
            }
            Invoker.invoke(this.result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(int bytesTransferred, boolean canInvokeDirect) {
            this.updateBuffers(bytesTransferred);
            this.releaseBuffers();
            PendingFuture<V, A> pendingFuture = this.result;
            synchronized (pendingFuture) {
                if (this.result.isDone()) {
                    return;
                }
                WindowsAsynchronousSocketChannelImpl.this.enableWriting();
                if (this.gatheringWrite) {
                    this.result.setResult(Long.valueOf(bytesTransferred));
                } else {
                    this.result.setResult(bytesTransferred);
                }
            }
            if (canInvokeDirect) {
                Invoker.invokeUnchecked(this.result);
            } else {
                Invoker.invoke(this.result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(int error, IOException x) {
            this.releaseBuffers();
            if (!WindowsAsynchronousSocketChannelImpl.this.isOpen()) {
                x = new AsynchronousCloseException();
            }
            PendingFuture<V, A> pendingFuture = this.result;
            synchronized (pendingFuture) {
                if (this.result.isDone()) {
                    return;
                }
                WindowsAsynchronousSocketChannelImpl.this.enableWriting();
                this.result.setFailure(x);
            }
            Invoker.invoke(this.result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void timeout() {
            PendingFuture<V, A> pendingFuture = this.result;
            synchronized (pendingFuture) {
                if (this.result.isDone()) {
                    return;
                }
                WindowsAsynchronousSocketChannelImpl.this.enableWriting(true);
                this.result.setFailure(new InterruptedByTimeoutException());
            }
            Invoker.invoke(this.result);
        }
    }

    private class ReadTask<V, A>
    implements Runnable,
    Iocp.ResultHandler {
        private final ByteBuffer[] bufs;
        private final int numBufs;
        private final boolean scatteringRead;
        private final PendingFuture<V, A> result;
        private ByteBuffer[] shadow;

        ReadTask(ByteBuffer[] bufs, boolean scatteringRead, PendingFuture<V, A> result) {
            this.bufs = bufs;
            this.numBufs = bufs.length > 16 ? 16 : bufs.length;
            this.scatteringRead = scatteringRead;
            this.result = result;
        }

        void prepareBuffers() {
            this.shadow = new ByteBuffer[this.numBufs];
            long address = WindowsAsynchronousSocketChannelImpl.this.readBufferArray;
            for (int i = 0; i < this.numBufs; ++i) {
                long a;
                int rem;
                ByteBuffer dst = this.bufs[i];
                int pos = dst.position();
                int lim = dst.limit();
                assert (pos <= lim);
                int n = rem = pos <= lim ? lim - pos : 0;
                if (!(dst instanceof DirectBuffer)) {
                    ByteBuffer bb;
                    this.shadow[i] = bb = Util.getTemporaryDirectBuffer(rem);
                    a = ((DirectBuffer)((Object)bb)).address();
                } else {
                    this.shadow[i] = dst;
                    a = ((DirectBuffer)((Object)dst)).address() + (long)pos;
                }
                unsafe.putAddress(address + (long)OFFSETOF_BUF, a);
                unsafe.putInt(address + 0L, rem);
                address += (long)SIZEOF_WSABUF;
            }
        }

        void updateBuffers(int bytesRead) {
            int i;
            for (i = 0; i < this.numBufs; ++i) {
                int newPosition;
                ByteBuffer nextBuffer = this.shadow[i];
                int pos = nextBuffer.position();
                int len = nextBuffer.remaining();
                if (bytesRead >= len) {
                    bytesRead -= len;
                    newPosition = pos + len;
                    try {
                        nextBuffer.position(newPosition);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    continue;
                }
                if (bytesRead <= 0) break;
                assert ((long)(pos + bytesRead) < Integer.MAX_VALUE);
                newPosition = pos + bytesRead;
                try {
                    nextBuffer.position(newPosition);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                break;
            }
            for (i = 0; i < this.numBufs; ++i) {
                if (this.bufs[i] instanceof DirectBuffer) continue;
                this.shadow[i].flip();
                try {
                    this.bufs[i].put(this.shadow[i]);
                    continue;
                }
                catch (BufferOverflowException bufferOverflowException) {
                    // empty catch block
                }
            }
        }

        void releaseBuffers() {
            for (int i = 0; i < this.numBufs; ++i) {
                if (this.bufs[i] instanceof DirectBuffer) continue;
                Util.releaseTemporaryDirectBuffer(this.shadow[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block15: {
                long overlapped = 0L;
                boolean prepared = false;
                boolean pending = false;
                try {
                    WindowsAsynchronousSocketChannelImpl.this.begin();
                    this.prepareBuffers();
                    prepared = true;
                    overlapped = WindowsAsynchronousSocketChannelImpl.this.ioCache.add(this.result);
                    int n = WindowsAsynchronousSocketChannelImpl.read0(WindowsAsynchronousSocketChannelImpl.this.handle, this.numBufs, WindowsAsynchronousSocketChannelImpl.this.readBufferArray, overlapped);
                    if (n == -2) {
                        pending = true;
                        return;
                    }
                    if (n == -1) {
                        WindowsAsynchronousSocketChannelImpl.this.enableReading();
                        if (this.scatteringRead) {
                            this.result.setResult(-1L);
                        } else {
                            this.result.setResult(-1);
                        }
                        break block15;
                    }
                    throw new InternalError("Read completed immediately");
                }
                catch (Throwable x2) {
                    IOException x2;
                    WindowsAsynchronousSocketChannelImpl.this.enableReading();
                    if (x2 instanceof ClosedChannelException) {
                        x2 = new AsynchronousCloseException();
                    }
                    if (!(x2 instanceof IOException)) {
                        x2 = new IOException(x2);
                    }
                    this.result.setFailure(x2);
                }
                finally {
                    if (!pending) {
                        if (overlapped != 0L) {
                            WindowsAsynchronousSocketChannelImpl.this.ioCache.remove(overlapped);
                        }
                        if (prepared) {
                            this.releaseBuffers();
                        }
                    }
                    WindowsAsynchronousSocketChannelImpl.this.end();
                }
            }
            Invoker.invoke(this.result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(int bytesTransferred, boolean canInvokeDirect) {
            if (bytesTransferred == 0) {
                bytesTransferred = -1;
            } else {
                this.updateBuffers(bytesTransferred);
            }
            this.releaseBuffers();
            PendingFuture<V, A> pendingFuture = this.result;
            synchronized (pendingFuture) {
                if (this.result.isDone()) {
                    return;
                }
                WindowsAsynchronousSocketChannelImpl.this.enableReading();
                if (this.scatteringRead) {
                    this.result.setResult(Long.valueOf(bytesTransferred));
                } else {
                    this.result.setResult(bytesTransferred);
                }
            }
            if (canInvokeDirect) {
                Invoker.invokeUnchecked(this.result);
            } else {
                Invoker.invoke(this.result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(int error, IOException x) {
            this.releaseBuffers();
            if (!WindowsAsynchronousSocketChannelImpl.this.isOpen()) {
                x = new AsynchronousCloseException();
            }
            PendingFuture<V, A> pendingFuture = this.result;
            synchronized (pendingFuture) {
                if (this.result.isDone()) {
                    return;
                }
                WindowsAsynchronousSocketChannelImpl.this.enableReading();
                this.result.setFailure(x);
            }
            Invoker.invoke(this.result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void timeout() {
            PendingFuture<V, A> pendingFuture = this.result;
            synchronized (pendingFuture) {
                if (this.result.isDone()) {
                    return;
                }
                WindowsAsynchronousSocketChannelImpl.this.enableReading(true);
                this.result.setFailure(new InterruptedByTimeoutException());
            }
            Invoker.invoke(this.result);
        }
    }

    private class ConnectTask<A>
    implements Runnable,
    Iocp.ResultHandler {
        private final InetSocketAddress remote;
        private final PendingFuture<Void, A> result;

        ConnectTask(InetSocketAddress remote, PendingFuture<Void, A> result) {
            this.remote = remote;
            this.result = result;
        }

        private void closeChannel() {
            try {
                WindowsAsynchronousSocketChannelImpl.this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private IOException toIOException(Throwable x) {
            if (x instanceof IOException) {
                if (x instanceof ClosedChannelException) {
                    x = new AsynchronousCloseException();
                }
                return (IOException)x;
            }
            return new IOException(x);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void afterConnect() throws IOException {
            WindowsAsynchronousSocketChannelImpl.updateConnectContext(WindowsAsynchronousSocketChannelImpl.this.handle);
            Object object = WindowsAsynchronousSocketChannelImpl.this.stateLock;
            synchronized (object) {
                WindowsAsynchronousSocketChannelImpl.this.state = 2;
                WindowsAsynchronousSocketChannelImpl.this.remoteAddress = this.remote;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long overlapped = 0L;
            Throwable exc = null;
            try {
                WindowsAsynchronousSocketChannelImpl.this.begin();
                PendingFuture<Void, A> pendingFuture = this.result;
                synchronized (pendingFuture) {
                    block12: {
                        overlapped = WindowsAsynchronousSocketChannelImpl.this.ioCache.add(this.result);
                        int n = WindowsAsynchronousSocketChannelImpl.connect0(WindowsAsynchronousSocketChannelImpl.this.handle, Net.isIPv6Available(), this.remote.getAddress(), this.remote.getPort(), overlapped);
                        if (n != -2) break block12;
                        return;
                    }
                    this.afterConnect();
                    this.result.setResult(null);
                }
            }
            catch (Throwable x) {
                if (overlapped != 0L) {
                    WindowsAsynchronousSocketChannelImpl.this.ioCache.remove(overlapped);
                }
                exc = x;
            }
            finally {
                WindowsAsynchronousSocketChannelImpl.this.end();
            }
            if (exc != null) {
                this.closeChannel();
                this.result.setFailure(this.toIOException(exc));
            }
            Invoker.invoke(this.result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(int bytesTransferred, boolean canInvokeDirect) {
            Throwable exc = null;
            try {
                WindowsAsynchronousSocketChannelImpl.this.begin();
                this.afterConnect();
                this.result.setResult(null);
            }
            catch (Throwable x) {
                exc = x;
            }
            finally {
                WindowsAsynchronousSocketChannelImpl.this.end();
            }
            if (exc != null) {
                this.closeChannel();
                this.result.setFailure(this.toIOException(exc));
            }
            if (canInvokeDirect) {
                Invoker.invokeUnchecked(this.result);
            } else {
                Invoker.invoke(this.result);
            }
        }

        @Override
        public void failed(int error, IOException x) {
            if (WindowsAsynchronousSocketChannelImpl.this.isOpen()) {
                this.closeChannel();
                this.result.setFailure(x);
            } else {
                this.result.setFailure(new AsynchronousCloseException());
            }
            Invoker.invoke(this.result);
        }
    }
}

