/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AcceptPendingException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.ShutdownChannelGroupException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import sun.misc.Unsafe;
import sun.nio.ch.AsynchronousChannelGroupImpl;
import sun.nio.ch.AsynchronousServerSocketChannelImpl;
import sun.nio.ch.CompletedFuture;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Invoker;
import sun.nio.ch.Iocp;
import sun.nio.ch.Net;
import sun.nio.ch.PendingFuture;
import sun.nio.ch.PendingIoCache;
import sun.nio.ch.WindowsAsynchronousSocketChannelImpl;

class WindowsAsynchronousServerSocketChannelImpl
extends AsynchronousServerSocketChannelImpl
implements Iocp.OverlappedChannel {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int DATA_BUFFER_SIZE = 88;
    private final long handle;
    private final int completionKey;
    private final Iocp iocp;
    private final PendingIoCache ioCache;
    private final long dataBuffer;
    private AtomicBoolean accepting = new AtomicBoolean();

    WindowsAsynchronousServerSocketChannelImpl(Iocp iocp) throws IOException {
        super(iocp);
        int key;
        long h = IOUtil.fdVal(this.fd);
        try {
            key = iocp.associate(this, h);
        }
        catch (IOException x) {
            WindowsAsynchronousServerSocketChannelImpl.closesocket0(h);
            throw x;
        }
        this.handle = h;
        this.completionKey = key;
        this.iocp = iocp;
        this.ioCache = new PendingIoCache();
        this.dataBuffer = unsafe.allocateMemory(88L);
    }

    @Override
    public <V, A> PendingFuture<V, A> getByOverlapped(long overlapped) {
        return this.ioCache.remove(overlapped);
    }

    @Override
    void implClose() throws IOException {
        WindowsAsynchronousServerSocketChannelImpl.closesocket0(this.handle);
        this.ioCache.close();
        this.iocp.disassociate(this.completionKey);
        unsafe.freeMemory(this.dataBuffer);
    }

    @Override
    public AsynchronousChannelGroupImpl group() {
        return this.iocp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Future<AsynchronousSocketChannel> implAccept(Object attachment, CompletionHandler<AsynchronousSocketChannel, Object> handler) {
        if (!this.isOpen()) {
            ClosedChannelException exc = new ClosedChannelException();
            if (handler == null) {
                return CompletedFuture.withFailure(exc);
            }
            Invoker.invokeIndirectly(this, handler, attachment, null, exc);
            return null;
        }
        if (this.isAcceptKilled()) {
            throw new RuntimeException("Accept not allowed due to cancellation");
        }
        if (this.localAddress == null) {
            throw new NotYetBoundException();
        }
        WindowsAsynchronousSocketChannelImpl ch = null;
        IOException ioe = null;
        try {
            this.begin();
            ch = new WindowsAsynchronousSocketChannelImpl(this.iocp, false);
        }
        catch (IOException x) {
            ioe = x;
        }
        finally {
            this.end();
        }
        if (ioe != null) {
            if (handler == null) {
                return CompletedFuture.withFailure(ioe);
            }
            Invoker.invokeIndirectly(this, handler, attachment, null, ioe);
            return null;
        }
        AccessControlContext acc = System.getSecurityManager() == null ? null : AccessController.getContext();
        PendingFuture<AsynchronousSocketChannel, Object> result = new PendingFuture<AsynchronousSocketChannel, Object>(this, handler, attachment);
        AcceptTask task = new AcceptTask(ch, acc, result);
        result.setContext(task);
        if (!this.accepting.compareAndSet(false, true)) {
            throw new AcceptPendingException();
        }
        if (Iocp.supportsThreadAgnosticIo()) {
            task.run();
        } else {
            Invoker.invokeOnThreadInThreadPool(this, task);
        }
        return result;
    }

    private static native void initIDs();

    private static native int accept0(long var0, long var2, long var4, long var6) throws IOException;

    private static native void updateAcceptContext(long var0, long var2) throws IOException;

    private static native void closesocket0(long var0) throws IOException;

    static {
        IOUtil.load();
        WindowsAsynchronousServerSocketChannelImpl.initIDs();
    }

    private class AcceptTask
    implements Runnable,
    Iocp.ResultHandler {
        private final WindowsAsynchronousSocketChannelImpl channel;
        private final AccessControlContext acc;
        private final PendingFuture<AsynchronousSocketChannel, Object> result;

        AcceptTask(WindowsAsynchronousSocketChannelImpl channel, AccessControlContext acc, PendingFuture<AsynchronousSocketChannel, Object> result) {
            this.channel = channel;
            this.acc = acc;
            this.result = result;
        }

        void enableAccept() {
            WindowsAsynchronousServerSocketChannelImpl.this.accepting.set(false);
        }

        void closeChildChannel() {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        void finishAccept() throws IOException {
            WindowsAsynchronousServerSocketChannelImpl.updateAcceptContext(WindowsAsynchronousServerSocketChannelImpl.this.handle, this.channel.handle());
            InetSocketAddress local = Net.localAddress(this.channel.fd);
            final InetSocketAddress remote = Net.remoteAddress(this.channel.fd);
            this.channel.setConnected(local, remote);
            if (this.acc != null) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        SecurityManager sm = System.getSecurityManager();
                        sm.checkAccept(remote.getAddress().getHostAddress(), remote.getPort());
                        return null;
                    }
                }, this.acc);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long overlapped = 0L;
            try {
                WindowsAsynchronousServerSocketChannelImpl.this.begin();
                try {
                    this.channel.begin();
                    PendingFuture<AsynchronousSocketChannel, Object> pendingFuture = this.result;
                    synchronized (pendingFuture) {
                        block18: {
                            overlapped = WindowsAsynchronousServerSocketChannelImpl.this.ioCache.add(this.result);
                            int n = WindowsAsynchronousServerSocketChannelImpl.accept0(WindowsAsynchronousServerSocketChannelImpl.this.handle, this.channel.handle(), overlapped, WindowsAsynchronousServerSocketChannelImpl.this.dataBuffer);
                            if (n != -2) break block18;
                            return;
                        }
                        this.finishAccept();
                        this.enableAccept();
                        this.result.setResult(this.channel);
                    }
                }
                finally {
                    this.channel.end();
                }
            }
            catch (Throwable x2) {
                IOException x2;
                if (overlapped != 0L) {
                    WindowsAsynchronousServerSocketChannelImpl.this.ioCache.remove(overlapped);
                }
                this.closeChildChannel();
                if (x2 instanceof ClosedChannelException) {
                    x2 = new AsynchronousCloseException();
                }
                if (!(x2 instanceof IOException) && !(x2 instanceof SecurityException)) {
                    x2 = new IOException(x2);
                }
                this.enableAccept();
                this.result.setFailure(x2);
            }
            finally {
                WindowsAsynchronousServerSocketChannelImpl.this.end();
            }
            if (this.result.isCancelled()) {
                this.closeChildChannel();
            }
            Invoker.invokeIndirectly(this.result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(int bytesTransferred, boolean canInvokeDirect) {
            try {
                if (WindowsAsynchronousServerSocketChannelImpl.this.iocp.isShutdown()) {
                    throw new IOException(new ShutdownChannelGroupException());
                }
                try {
                    WindowsAsynchronousServerSocketChannelImpl.this.begin();
                    try {
                        this.channel.begin();
                        this.finishAccept();
                    }
                    finally {
                        this.channel.end();
                    }
                }
                finally {
                    WindowsAsynchronousServerSocketChannelImpl.this.end();
                }
                this.enableAccept();
                this.result.setResult(this.channel);
            }
            catch (Throwable x2) {
                IOException x2;
                this.enableAccept();
                this.closeChildChannel();
                if (x2 instanceof ClosedChannelException) {
                    x2 = new AsynchronousCloseException();
                }
                if (!(x2 instanceof IOException) && !(x2 instanceof SecurityException)) {
                    x2 = new IOException(x2);
                }
                this.result.setFailure(x2);
            }
            if (this.result.isCancelled()) {
                this.closeChildChannel();
            }
            Invoker.invokeIndirectly(this.result);
        }

        @Override
        public void failed(int error, IOException x) {
            this.enableAccept();
            this.closeChildChannel();
            if (WindowsAsynchronousServerSocketChannelImpl.this.isOpen()) {
                this.result.setFailure(x);
            } else {
                this.result.setFailure(new AsynchronousCloseException());
            }
            Invoker.invokeIndirectly(this.result);
        }
    }
}

