/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class AWTCharset
extends Charset {
    protected Charset awtCs;
    protected Charset javaCs;

    public AWTCharset(String awtCsName, Charset javaCs) {
        super(awtCsName, null);
        this.javaCs = javaCs;
        this.awtCs = this;
    }

    @Override
    public boolean contains(Charset cs) {
        if (this.javaCs == null) {
            return false;
        }
        return this.javaCs.contains(cs);
    }

    @Override
    public CharsetEncoder newEncoder() {
        if (this.javaCs == null) {
            throw new Error("Encoder is not supported by this Charset");
        }
        return new Encoder(this.javaCs.newEncoder());
    }

    @Override
    public CharsetDecoder newDecoder() {
        if (this.javaCs == null) {
            throw new Error("Decoder is not supported by this Charset");
        }
        return new Decoder(this.javaCs.newDecoder());
    }

    public class Decoder
    extends CharsetDecoder {
        protected CharsetDecoder dec;
        private String nr;
        ByteBuffer fbb;

        protected Decoder() {
            this(this$0.javaCs.newDecoder());
        }

        protected Decoder(CharsetDecoder dec) {
            super(AWTCharset.this.awtCs, dec.averageCharsPerByte(), dec.maxCharsPerByte());
            this.fbb = ByteBuffer.allocate(0);
            this.dec = dec;
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
            return this.dec.decode(src, dst, true);
        }

        @Override
        protected CoderResult implFlush(CharBuffer out) {
            this.dec.decode(this.fbb, out, true);
            return this.dec.flush(out);
        }

        @Override
        protected void implReset() {
            this.dec.reset();
        }

        @Override
        protected void implReplaceWith(String newReplacement) {
            if (this.dec != null) {
                this.dec.replaceWith(newReplacement);
            }
        }

        @Override
        protected void implOnMalformedInput(CodingErrorAction newAction) {
            this.dec.onMalformedInput(newAction);
        }

        @Override
        protected void implOnUnmappableCharacter(CodingErrorAction newAction) {
            this.dec.onUnmappableCharacter(newAction);
        }
    }

    public class Encoder
    extends CharsetEncoder {
        protected CharsetEncoder enc;

        protected Encoder() {
            this(this$0.javaCs.newEncoder());
        }

        protected Encoder(CharsetEncoder enc) {
            super(AWTCharset.this.awtCs, enc.averageBytesPerChar(), enc.maxBytesPerChar());
            this.enc = enc;
        }

        @Override
        public boolean canEncode(char c) {
            return this.enc.canEncode(c);
        }

        @Override
        public boolean canEncode(CharSequence cs) {
            return this.enc.canEncode(cs);
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
            return this.enc.encode(src, dst, true);
        }

        @Override
        protected CoderResult implFlush(ByteBuffer out) {
            return this.enc.flush(out);
        }

        @Override
        protected void implReset() {
            this.enc.reset();
        }

        @Override
        protected void implReplaceWith(byte[] newReplacement) {
            if (this.enc != null) {
                this.enc.replaceWith(newReplacement);
            }
        }

        @Override
        protected void implOnMalformedInput(CodingErrorAction newAction) {
            this.enc.onMalformedInput(newAction);
        }

        @Override
        protected void implOnUnmappableCharacter(CodingErrorAction newAction) {
            this.enc.onUnmappableCharacter(newAction);
        }

        @Override
        public boolean isLegalReplacement(byte[] repl) {
            return true;
        }
    }
}

