/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.AbstractPlainSocketImpl;
import java.net.InetAddress;
import java.net.InetAddressContainer;
import java.net.SocketException;
import java.net.SocketImpl;
import sun.net.ResourceManager;

class TwoStacksPlainSocketImpl
extends AbstractPlainSocketImpl {
    private FileDescriptor fd1;
    private InetAddress anyLocalBoundAddr = null;
    private int lastfd = -1;
    private final boolean exclusiveBind;
    private boolean isReuseAddress;

    public TwoStacksPlainSocketImpl(boolean exclBind) {
        this.exclusiveBind = exclBind;
    }

    public TwoStacksPlainSocketImpl(FileDescriptor fd, boolean exclBind) {
        this.fd = fd;
        this.exclusiveBind = exclBind;
    }

    @Override
    protected synchronized void create(boolean stream) throws IOException {
        this.fd1 = new FileDescriptor();
        try {
            super.create(stream);
        }
        catch (IOException e) {
            this.fd1 = null;
            throw e;
        }
    }

    @Override
    protected synchronized void bind(InetAddress address, int lport) throws IOException {
        super.bind(address, lport);
        if (address.isAnyLocalAddress()) {
            this.anyLocalBoundAddr = address;
        }
    }

    @Override
    public Object getOption(int opt) throws SocketException {
        if (this.isClosedOrPending()) {
            throw new SocketException("Socket Closed");
        }
        if (opt == 15) {
            if (this.fd != null && this.fd1 != null) {
                return this.anyLocalBoundAddr;
            }
            InetAddressContainer in = new InetAddressContainer();
            this.socketGetOption(opt, in);
            return in.addr;
        }
        if (opt == 4 && this.exclusiveBind) {
            return this.isReuseAddress;
        }
        return super.getOption(opt);
    }

    @Override
    void socketBind(InetAddress address, int port) throws IOException {
        this.socketBind(address, port, this.exclusiveBind);
    }

    @Override
    void socketSetOption(int opt, boolean on, Object value) throws SocketException {
        if (opt == 4 && this.exclusiveBind) {
            this.isReuseAddress = on;
        } else {
            this.socketNativeSetOption(opt, on, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() throws IOException {
        Object object = this.fdLock;
        synchronized (object) {
            if (this.fd != null || this.fd1 != null) {
                if (!this.stream) {
                    ResourceManager.afterUdpClose();
                }
                if (this.fdUseCount == 0) {
                    if (this.closePending) {
                        return;
                    }
                    this.closePending = true;
                    this.socketClose();
                    this.fd = null;
                    this.fd1 = null;
                    return;
                }
                if (!this.closePending) {
                    this.closePending = true;
                    --this.fdUseCount;
                    this.socketClose();
                }
            }
        }
    }

    @Override
    void reset() throws IOException {
        if (this.fd != null || this.fd1 != null) {
            this.socketClose();
        }
        this.fd = null;
        this.fd1 = null;
        super.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosedOrPending() {
        Object object = this.fdLock;
        synchronized (object) {
            return this.closePending || this.fd == null && this.fd1 == null;
            {
            }
        }
    }

    static native void initProto();

    @Override
    native void socketCreate(boolean var1) throws IOException;

    @Override
    native void socketConnect(InetAddress var1, int var2, int var3) throws IOException;

    native void socketBind(InetAddress var1, int var2, boolean var3) throws IOException;

    @Override
    native void socketListen(int var1) throws IOException;

    @Override
    native void socketAccept(SocketImpl var1) throws IOException;

    @Override
    native int socketAvailable() throws IOException;

    @Override
    native void socketClose0(boolean var1) throws IOException;

    @Override
    native void socketShutdown(int var1) throws IOException;

    native void socketNativeSetOption(int var1, boolean var2, Object var3) throws SocketException;

    @Override
    native int socketGetOption(int var1, Object var2) throws SocketException;

    @Override
    native void socketSendUrgentData(int var1) throws IOException;

    static {
        TwoStacksPlainSocketImpl.initProto();
    }
}

