/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.io.FilePermission;
import java.io.Serializable;
import java.lang.invoke.AbstractValidatingLambdaMetafactory;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.ProxyClassesDumper;
import java.lang.invoke.TypeConvertingMethodAdapter;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedHashSet;
import java.util.PropertyPermission;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.Type;
import sun.invoke.util.BytecodeDescriptor;
import sun.misc.Unsafe;
import sun.security.action.GetPropertyAction;

final class InnerClassLambdaMetafactory
extends AbstractValidatingLambdaMetafactory {
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    private static final int CLASSFILE_VERSION = 52;
    private static final String METHOD_DESCRIPTOR_VOID = Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]);
    private static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private static final String NAME_CTOR = "<init>";
    private static final String NAME_FACTORY = "get$Lambda";
    private static final String NAME_SERIALIZED_LAMBDA = "java/lang/invoke/SerializedLambda";
    private static final String NAME_NOT_SERIALIZABLE_EXCEPTION = "java/io/NotSerializableException";
    private static final String DESCR_METHOD_WRITE_REPLACE = "()Ljava/lang/Object;";
    private static final String DESCR_METHOD_WRITE_OBJECT = "(Ljava/io/ObjectOutputStream;)V";
    private static final String DESCR_METHOD_READ_OBJECT = "(Ljava/io/ObjectInputStream;)V";
    private static final String NAME_METHOD_WRITE_REPLACE = "writeReplace";
    private static final String NAME_METHOD_READ_OBJECT = "readObject";
    private static final String NAME_METHOD_WRITE_OBJECT = "writeObject";
    private static final String DESCR_CTOR_SERIALIZED_LAMBDA = MethodType.methodType(Void.TYPE, Class.class, String.class, String.class, String.class, Integer.TYPE, String.class, String.class, String.class, String.class, Object[].class).toMethodDescriptorString();
    private static final String DESCR_CTOR_NOT_SERIALIZABLE_EXCEPTION = MethodType.methodType(Void.TYPE, String.class).toMethodDescriptorString();
    private static final String[] SER_HOSTILE_EXCEPTIONS = new String[]{"java/io/NotSerializableException"};
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final AtomicInteger counter = new AtomicInteger(0);
    private static final ProxyClassesDumper dumper;
    private final String implMethodClassName;
    private final String implMethodName;
    private final String implMethodDesc;
    private final Class<?> implMethodReturnClass;
    private final MethodType constructorType;
    private final ClassWriter cw;
    private final String[] argNames;
    private final String[] argDescs;
    private final String lambdaClassName;

    public InnerClassLambdaMetafactory(MethodHandles.Lookup caller, MethodType invokedType, String samMethodName, MethodType samMethodType, MethodHandle implMethod, MethodType instantiatedMethodType, boolean isSerializable, Class<?>[] markerInterfaces, MethodType[] additionalBridges) throws LambdaConversionException {
        super(caller, invokedType, samMethodName, samMethodType, implMethod, instantiatedMethodType, isSerializable, markerInterfaces, additionalBridges);
        this.implMethodClassName = this.implDefiningClass.getName().replace('.', '/');
        this.implMethodName = this.implInfo.getName();
        this.implMethodDesc = this.implMethodType.toMethodDescriptorString();
        this.implMethodReturnClass = this.implKind == 8 ? this.implDefiningClass : this.implMethodType.returnType();
        this.constructorType = invokedType.changeReturnType(Void.TYPE);
        this.lambdaClassName = this.targetClass.getName().replace('.', '/') + "$$Lambda$" + counter.incrementAndGet();
        this.cw = new ClassWriter(1);
        int parameterCount = invokedType.parameterCount();
        if (parameterCount > 0) {
            this.argNames = new String[parameterCount];
            this.argDescs = new String[parameterCount];
            for (int i = 0; i < parameterCount; ++i) {
                this.argNames[i] = "arg$" + (i + 1);
                this.argDescs[i] = BytecodeDescriptor.unparse(invokedType.parameterType(i));
            }
        } else {
            this.argDescs = EMPTY_STRING_ARRAY;
            this.argNames = EMPTY_STRING_ARRAY;
        }
    }

    @Override
    CallSite buildCallSite() throws LambdaConversionException {
        final Class<?> innerClass = this.spinInnerClass();
        if (this.invokedType.parameterCount() == 0) {
            Constructor<?>[] ctrs = AccessController.doPrivileged(new PrivilegedAction<Constructor<?>[]>(){

                @Override
                public Constructor<?>[] run() {
                    Constructor<?>[] ctrs = innerClass.getDeclaredConstructors();
                    if (ctrs.length == 1) {
                        ctrs[0].setAccessible(true);
                    }
                    return ctrs;
                }
            });
            if (ctrs.length != 1) {
                throw new LambdaConversionException("Expected one lambda constructor for " + innerClass.getCanonicalName() + ", got " + ctrs.length);
            }
            try {
                Object inst = ctrs[0].newInstance(new Object[0]);
                return new ConstantCallSite(MethodHandles.constant(this.samBase, inst));
            }
            catch (ReflectiveOperationException e) {
                throw new LambdaConversionException("Exception instantiating lambda object", e);
            }
        }
        try {
            UNSAFE.ensureClassInitialized(innerClass);
            return new ConstantCallSite(MethodHandles.Lookup.IMPL_LOOKUP.findStatic(innerClass, NAME_FACTORY, this.invokedType));
        }
        catch (ReflectiveOperationException e) {
            throw new LambdaConversionException("Exception finding constructor", e);
        }
    }

    private Class<?> spinInnerClass() throws LambdaConversionException {
        String[] interfaces;
        boolean accidentallySerializable;
        String samIntf = this.samBase.getName().replace('.', '/');
        boolean bl = accidentallySerializable = !this.isSerializable && Serializable.class.isAssignableFrom(this.samBase);
        if (this.markerInterfaces.length == 0) {
            interfaces = new String[]{samIntf};
        } else {
            LinkedHashSet<String> itfs = new LinkedHashSet<String>(this.markerInterfaces.length + 1);
            itfs.add(samIntf);
            for (Class markerInterface : this.markerInterfaces) {
                itfs.add(markerInterface.getName().replace('.', '/'));
                accidentallySerializable |= !this.isSerializable && Serializable.class.isAssignableFrom(markerInterface);
            }
            interfaces = itfs.toArray(new String[itfs.size()]);
        }
        this.cw.visit(52, 4144, this.lambdaClassName, null, JAVA_LANG_OBJECT, interfaces);
        for (int i = 0; i < this.argDescs.length; ++i) {
            MethodType[] fv = this.cw.visitField(18, this.argNames[i], this.argDescs[i], null, null);
            fv.visitEnd();
        }
        this.generateConstructor();
        if (this.invokedType.parameterCount() != 0) {
            this.generateFactory();
        }
        MethodVisitor mv = this.cw.visitMethod(1, this.samMethodName, this.samMethodType.toMethodDescriptorString(), null, null);
        mv.visitAnnotation("Ljava/lang/invoke/LambdaForm$Hidden;", true);
        new ForwardingMethodGenerator(mv).generate(this.samMethodType);
        if (this.additionalBridges != null) {
            for (MethodType mt : this.additionalBridges) {
                mv = this.cw.visitMethod(65, this.samMethodName, mt.toMethodDescriptorString(), null, null);
                mv.visitAnnotation("Ljava/lang/invoke/LambdaForm$Hidden;", true);
                new ForwardingMethodGenerator(mv).generate(mt);
            }
        }
        if (this.isSerializable) {
            this.generateSerializationFriendlyMethods();
        } else if (accidentallySerializable) {
            this.generateSerializationHostileMethods();
        }
        this.cw.visitEnd();
        final byte[] classBytes = this.cw.toByteArray();
        if (dumper != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    dumper.dumpClass(InnerClassLambdaMetafactory.this.lambdaClassName, classBytes);
                    return null;
                }
            }, null, new FilePermission("<<ALL FILES>>", "read, write"), new PropertyPermission("user.dir", "read"));
        }
        return UNSAFE.defineAnonymousClass(this.targetClass, classBytes, null);
    }

    private void generateFactory() {
        MethodVisitor m = this.cw.visitMethod(10, NAME_FACTORY, this.invokedType.toMethodDescriptorString(), null, null);
        m.visitCode();
        m.visitTypeInsn(187, this.lambdaClassName);
        m.visitInsn(89);
        int parameterCount = this.invokedType.parameterCount();
        int varIndex = 0;
        for (int typeIndex = 0; typeIndex < parameterCount; ++typeIndex) {
            Class<?> argType = this.invokedType.parameterType(typeIndex);
            m.visitVarInsn(InnerClassLambdaMetafactory.getLoadOpcode(argType), varIndex);
            varIndex += InnerClassLambdaMetafactory.getParameterSize(argType);
        }
        m.visitMethodInsn(183, this.lambdaClassName, NAME_CTOR, this.constructorType.toMethodDescriptorString(), false);
        m.visitInsn(176);
        m.visitMaxs(-1, -1);
        m.visitEnd();
    }

    private void generateConstructor() {
        MethodVisitor ctor = this.cw.visitMethod(2, NAME_CTOR, this.constructorType.toMethodDescriptorString(), null, null);
        ctor.visitCode();
        ctor.visitVarInsn(25, 0);
        ctor.visitMethodInsn(183, JAVA_LANG_OBJECT, NAME_CTOR, METHOD_DESCRIPTOR_VOID, false);
        int parameterCount = this.invokedType.parameterCount();
        int lvIndex = 0;
        for (int i = 0; i < parameterCount; ++i) {
            ctor.visitVarInsn(25, 0);
            Class<?> argType = this.invokedType.parameterType(i);
            ctor.visitVarInsn(InnerClassLambdaMetafactory.getLoadOpcode(argType), lvIndex + 1);
            lvIndex += InnerClassLambdaMetafactory.getParameterSize(argType);
            ctor.visitFieldInsn(181, this.lambdaClassName, this.argNames[i], this.argDescs[i]);
        }
        ctor.visitInsn(177);
        ctor.visitMaxs(-1, -1);
        ctor.visitEnd();
    }

    private void generateSerializationFriendlyMethods() {
        TypeConvertingMethodAdapter mv = new TypeConvertingMethodAdapter(this.cw.visitMethod(18, NAME_METHOD_WRITE_REPLACE, DESCR_METHOD_WRITE_REPLACE, null, null));
        mv.visitCode();
        mv.visitTypeInsn(187, NAME_SERIALIZED_LAMBDA);
        mv.visitInsn(89);
        mv.visitLdcInsn(Type.getType(this.targetClass));
        mv.visitLdcInsn(this.invokedType.returnType().getName().replace('.', '/'));
        mv.visitLdcInsn(this.samMethodName);
        mv.visitLdcInsn(this.samMethodType.toMethodDescriptorString());
        mv.visitLdcInsn(this.implInfo.getReferenceKind());
        mv.visitLdcInsn(this.implInfo.getDeclaringClass().getName().replace('.', '/'));
        mv.visitLdcInsn(this.implInfo.getName());
        mv.visitLdcInsn(this.implInfo.getMethodType().toMethodDescriptorString());
        mv.visitLdcInsn(this.instantiatedMethodType.toMethodDescriptorString());
        mv.iconst(this.argDescs.length);
        mv.visitTypeInsn(189, JAVA_LANG_OBJECT);
        for (int i = 0; i < this.argDescs.length; ++i) {
            mv.visitInsn(89);
            mv.iconst(i);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.lambdaClassName, this.argNames[i], this.argDescs[i]);
            mv.boxIfTypePrimitive(Type.getType(this.argDescs[i]));
            mv.visitInsn(83);
        }
        mv.visitMethodInsn(183, NAME_SERIALIZED_LAMBDA, NAME_CTOR, DESCR_CTOR_SERIALIZED_LAMBDA, false);
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void generateSerializationHostileMethods() {
        MethodVisitor mv = this.cw.visitMethod(18, NAME_METHOD_WRITE_OBJECT, DESCR_METHOD_WRITE_OBJECT, null, SER_HOSTILE_EXCEPTIONS);
        mv.visitCode();
        mv.visitTypeInsn(187, NAME_NOT_SERIALIZABLE_EXCEPTION);
        mv.visitInsn(89);
        mv.visitLdcInsn("Non-serializable lambda");
        mv.visitMethodInsn(183, NAME_NOT_SERIALIZABLE_EXCEPTION, NAME_CTOR, DESCR_CTOR_NOT_SERIALIZABLE_EXCEPTION, false);
        mv.visitInsn(191);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        mv = this.cw.visitMethod(18, NAME_METHOD_READ_OBJECT, DESCR_METHOD_READ_OBJECT, null, SER_HOSTILE_EXCEPTIONS);
        mv.visitCode();
        mv.visitTypeInsn(187, NAME_NOT_SERIALIZABLE_EXCEPTION);
        mv.visitInsn(89);
        mv.visitLdcInsn("Non-serializable lambda");
        mv.visitMethodInsn(183, NAME_NOT_SERIALIZABLE_EXCEPTION, NAME_CTOR, DESCR_CTOR_NOT_SERIALIZABLE_EXCEPTION, false);
        mv.visitInsn(191);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    static int getParameterSize(Class<?> c) {
        if (c == Void.TYPE) {
            return 0;
        }
        if (c == Long.TYPE || c == Double.TYPE) {
            return 2;
        }
        return 1;
    }

    static int getLoadOpcode(Class<?> c) {
        if (c == Void.TYPE) {
            throw new InternalError("Unexpected void type of load opcode");
        }
        return 21 + InnerClassLambdaMetafactory.getOpcodeOffset(c);
    }

    static int getReturnOpcode(Class<?> c) {
        if (c == Void.TYPE) {
            return 177;
        }
        return 172 + InnerClassLambdaMetafactory.getOpcodeOffset(c);
    }

    private static int getOpcodeOffset(Class<?> c) {
        if (c.isPrimitive()) {
            if (c == Long.TYPE) {
                return 1;
            }
            if (c == Float.TYPE) {
                return 2;
            }
            if (c == Double.TYPE) {
                return 3;
            }
            return 0;
        }
        return 4;
    }

    static {
        String key = "jdk.internal.lambda.dumpProxyClasses";
        String path = AccessController.doPrivileged(new GetPropertyAction("jdk.internal.lambda.dumpProxyClasses"), null, new PropertyPermission("jdk.internal.lambda.dumpProxyClasses", "read"));
        dumper = null == path ? null : ProxyClassesDumper.getInstance(path);
    }

    private class ForwardingMethodGenerator
    extends TypeConvertingMethodAdapter {
        ForwardingMethodGenerator(MethodVisitor mv) {
            super(mv);
        }

        void generate(MethodType methodType) {
            this.visitCode();
            if (InnerClassLambdaMetafactory.this.implKind == 8) {
                this.visitTypeInsn(187, InnerClassLambdaMetafactory.this.implMethodClassName);
                this.visitInsn(89);
            }
            for (int i = 0; i < InnerClassLambdaMetafactory.this.argNames.length; ++i) {
                this.visitVarInsn(25, 0);
                this.visitFieldInsn(180, InnerClassLambdaMetafactory.this.lambdaClassName, InnerClassLambdaMetafactory.this.argNames[i], InnerClassLambdaMetafactory.this.argDescs[i]);
            }
            this.convertArgumentTypes(methodType);
            this.visitMethodInsn(this.invocationOpcode(), InnerClassLambdaMetafactory.this.implMethodClassName, InnerClassLambdaMetafactory.this.implMethodName, InnerClassLambdaMetafactory.this.implMethodDesc, InnerClassLambdaMetafactory.this.implDefiningClass.isInterface());
            Class<?> samReturnClass = methodType.returnType();
            this.convertType(InnerClassLambdaMetafactory.this.implMethodReturnClass, samReturnClass, samReturnClass);
            this.visitInsn(InnerClassLambdaMetafactory.getReturnOpcode(samReturnClass));
            this.visitMaxs(-1, -1);
            this.visitEnd();
        }

        private void convertArgumentTypes(MethodType samType) {
            int samReceiverLength;
            int lvIndex = 0;
            boolean samIncludesReceiver = InnerClassLambdaMetafactory.this.implIsInstanceMethod && InnerClassLambdaMetafactory.this.invokedType.parameterCount() == 0;
            int n = samReceiverLength = samIncludesReceiver ? 1 : 0;
            if (samIncludesReceiver) {
                Class<?> rcvrType = samType.parameterType(0);
                this.visitVarInsn(InnerClassLambdaMetafactory.getLoadOpcode(rcvrType), lvIndex + 1);
                lvIndex += InnerClassLambdaMetafactory.getParameterSize(rcvrType);
                this.convertType(rcvrType, InnerClassLambdaMetafactory.this.implDefiningClass, InnerClassLambdaMetafactory.this.instantiatedMethodType.parameterType(0));
            }
            int samParametersLength = samType.parameterCount();
            int argOffset = InnerClassLambdaMetafactory.this.implMethodType.parameterCount() - samParametersLength;
            for (int i = samReceiverLength; i < samParametersLength; ++i) {
                Class<?> argType = samType.parameterType(i);
                this.visitVarInsn(InnerClassLambdaMetafactory.getLoadOpcode(argType), lvIndex + 1);
                lvIndex += InnerClassLambdaMetafactory.getParameterSize(argType);
                this.convertType(argType, InnerClassLambdaMetafactory.this.implMethodType.parameterType(argOffset + i), InnerClassLambdaMetafactory.this.instantiatedMethodType.parameterType(i));
            }
        }

        private int invocationOpcode() throws InternalError {
            switch (InnerClassLambdaMetafactory.this.implKind) {
                case 6: {
                    return 184;
                }
                case 8: {
                    return 183;
                }
                case 5: {
                    return 182;
                }
                case 9: {
                    return 185;
                }
                case 7: {
                    return 183;
                }
            }
            throw new InternalError("Unexpected invocation kind: " + InnerClassLambdaMetafactory.this.implKind);
        }
    }
}

