/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleInfo;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import sun.invoke.util.Wrapper;

abstract class AbstractValidatingLambdaMetafactory {
    final Class<?> targetClass;
    final MethodType invokedType;
    final Class<?> samBase;
    final String samMethodName;
    final MethodType samMethodType;
    final MethodHandle implMethod;
    final MethodHandleInfo implInfo;
    final int implKind;
    final boolean implIsInstanceMethod;
    final Class<?> implDefiningClass;
    final MethodType implMethodType;
    final MethodType instantiatedMethodType;
    final boolean isSerializable;
    final Class<?>[] markerInterfaces;
    final MethodType[] additionalBridges;

    AbstractValidatingLambdaMetafactory(MethodHandles.Lookup caller, MethodType invokedType, String samMethodName, MethodType samMethodType, MethodHandle implMethod, MethodType instantiatedMethodType, boolean isSerializable, Class<?>[] markerInterfaces, MethodType[] additionalBridges) throws LambdaConversionException {
        if ((caller.lookupModes() & 2) == 0) {
            throw new LambdaConversionException(String.format("Invalid caller: %s", caller.lookupClass().getName()));
        }
        this.targetClass = caller.lookupClass();
        this.invokedType = invokedType;
        this.samBase = invokedType.returnType();
        this.samMethodName = samMethodName;
        this.samMethodType = samMethodType;
        this.implMethod = implMethod;
        this.implInfo = caller.revealDirect(implMethod);
        this.implKind = this.implInfo.getReferenceKind();
        this.implIsInstanceMethod = this.implKind == 5 || this.implKind == 7 || this.implKind == 9;
        this.implDefiningClass = this.implInfo.getDeclaringClass();
        this.implMethodType = this.implInfo.getMethodType();
        this.instantiatedMethodType = instantiatedMethodType;
        this.isSerializable = isSerializable;
        this.markerInterfaces = markerInterfaces;
        this.additionalBridges = additionalBridges;
        if (!this.samBase.isInterface()) {
            throw new LambdaConversionException(String.format("Functional interface %s is not an interface", this.samBase.getName()));
        }
        for (Class<?> c : markerInterfaces) {
            if (c.isInterface()) continue;
            throw new LambdaConversionException(String.format("Marker interface %s is not an interface", c.getName()));
        }
    }

    abstract CallSite buildCallSite() throws LambdaConversionException;

    void validateMetafactoryArgs() throws LambdaConversionException {
        int samStart;
        int capturedStart;
        switch (this.implKind) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            default: {
                throw new LambdaConversionException(String.format("Unsupported MethodHandle kind: %s", this.implInfo));
            }
        }
        int implArity = this.implMethodType.parameterCount();
        int receiverArity = this.implIsInstanceMethod ? 1 : 0;
        int capturedArity = this.invokedType.parameterCount();
        int samArity = this.samMethodType.parameterCount();
        int instantiatedArity = this.instantiatedMethodType.parameterCount();
        if (implArity + receiverArity != capturedArity + samArity) {
            throw new LambdaConversionException(String.format("Incorrect number of parameters for %s method %s; %d captured parameters, %d functional interface method parameters, %d implementation parameters", this.implIsInstanceMethod ? "instance" : "static", this.implInfo, capturedArity, samArity, implArity));
        }
        if (instantiatedArity != samArity) {
            throw new LambdaConversionException(String.format("Incorrect number of parameters for %s method %s; %d instantiated parameters, %d functional interface method parameters", this.implIsInstanceMethod ? "instance" : "static", this.implInfo, instantiatedArity, samArity));
        }
        for (MethodType bridgeMT : this.additionalBridges) {
            if (bridgeMT.parameterCount() == samArity) continue;
            throw new LambdaConversionException(String.format("Incorrect number of parameters for bridge signature %s; incompatible with %s", bridgeMT, this.samMethodType));
        }
        if (this.implIsInstanceMethod) {
            Class<?> receiverClass;
            if (capturedArity == 0) {
                capturedStart = 0;
                samStart = 1;
                receiverClass = this.instantiatedMethodType.parameterType(0);
            } else {
                capturedStart = 1;
                samStart = 0;
                receiverClass = this.invokedType.parameterType(0);
            }
            if (!this.implDefiningClass.isAssignableFrom(receiverClass)) {
                throw new LambdaConversionException(String.format("Invalid receiver type %s; not a subtype of implementation type %s", receiverClass, this.implDefiningClass));
            }
            Class<?> implReceiverClass = this.implMethod.type().parameterType(0);
            if (implReceiverClass != this.implDefiningClass && !implReceiverClass.isAssignableFrom(receiverClass)) {
                throw new LambdaConversionException(String.format("Invalid receiver type %s; not a subtype of implementation receiver type %s", receiverClass, implReceiverClass));
            }
        } else {
            capturedStart = 0;
            samStart = 0;
        }
        int implFromCaptured = capturedArity - capturedStart;
        for (int i = 0; i < implFromCaptured; ++i) {
            Class<?> implParamType = this.implMethodType.parameterType(i);
            Class<?> capturedParamType = this.invokedType.parameterType(i + capturedStart);
            if (capturedParamType.equals(implParamType)) continue;
            throw new LambdaConversionException(String.format("Type mismatch in captured lambda parameter %d: expecting %s, found %s", i, capturedParamType, implParamType));
        }
        int samOffset = samStart - implFromCaptured;
        for (int i = implFromCaptured; i < implArity; ++i) {
            Class<?> implParamType = this.implMethodType.parameterType(i);
            Class<?> instantiatedParamType = this.instantiatedMethodType.parameterType(i + samOffset);
            if (this.isAdaptableTo(instantiatedParamType, implParamType, true)) continue;
            throw new LambdaConversionException(String.format("Type mismatch for lambda argument %d: %s is not convertible to %s", i, instantiatedParamType, implParamType));
        }
        Class<?> expectedType = this.instantiatedMethodType.returnType();
        Class<?> actualReturnType = this.implKind == 8 ? this.implDefiningClass : this.implMethodType.returnType();
        Class<?> samReturnType = this.samMethodType.returnType();
        if (!this.isAdaptableToAsReturn(actualReturnType, expectedType)) {
            throw new LambdaConversionException(String.format("Type mismatch for lambda return: %s is not convertible to %s", actualReturnType, expectedType));
        }
        if (!this.isAdaptableToAsReturnStrict(expectedType, samReturnType)) {
            throw new LambdaConversionException(String.format("Type mismatch for lambda expected return: %s is not convertible to %s", expectedType, samReturnType));
        }
        for (MethodType bridgeMT : this.additionalBridges) {
            if (this.isAdaptableToAsReturnStrict(expectedType, bridgeMT.returnType())) continue;
            throw new LambdaConversionException(String.format("Type mismatch for lambda expected return: %s is not convertible to %s", expectedType, bridgeMT.returnType()));
        }
    }

    private boolean isAdaptableTo(Class<?> fromType, Class<?> toType, boolean strict) {
        if (fromType.equals(toType)) {
            return true;
        }
        if (fromType.isPrimitive()) {
            Wrapper wfrom = Wrapper.forPrimitiveType(fromType);
            if (toType.isPrimitive()) {
                Wrapper wto = Wrapper.forPrimitiveType(toType);
                return wto.isConvertibleFrom(wfrom);
            }
            return toType.isAssignableFrom(wfrom.wrapperType());
        }
        if (toType.isPrimitive()) {
            Wrapper wfrom;
            if (Wrapper.isWrapperType(fromType) && (wfrom = Wrapper.forWrapperType(fromType)).primitiveType().isPrimitive()) {
                Wrapper wto = Wrapper.forPrimitiveType(toType);
                return wto.isConvertibleFrom(wfrom);
            }
            return !strict;
        }
        return !strict || toType.isAssignableFrom(fromType);
    }

    private boolean isAdaptableToAsReturn(Class<?> fromType, Class<?> toType) {
        return toType.equals(Void.TYPE) || !fromType.equals(Void.TYPE) && this.isAdaptableTo(fromType, toType, false);
    }

    private boolean isAdaptableToAsReturnStrict(Class<?> fromType, Class<?> toType) {
        if (fromType.equals(Void.TYPE)) {
            return toType.equals(Void.TYPE);
        }
        return this.isAdaptableTo(fromType, toType, true);
    }
}

