/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.d3d;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ConvolveOp;
import java.awt.image.LookupOp;
import java.awt.image.RescaleOp;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.d3d.D3DBlitLoops;
import sun.java2d.d3d.D3DGraphicsDevice;
import sun.java2d.d3d.D3DSurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.pipe.BufferedBufImgOps;

class D3DBufImgOps
extends BufferedBufImgOps {
    D3DBufImgOps() {
    }

    static boolean renderImageWithOp(SunGraphics2D sg, BufferedImage img, BufferedImageOp biop, int x, int y) {
        SurfaceData dstData;
        if (biop instanceof ConvolveOp) {
            if (!D3DBufImgOps.isConvolveOpValid((ConvolveOp)biop)) {
                return false;
            }
        } else if (biop instanceof RescaleOp) {
            if (!D3DBufImgOps.isRescaleOpValid((RescaleOp)biop, img)) {
                return false;
            }
        } else if (biop instanceof LookupOp) {
            if (!D3DBufImgOps.isLookupOpValid((LookupOp)biop, img)) {
                return false;
            }
        } else {
            return false;
        }
        if (!((dstData = sg.surfaceData) instanceof D3DSurfaceData) || sg.interpolationType == 3 || sg.compositeState > 1) {
            return false;
        }
        SurfaceData srcData = dstData.getSourceSurfaceData(img, 0, CompositeType.SrcOver, null);
        if (!(srcData instanceof D3DSurfaceData)) {
            srcData = dstData.getSourceSurfaceData(img, 0, CompositeType.SrcOver, null);
            if (!(srcData instanceof D3DSurfaceData)) {
                return false;
            }
        }
        D3DSurfaceData d3dSrc = (D3DSurfaceData)srcData;
        D3DGraphicsDevice gd = (D3DGraphicsDevice)d3dSrc.getDeviceConfiguration().getDevice();
        if (d3dSrc.getType() != 3 || !gd.isCapPresent(65536)) {
            return false;
        }
        int sw = img.getWidth();
        int sh = img.getHeight();
        D3DBlitLoops.IsoBlit(srcData, dstData, img, biop, sg.composite, sg.getCompClip(), sg.transform, sg.interpolationType, 0, 0, sw, sh, x, y, x + sw, y + sh, true);
        return true;
    }
}

