/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.Locale;
import javax.net.SocketFactory;
import javax.net.ssl.DefaultSSLSocketFactory;
import javax.net.ssl.SSLContext;
import sun.security.action.GetPropertyAction;

public abstract class SSLSocketFactory
extends SocketFactory {
    private static SSLSocketFactory theFactory;
    private static boolean propertyChecked;
    static final boolean DEBUG;

    private static void log(String msg) {
        if (DEBUG) {
            System.out.println(msg);
        }
    }

    public static synchronized SocketFactory getDefault() {
        if (theFactory != null) {
            return theFactory;
        }
        if (!propertyChecked) {
            propertyChecked = true;
            String clsName = SSLSocketFactory.getSecurityProperty("ssl.SocketFactory.provider");
            if (clsName != null) {
                SSLSocketFactory.log("setting up default SSLSocketFactory");
                try {
                    Class<?> cls;
                    block9: {
                        cls = null;
                        try {
                            cls = Class.forName(clsName);
                        }
                        catch (ClassNotFoundException e) {
                            ClassLoader cl = ClassLoader.getSystemClassLoader();
                            if (cl == null) break block9;
                            cls = cl.loadClass(clsName);
                        }
                    }
                    SSLSocketFactory.log("class " + clsName + " is loaded");
                    SSLSocketFactory fac = (SSLSocketFactory)cls.newInstance();
                    SSLSocketFactory.log("instantiated an instance of class " + clsName);
                    theFactory = fac;
                    return fac;
                }
                catch (Exception e) {
                    SSLSocketFactory.log("SSLSocketFactory instantiation failed: " + e.toString());
                    theFactory = new DefaultSSLSocketFactory(e);
                    return theFactory;
                }
            }
        }
        try {
            return SSLContext.getDefault().getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            return new DefaultSSLSocketFactory(e);
        }
    }

    static String getSecurityProperty(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String s = Security.getProperty(name);
                if (s != null && (s = s.trim()).length() == 0) {
                    s = null;
                }
                return s;
            }
        });
    }

    public abstract String[] getDefaultCipherSuites();

    public abstract String[] getSupportedCipherSuites();

    public abstract Socket createSocket(Socket var1, String var2, int var3, boolean var4) throws IOException;

    public Socket createSocket(Socket s, InputStream consumed, boolean autoClose) throws IOException {
        throw new UnsupportedOperationException();
    }

    static {
        String s = AccessController.doPrivileged(new GetPropertyAction("javax.net.debug", "")).toLowerCase(Locale.ENGLISH);
        DEBUG = s.contains("all") || s.contains("ssl");
    }
}

