/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;
import java.util.Arrays;
import java.util.List;

public abstract class MethodHandle {
    private final MethodType type;
    final LambdaForm form;
    MethodHandle asTypeCache;
    byte customizationCount;
    private static final long FORM_OFFSET;

    public MethodType type() {
        return this.type;
    }

    MethodHandle(MethodType type, LambdaForm form) {
        type.getClass();
        form.getClass();
        this.type = type;
        this.form = form.uncustomize();
        this.form.prepare();
    }

    @PolymorphicSignature
    public final native Object invokeExact(Object ... var1) throws Throwable;

    @PolymorphicSignature
    public final native Object invoke(Object ... var1) throws Throwable;

    @PolymorphicSignature
    final native Object invokeBasic(Object ... var1) throws Throwable;

    @PolymorphicSignature
    static native Object linkToVirtual(Object ... var0) throws Throwable;

    @PolymorphicSignature
    static native Object linkToStatic(Object ... var0) throws Throwable;

    @PolymorphicSignature
    static native Object linkToSpecial(Object ... var0) throws Throwable;

    @PolymorphicSignature
    static native Object linkToInterface(Object ... var0) throws Throwable;

    public Object invokeWithArguments(Object ... arguments) throws Throwable {
        MethodType invocationType = MethodType.genericMethodType(arguments == null ? 0 : arguments.length);
        return invocationType.invokers().spreadInvoker(0).invokeExact(this.asType(invocationType), arguments);
    }

    public Object invokeWithArguments(List<?> arguments) throws Throwable {
        return this.invokeWithArguments(arguments.toArray());
    }

    public MethodHandle asType(MethodType newType) {
        if (newType == this.type) {
            return this;
        }
        MethodHandle atc = this.asTypeCached(newType);
        if (atc != null) {
            return atc;
        }
        return this.asTypeUncached(newType);
    }

    private MethodHandle asTypeCached(MethodType newType) {
        MethodHandle atc = this.asTypeCache;
        if (atc != null && newType == atc.type) {
            return atc;
        }
        return null;
    }

    MethodHandle asTypeUncached(MethodType newType) {
        if (!this.type.isConvertibleTo(newType)) {
            throw new WrongMethodTypeException("cannot convert " + this + " to " + newType);
        }
        this.asTypeCache = MethodHandleImpl.makePairwiseConvert(this, newType, true);
        return this.asTypeCache;
    }

    public MethodHandle asSpreader(Class<?> arrayType, int arrayLength) {
        MethodType postSpreadType = this.asSpreaderChecks(arrayType, arrayLength);
        int arity = this.type().parameterCount();
        int spreadArgPos = arity - arrayLength;
        MethodHandle afterSpread = this.asType(postSpreadType);
        BoundMethodHandle mh = afterSpread.rebind();
        LambdaForm lform = mh.editor().spreadArgumentsForm(1 + spreadArgPos, arrayType, arrayLength);
        MethodType preSpreadType = postSpreadType.replaceParameterTypes(spreadArgPos, arity, arrayType);
        return mh.copyWith(preSpreadType, lform);
    }

    private MethodType asSpreaderChecks(Class<?> arrayType, int arrayLength) {
        this.spreadArrayChecks(arrayType, arrayLength);
        int nargs = this.type().parameterCount();
        if (nargs < arrayLength || arrayLength < 0) {
            throw MethodHandleStatics.newIllegalArgumentException("bad spread array length");
        }
        Class<?> arrayElement = arrayType.getComponentType();
        MethodType mtype = this.type();
        boolean match = true;
        boolean fail = false;
        for (int i = nargs - arrayLength; i < nargs; ++i) {
            Class<?> ptype = mtype.parameterType(i);
            if (ptype == arrayElement) continue;
            match = false;
            if (MethodType.canConvert(arrayElement, ptype)) continue;
            fail = true;
            break;
        }
        if (match) {
            return mtype;
        }
        MethodType needType = mtype.asSpreaderType(arrayType, arrayLength);
        if (!fail) {
            return needType;
        }
        this.asType(needType);
        throw MethodHandleStatics.newInternalError("should not return", null);
    }

    private void spreadArrayChecks(Class<?> arrayType, int arrayLength) {
        Class<?> arrayElement = arrayType.getComponentType();
        if (arrayElement == null) {
            throw MethodHandleStatics.newIllegalArgumentException("not an array type", arrayType);
        }
        if ((arrayLength & 0x7F) != arrayLength) {
            if ((arrayLength & 0xFF) != arrayLength) {
                throw MethodHandleStatics.newIllegalArgumentException("array length is not legal", arrayLength);
            }
            assert (arrayLength >= 128);
            if (arrayElement == Long.TYPE || arrayElement == Double.TYPE) {
                throw MethodHandleStatics.newIllegalArgumentException("array length is not legal for long[] or double[]", arrayLength);
            }
        }
    }

    public MethodHandle asCollector(Class<?> arrayType, int arrayLength) {
        this.asCollectorChecks(arrayType, arrayLength);
        int collectArgPos = this.type().parameterCount() - 1;
        BoundMethodHandle mh = this.rebind();
        MethodType resultType = this.type().asCollectorType(arrayType, arrayLength);
        MethodHandle newArray = MethodHandleImpl.varargsArray(arrayType, arrayLength);
        LambdaForm lform = mh.editor().collectArgumentArrayForm(1 + collectArgPos, newArray);
        if (lform != null) {
            return mh.copyWith(resultType, lform);
        }
        lform = mh.editor().collectArgumentsForm(1 + collectArgPos, newArray.type().basicType());
        return mh.copyWithExtendL(resultType, lform, newArray);
    }

    boolean asCollectorChecks(Class<?> arrayType, int arrayLength) {
        this.spreadArrayChecks(arrayType, arrayLength);
        int nargs = this.type().parameterCount();
        if (nargs != 0) {
            Class<?> lastParam = this.type().parameterType(nargs - 1);
            if (lastParam == arrayType) {
                return true;
            }
            if (lastParam.isAssignableFrom(arrayType)) {
                return false;
            }
        }
        throw MethodHandleStatics.newIllegalArgumentException("array type not assignable to trailing argument", this, arrayType);
    }

    public MethodHandle asVarargsCollector(Class<?> arrayType) {
        arrayType.getClass();
        boolean lastMatch = this.asCollectorChecks(arrayType, 0);
        if (this.isVarargsCollector() && lastMatch) {
            return this;
        }
        return MethodHandleImpl.makeVarargsCollector(this, arrayType);
    }

    public boolean isVarargsCollector() {
        return false;
    }

    public MethodHandle asFixedArity() {
        assert (!this.isVarargsCollector());
        return this;
    }

    public MethodHandle bindTo(Object x) {
        x = this.type.leadingReferenceParameter().cast(x);
        return this.bindArgumentL(0, x);
    }

    public String toString() {
        if (MethodHandleStatics.DEBUG_METHOD_HANDLE_NAMES) {
            return "MethodHandle" + this.debugString();
        }
        return this.standardString();
    }

    String standardString() {
        return "MethodHandle" + this.type;
    }

    String debugString() {
        return this.type + " : " + this.internalForm() + this.internalProperties();
    }

    BoundMethodHandle bindArgumentL(int pos, Object value) {
        return this.rebind().bindArgumentL(pos, value);
    }

    MethodHandle setVarargs(MemberName member) throws IllegalAccessException {
        if (!member.isVarargs()) {
            return this;
        }
        Class<?> arrayType = this.type().lastParameterType();
        if (arrayType.isArray()) {
            return MethodHandleImpl.makeVarargsCollector(this, arrayType);
        }
        throw member.makeAccessException("cannot make variable arity", null);
    }

    MethodHandle viewAsType(MethodType newType, boolean strict) {
        assert (this.viewAsTypeChecks(newType, strict));
        BoundMethodHandle mh = this.rebind();
        assert (!(mh instanceof DirectMethodHandle));
        return mh.copyWith(newType, mh.form);
    }

    boolean viewAsTypeChecks(MethodType newType, boolean strict) {
        if (strict ? !$assertionsDisabled && !this.type().isViewableAs(newType, true) : !$assertionsDisabled && !this.type().basicType().isViewableAs(newType.basicType(), true)) {
            throw new AssertionError(Arrays.asList(this, newType));
        }
        return true;
    }

    LambdaForm internalForm() {
        return this.form;
    }

    MemberName internalMemberName() {
        return null;
    }

    Class<?> internalCallerClass() {
        return null;
    }

    MethodHandleImpl.Intrinsic intrinsicName() {
        return MethodHandleImpl.Intrinsic.NONE;
    }

    MethodHandle withInternalMemberName(MemberName member, boolean isInvokeSpecial) {
        if (member != null) {
            return MethodHandleImpl.makeWrappedMember(this, member, isInvokeSpecial);
        }
        if (this.internalMemberName() == null) {
            return this;
        }
        BoundMethodHandle result = this.rebind();
        assert (result.internalMemberName() == null);
        return result;
    }

    boolean isInvokeSpecial() {
        return false;
    }

    Object internalValues() {
        return null;
    }

    Object internalProperties() {
        return "";
    }

    abstract MethodHandle copyWith(MethodType var1, LambdaForm var2);

    abstract BoundMethodHandle rebind();

    void updateForm(LambdaForm newForm) {
        assert (newForm.customized == null || newForm.customized == this);
        if (this.form == newForm) {
            return;
        }
        newForm.prepare();
        MethodHandleStatics.UNSAFE.putObject((Object)this, FORM_OFFSET, (Object)newForm);
        MethodHandleStatics.UNSAFE.fullFence();
    }

    void customize() {
        if (this.form.customized == null) {
            LambdaForm newForm = this.form.customize(this);
            this.updateForm(newForm);
        } else assert (this.form.customized == this);
    }

    static {
        MethodHandleImpl.initStatics();
        try {
            FORM_OFFSET = MethodHandleStatics.UNSAFE.objectFieldOffset(MethodHandle.class.getDeclaredField("form"));
        }
        catch (ReflectiveOperationException ex) {
            throw MethodHandleStatics.newInternalError(ex);
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface PolymorphicSignature {
    }
}

