/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.websocket;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.SpringUtil;
import com.zkteco.zkbiosecurity.sis.service.SisDeviceService;
import com.zkteco.zkbiosecurity.sis.util.SicmCmdPackageUtil;
import com.zkteco.zkbiosecurity.sis.util.SicmDataAnalyUtil;
import com.zkteco.zkbiosecurity.sis.util.SicmDataUtil;
import com.zkteco.zkbiosecurity.sis.util.SicmDeviceDataUtil;
import com.zkteco.zkbiosecurity.sis.vo.SisDeviceItem;
import com.zkteco.zkbiosecurity.sis.websocket.SicmWebsocketInfo;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/websocketServer")
public class SicmWebSocketClientListen
extends SicmWebsocketInfo {
    private static final Logger logger = Logger.getLogger(SicmWebSocketClientListen.class);
    private Session session;
    private SisDeviceService sisDeviceService = (SisDeviceService)SpringUtil.getBean(SisDeviceService.class);
    public SicmDataAnalyUtil sicmDataAnalyUtil;

    @OnOpen
    public void onOpen(Session session) {
        this.session = session;
        SicmWebSocketClientListen.addOnlineCount();
        this.sicmDataAnalyUtil = new SicmDataAnalyUtil();
    }

    @Override
    @OnClose
    public void onClose(Session session, CloseReason reason) throws Exception {
        logger.info((Object)("----websocketServerTest----onClose----" + this.SN));
        if (StringUtils.isNotBlank((CharSequence)this.SN)) {
            totalWebsocketInfoMap.remove(this.SN);
        }
        SicmWebSocketClientListen.subOnlineCount();
        new SicmDeviceDataUtil().updateDevState(this.SN, (short)0, "DISCONNECT", "0");
    }

    @OnMessage
    public void onMessage(String message, Session session) {
    }

    @OnMessage
    public void onMessage(ByteBuffer message, Session session) {
        String retId = "";
        try {
            byte[] length = new byte[4];
            message.get(length, 0, 4);
            int headLen = SicmDataUtil.bytesToInt(length, 0);
            byte[] tempBytes = SicmDataUtil.bufferToByteArray(message);
            String jsonContent = new String(tempBytes, 4, headLen, "UTF-8");
            int imageLenth = tempBytes.length - (4 + headLen);
            if (StringUtils.isNotBlank((CharSequence)jsonContent)) {
                String id;
                JSONObject textJsonContent = JSONObject.parseObject((String)jsonContent);
                String func = textJsonContent.containsKey((Object)"func") ? textJsonContent.getString("func") : "";
                retId = id = textJsonContent.containsKey((Object)"id") ? textJsonContent.getString("id") : "";
                if (StringUtils.isNotBlank((CharSequence)func) && "device.login".equals(func)) {
                    String data;
                    String string = data = textJsonContent.containsKey((Object)"data") ? textJsonContent.getString("data") : "";
                    if (StringUtils.isNotBlank((CharSequence)data)) {
                        String sn;
                        JSONObject dataJson = JSONObject.parseObject((String)data);
                        String string2 = sn = dataJson.containsKey((Object)"sn") ? dataJson.getString("sn") : "";
                        if (StringUtils.isNotBlank((CharSequence)sn)) {
                            SisDeviceItem sisDeviceItem = this.sisDeviceService.findByDevSn(sn);
                            this.SN = sn;
                            this.addWebsocketDevToMap();
                            if (sisDeviceItem == null) {
                                boolean registerFlag = this.deviceLogin(sn, dataJson);
                                if (registerFlag) {
                                    this.updateDevConnState(1, true);
                                    this.sendMsg(SicmCmdPackageUtil.retCmdForRegister(id, 0));
                                } else {
                                    this.sendMsg(SicmCmdPackageUtil.retCmdForRegister(id, -1));
                                }
                            } else {
                                logger.debug((Object)"---------------------device register666----unauthorized");
                                new SicmDeviceDataUtil().updateDevState(this.SN, (short)1, "DEVICE UNAUTHORIZED", "-127");
                                this.sendMsg(SicmCmdPackageUtil.retCmdForRegister(id, -1));
                            }
                        } else {
                            logger.info((Object)"-----------sn is null------------");
                            this.sendMsg(SicmCmdPackageUtil.retCmdForRegister(id, -1));
                        }
                    } else {
                        logger.info((Object)"-----------data fields is null------------");
                        this.sendMsg(SicmCmdPackageUtil.retCmdForRegister(id, -1));
                    }
                } else {
                    this.sicmDataAnalyUtil.dataDistribution(jsonContent, headLen, tempBytes, this.SN);
                }
            }
        }
        catch (Exception e) {
            try {
                this.sendMsg(SicmCmdPackageUtil.retCmdForRegister(retId, -1));
            }
            catch (Exception e2) {
                logger.error((Object)"DATA ANALYSIS ERROR2", (Throwable)e2);
            }
            logger.error((Object)"DATA ANALYSIS ERROR1", (Throwable)e);
        }
    }

    public void sendAllMsg(String sendInfo) {
        SicmWebSocketClientListen websocketClient = null;
        for (String sn : totalWebsocketInfoMap.keySet()) {
            websocketClient = (SicmWebSocketClientListen)totalWebsocketInfoMap.get(sn);
            if (websocketClient == null) continue;
            websocketClient.sendMsg(sendInfo);
        }
    }

    @Override
    public void sendMsg(String sendInfo) {
        try {
            this.session.getBasicRemote().sendText(sendInfo);
        }
        catch (Exception e) {
            logger.info((Object)"error: send String message error!", (Throwable)e);
        }
    }

    @Override
    public void sendMsg(ByteBuffer sendInfo) {
        try {
            if (sendInfo.hasArray()) {
                this.session.getBasicRemote().sendBinary(sendInfo);
            } else {
                logger.info((Object)"-----------sendMsg failed----sendInfo is null--------");
            }
        }
        catch (Exception e) {
            logger.info((Object)"error: send ByteBuffer message error!", (Throwable)e);
        }
    }

    @OnError
    public void onError(Session session, Throwable error) {
        logger.info((Object)"error: onError method!");
        error.printStackTrace();
    }

    private boolean deviceLogin(String sn, JSONObject dataJson) {
        boolean registerFlag = false;
        try {
            String result = this.sisDeviceService.registryDevice(dataJson);
            if ("success".equals(result)) {
                registerFlag = true;
                this.stringRedisTemplate.opsForValue().set((Object)("SIS_DEVICE_STATUS_" + sn), (Object)dataJson.toString(), 70L, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            logger.info((Object)"error: register device error!", (Throwable)e);
        }
        return registerFlag;
    }

    public void addWebsocketDevToMap() {
        totalWebsocketInfoMap.put(this.SN, this);
    }

    public void sendMessage(String message) throws IOException {
        this.session.getBasicRemote().sendText(message);
    }

    public static synchronized int getOnlineCount() {
        return onlineWSCount;
    }

    public static synchronized void addOnlineCount() {
        ++onlineWSCount;
    }

    public static synchronized void subOnlineCount() {
        --onlineWSCount;
    }

    public boolean delDev() throws Exception {
        boolean ret;
        SisDeviceItem sisDeviceItem = this.sisDeviceService.findByDevSn(this.SN);
        if (sisDeviceItem != null && (ret = this.sisDeviceService.deleteByIds(sisDeviceItem.getId()))) {
            this.clearDevCommonCmd();
            this.clearDevOperateState();
            this.clearDevHeartbeat();
            totalWebsocketInfoMap.remove(this.SN);
            this.onClose(null, null);
        }
        return true;
    }
}

