/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.router;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.SpringUtil;
import com.zkteco.zkbiosecurity.sis.websocket.SicmGateDeviceInfo;
import org.apache.log4j.Logger;
import org.springframework.data.redis.core.StringRedisTemplate;

public class SicmGateDevDataRouter {
    private StringRedisTemplate stringRedisTemplate;
    private Logger logger = Logger.getLogger(this.getClass());

    public SicmGateDevDataRouter() {
        this.stringRedisTemplate = (StringRedisTemplate)SpringUtil.getBean((String)"stringRedisTemplate");
    }

    public void sendRTLog(SicmGateDeviceInfo dev, JSONObject data) {
        JSONObject rtLogJson = new JSONObject();
        try {
            rtLogJson.put(dev.devIp, (Object)data);
            this.stringRedisTemplate.opsForList().rightPush((Object)dev.rtLogQueneName, (Object)rtLogJson.toString());
            if ("sis".equals("sis") && !SicmGateDeviceInfo.activeQueneNameSet.contains(dev.rtLogQueneName)) {
                SicmGateDeviceInfo.activeQueneNameSet.add(dev.rtLogQueneName);
                this.stringRedisTemplate.opsForSet().add((Object)"SIS_GATE_RTLOG_QUENE_NAME_SET", (Object[])new String[]{dev.rtLogQueneName});
            }
        }
        catch (JSONException e) {
            this.logger.error((Object)"Sicm Gate Device sendRTLog() error", (Throwable)e);
        }
    }

    public void queryRTLog(SicmGateDeviceInfo dev, JSONObject data) {
        JSONObject rtLogJson = new JSONObject();
        try {
            rtLogJson.put(dev.devIp, (Object)data);
            this.stringRedisTemplate.opsForList().rightPush((Object)dev.queryQueneName, (Object)rtLogJson.toString());
            if ("sis".equals("sis") && !SicmGateDeviceInfo.queryQueneNameSet.contains(dev.queryQueneName)) {
                SicmGateDeviceInfo.queryQueneNameSet.add(dev.queryQueneName);
                this.stringRedisTemplate.opsForSet().add((Object)"SIS_GATE_QUERYLOG_QUENE_NAME_SET", (Object[])new String[]{dev.queryQueneName});
            }
        }
        catch (JSONException e) {
            this.logger.error((Object)"Sicm Gate Device queryRTLog() error", (Throwable)e);
        }
    }
}

