/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.auth.service.AuthSessionServcie;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.park.bean.ParkCheckOutInfo;
import com.zkteco.zkbiosecurity.park.constants.ParkConstants;
import com.zkteco.zkbiosecurity.park.remote.ParkRecordoutRemote;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingMeterService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordinService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordoutService;
import com.zkteco.zkbiosecurity.park.vo.ParkParkingMeterItem;
import com.zkteco.zkbiosecurity.park.vo.ParkRecordoutItem;
import com.zkteco.zkbiosecurity.park.vo.ParkTicketRecordItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryValueService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkRecordoutController
extends ExportController
implements ParkRecordoutRemote {
    @Autowired
    private ParkRecordoutService parkRecordoutService;
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired(required=false)
    private AuthSessionServcie authSessionServcie;
    @Autowired
    private ParkParkingMeterService parkParkingMeterService;
    @Autowired
    private BaseDictionaryValueService baseDictionaryValueService;
    @Autowired
    private ParkRecordinService parkRecordinService;

    @RequiresPermissions(value={"park:recordout"})
    public ModelAndView index() {
        StringBuffer showColumns = new StringBuffer();
        showColumns.append("!photoPathIn,dutyName");
        if ("lprCamera".equals(this.parkParamsService.getRunMode())) {
            showColumns.append(",cardNumber");
        }
        this.request.setAttribute("showColumns", (Object)showColumns);
        return new ModelAndView("park/recordout/parkRecordout");
    }

    @RequiresPermissions(value={"park:recordout:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.parkRecordoutService.getItemById(id));
        }
        return new ModelAndView("park/recordout/editParkRecordout");
    }

    @RequiresPermissions(value={"park:recordout:edit"})
    public ZKResultMsg save(ParkRecordoutItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.parkRecordoutService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(ParkRecordoutItem codition) {
        Pager pager = this.parkRecordoutService.getItemsByPage((BaseItem)this.setCodition(false, codition), this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="park_module", object="park_leftMenu_recordoutReport", opType="common_op_export", opContent="common_op_export")
    @RequiresPermissions(value={"park:recordout:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        ParkRecordoutItem parkRecordoutItem = new ParkRecordoutItem();
        this.setCodition(false, parkRecordoutItem);
        this.setConditionValue((BaseItem)parkRecordoutItem);
        List itemList = this.parkRecordoutService.getItemData(parkRecordoutItem, this.getBeginIndex(), this.getEndIndex());
        HashMap<String, Map> map = new HashMap<String, Map>();
        map.put("channelState", this.baseDictionaryValueService.getDictionaryValuesMap("parkChannelState"));
        map.put("eventType", this.baseDictionaryValueService.getDictionaryValuesMap("parkEventType"));
        map.put("photoPathOut", this.parkRecordinService.converPhotoMap());
        this.excelExport(itemList, ParkRecordoutItem.class, map);
    }

    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkRecordoutService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getPhotoByRecordoutId(@RequestParam(value="recordoutId") String recordoutId) {
        String photo = this.parkRecordoutService.getPhotoByRecordoutId(recordoutId);
        return new ZKResultMsg((Object)photo);
    }

    public ZKResultMsg manualReleaseOut(ParkCheckOutInfo parkCheckOutInfo) {
        this.parkRecordoutService.manualReleaseOut(parkCheckOutInfo, ParkConstants.PAVILIO_WEB);
        return new ZKResultMsg();
    }

    public ZKResultMsg fixCheckoutConfirm(ParkCheckOutInfo parkCheckOutInfo) {
        this.parkRecordoutService.fixCheckoutConfirm(parkCheckOutInfo);
        return new ZKResultMsg();
    }

    public ZKResultMsg tempCheckoutConfirm(ParkCheckOutInfo parkCheckOutInfo, ParkTicketRecordItem parkTicketRecordItem) {
        this.parkRecordoutService.tempCheckoutConfirm(parkCheckOutInfo, parkTicketRecordItem);
        return new ZKResultMsg();
    }

    public ZKResultMsg tempCheckoutFree(ParkCheckOutInfo parkCheckOutInfo) {
        this.parkRecordoutService.tempCheckoutFree(parkCheckOutInfo);
        return new ZKResultMsg();
    }

    public ZKResultMsg checkoutClose(String parkingMeterId) {
        ParkParkingMeterItem parkingMeterItem = this.parkParkingMeterService.getItemById(parkingMeterId);
        this.parkRecordoutService.restoreData(parkingMeterItem);
        return new ZKResultMsg();
    }

    public ZKResultMsg manualCorrect(ParkCheckOutInfo parkCheckOutInfo) {
        this.parkRecordoutService.manualCorrect(parkCheckOutInfo);
        return new ZKResultMsg();
    }

    public ZKResultMsg licenseCorrection(ParkCheckOutInfo parkCheckOutInfo) {
        this.parkRecordoutService.licenseCorrection(parkCheckOutInfo);
        return new ZKResultMsg();
    }

    public ZKResultMsg unMatch(ParkCheckOutInfo parkCheckOutInfo) {
        ZKResultMsg resultMsg = this.parkRecordoutService.unMatch(parkCheckOutInfo);
        return resultMsg;
    }

    public ZKResultMsg unMatchCharge(ParkCheckOutInfo parkCheckOutInfo) {
        this.parkRecordoutService.unMatchCharge(parkCheckOutInfo);
        return new ZKResultMsg();
    }

    public ZKResultMsg changeCarTypeCharge(ParkCheckOutInfo parkCheckOutInfo) {
        this.parkRecordoutService.changeCarTypeCharge(parkCheckOutInfo);
        return new ZKResultMsg();
    }

    public ZKResultMsg freeMinutesCharge(ParkCheckOutInfo parkCheckOutInfo, String deductibleHours) {
        ZKResultMsg resultMsg = this.parkRecordoutService.freeMinutesCharge(parkCheckOutInfo, deductibleHours);
        return resultMsg;
    }

    public ZKResultMsg centerCharge(ParkCheckOutInfo parkCheckOutInfo) {
        ZKResultMsg resultMsg = this.parkRecordoutService.centerCharge(parkCheckOutInfo);
        return resultMsg;
    }

    @LogRequest(module="park_module", object="park_leftMenu_floorVehicleReport", opType="park_terminalManagement_eveOut", requestParams={"names"}, opContent="park_terminalManagement_eveOut")
    @RequiresPermissions(value={"park:recordin:remove"})
    public ZKResultMsg RemoveOnSiteCar(@RequestParam(value="ids") String ids) {
        SecuritySubject securitySubject = this.authSessionServcie.getSecuritySubject(this.request.getSession().getId());
        this.parkRecordoutService.removeOnSiteCar(ids, securitySubject);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ModelAndView exceptionOutIndex() {
        StringBuffer showColumns = new StringBuffer();
        showColumns.append("!photoPathIn");
        if ("lprCamera".equals(this.parkParamsService.getRunMode())) {
            showColumns.append(",cardNumber");
        }
        this.request.setAttribute("showColumns", (Object)showColumns);
        return new ModelAndView("park/exceptionOutReport/parkExceptionOutReport");
    }

    public DxGrid exceptionOutList(ParkRecordoutItem codition) {
        Pager pager = this.parkRecordoutService.getItemsByPage((BaseItem)this.setCodition(true, codition), this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="park_module", object="park_leftMenu_exceptionOutReport", opType="common_op_export", opContent="common_op_export")
    @RequiresPermissions(value={"park:exceptionOutReport:export"})
    public void exportExceptionOut(HttpServletRequest request, HttpServletResponse response) {
        ParkRecordoutItem parkRecordoutItem = new ParkRecordoutItem();
        this.setCodition(true, parkRecordoutItem);
        this.setConditionValue((BaseItem)parkRecordoutItem);
        List itemList = this.parkRecordoutService.getItemData(parkRecordoutItem, this.getBeginIndex(), this.getEndIndex());
        HashMap<String, Map> map = new HashMap<String, Map>();
        map.put("channelState", this.baseDictionaryValueService.getDictionaryValuesMap("parkChannelState"));
        map.put("eventType", this.baseDictionaryValueService.getDictionaryValuesMap("parkEventType"));
        map.put("photoPathOut", this.parkRecordinService.converPhotoMap());
        this.excelExport(itemList, ParkRecordoutItem.class, map);
    }

    private ParkRecordoutItem setCodition(boolean isExceptionOut, ParkRecordoutItem parkRecordoutItem) {
        parkRecordoutItem.setChannelStateNot(ParkConstants.CHANNEL_STATE_CENT_PAY);
        if (isExceptionOut) {
            parkRecordoutItem.setEventTypeIn(ParkConstants.EVENT_ARTIFICIAL_GATE + "," + ParkConstants.EVENT_LICENSE_CORRECTION + "," + ParkConstants.EVENT_LICENSE_UNMATCH);
        }
        return parkRecordoutItem;
    }

    public ZKResultMsg viewInfo(@RequestParam(value="license") String license, @RequestParam(value="ipAddress", required=false) String ipAddress, @RequestParam(value="amountReceiveble") String amountReceiveble) {
        this.parkRecordoutService.viewInfo(license, ipAddress, amountReceiveble);
        return new ZKResultMsg();
    }

    public ZKResultMsg whetherPay(@RequestParam(value="license") String license) {
        boolean msg = this.parkRecordoutService.whetherPay(license);
        return ZKResultMsg.msg((boolean)msg);
    }

    public ZKResultMsg openGateByChannelId(ParkCheckOutInfo parkCheckOutInfo) {
        ZKResultMsg resultMsg = this.parkRecordoutService.openGateByChannelId(parkCheckOutInfo);
        return resultMsg;
    }
}

