/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseService;
import com.zkteco.zkbiosecurity.park.enums.ParkViewEnum;
import com.zkteco.zkbiosecurity.park.remote.ParkParamsRemote;
import com.zkteco.zkbiosecurity.park.service.ParkCacheService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.utils.ParkI18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkParamsController
extends BaseController
implements ParkParamsRemote {
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired(required=false)
    private BaseLicenseService baseLicenseService;
    @Autowired
    private ParkCacheService parkCacheService;
    @Value(value="${cloud.server.park.pay.url:${cloud.server.url:}/BiosecurityPark/portal/pay?payTransfer}")
    private String cloudServerParkPayUrl;

    @RequiresPermissions(value={"park:params"})
    public ModelAndView index() {
        Map parkParams = this.parkParamsService.getParkParams();
        this.request.setAttribute("parkParams", (Object)parkParams);
        return new ModelAndView("park/params/parkParams");
    }

    @RequiresPermissions(value={"park:params:edit"})
    @LogRequest(module="park_module", object="park_params", opType="park_params_edit", opContent="common_leftMenu_paramSet")
    public ZKResultMsg save(@RequestParam Map<String, String> params) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemtList = this.parkParamsService.saveParkParams(params);
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemtList));
        if ("true".equals(params.get("park.syncDataToCloud"))) {
            this.parkParamsService.syncBaseDataToCloud();
        }
        return res;
    }

    public ZKResultMsg getParams() {
        ZKResultMsg res = new ZKResultMsg((Object)this.parkParamsService.getParkParams());
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg getPayQrcode() {
        ZKResultMsg res = new ZKResultMsg();
        String appId = this.baseLicenseService.getAppId();
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            res.setMsg("");
            res.setData((Object)(this.cloudServerParkPayUrl + "&appId=" + appId));
        } else {
            res.setMsg(I18nUtil.i18nCode((String)"park_parkingLotSet_registToCloud", (Object[])new Object[0]));
        }
        return res;
    }

    public ZKResultMsg isRegistCloud() {
        ZKResultMsg res = new ZKResultMsg();
        String appId = this.baseLicenseService.getAppId();
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            res.setData((Object)true);
        } else {
            res.setData((Object)false);
            res.setMsg(I18nUtil.i18nCode((String)"park_parkingLotSet_registToCloud", (Object[])new Object[0]));
        }
        return res;
    }

    public ZKResultMsg getDiskInfo(@RequestParam(value="photoSavePath") String photoSavePath) {
        return this.parkParamsService.getDiskInfo(photoSavePath);
    }

    public ZKResultMsg getViewCodeSelectItem() {
        List selectItems = ParkViewEnum.getViewCodeSelectItem();
        return new ZKResultMsg((Object)selectItems);
    }

    public ZKResultMsg parkDebugging() {
        String logger = "0";
        String parkLogger = this.parkCacheService.getStr("park:logger");
        if ("0".equals(parkLogger)) {
            logger = "1";
        }
        this.parkCacheService.set("park:logger", (Object)logger, 0L);
        return new ZKResultMsg();
    }
}

