/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.io.IOException;
import java.text.BreakIterator;
import java.text.spi.BreakIteratorProvider;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import sun.util.locale.provider.AvailableLanguageTags;
import sun.util.locale.provider.DictionaryBasedBreakIterator;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.LocaleResources;
import sun.util.locale.provider.RuleBasedBreakIterator;

public class BreakIteratorProviderImpl
extends BreakIteratorProvider
implements AvailableLanguageTags {
    private static final int CHARACTER_INDEX = 0;
    private static final int WORD_INDEX = 1;
    private static final int LINE_INDEX = 2;
    private static final int SENTENCE_INDEX = 3;
    private final LocaleProviderAdapter.Type type;
    private final Set<String> langtags;

    public BreakIteratorProviderImpl(LocaleProviderAdapter.Type type, Set<String> langtags) {
        this.type = type;
        this.langtags = langtags;
    }

    @Override
    public Locale[] getAvailableLocales() {
        return LocaleProviderAdapter.toLocaleArray(this.langtags);
    }

    @Override
    public BreakIterator getWordInstance(Locale locale) {
        return this.getBreakInstance(locale, 1, "WordData", "WordDictionary");
    }

    @Override
    public BreakIterator getLineInstance(Locale locale) {
        return this.getBreakInstance(locale, 2, "LineData", "LineDictionary");
    }

    @Override
    public BreakIterator getCharacterInstance(Locale locale) {
        return this.getBreakInstance(locale, 0, "CharacterData", "CharacterDictionary");
    }

    @Override
    public BreakIterator getSentenceInstance(Locale locale) {
        return this.getBreakInstance(locale, 3, "SentenceData", "SentenceDictionary");
    }

    private BreakIterator getBreakInstance(Locale locale, int type, String dataName, String dictionaryName) {
        if (locale == null) {
            throw new NullPointerException();
        }
        LocaleResources lr = LocaleProviderAdapter.forJRE().getLocaleResources(locale);
        String[] classNames = (String[])lr.getBreakIteratorInfo("BreakIteratorClasses");
        String dataFile = (String)lr.getBreakIteratorInfo(dataName);
        try {
            switch (classNames[type]) {
                case "RuleBasedBreakIterator": {
                    return new RuleBasedBreakIterator(dataFile);
                }
                case "DictionaryBasedBreakIterator": {
                    String dictionaryFile = (String)lr.getBreakIteratorInfo(dictionaryName);
                    return new DictionaryBasedBreakIterator(dataFile, dictionaryFile);
                }
            }
            throw new IllegalArgumentException("Invalid break iterator class \"" + classNames[type] + "\"");
        }
        catch (IOException | IllegalArgumentException | MissingResourceException e) {
            throw new InternalError(e.toString(), e);
        }
    }

    @Override
    public Set<String> getAvailableLanguageTags() {
        return this.langtags;
    }

    @Override
    public boolean isSupportedLocale(Locale locale) {
        return LocaleProviderAdapter.isSupportedLocale(locale, this.type, this.langtags);
    }
}

